/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.thief.mixin.bed_crimes;

import com.mojang.datafixers.util.Either;
import io.github.mortuusars.thief.Config;
import io.github.mortuusars.thief.world.PotentialCrime;
import io.github.mortuusars.thief.world.Witness;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends LivingEntity {
    protected PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"startSleepInBed(Lnet/minecraft/core/BlockPos;)Lcom/mojang/datafixers/util/Either;"}, at={@At(value="HEAD")})
    private void onStartSleepInBed(BlockPos bedPos, CallbackInfoReturnable<Either<Player.BedSleepingProblem, Unit>> cir) {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        ((PotentialCrime)((Object)Config.Server.CRIME_FOR_SLEEPING_IN_VILLAGERS_BED.get())).getCrime().ifPresent(crime -> {
            List<Villager> witnesses = Witness.getWitnesses((LivingEntity)((Player)this), Villager.class);
            for (Villager witness : witnesses) {
                if (!witness.getBrain().getMemory(MemoryModuleType.HOME).map(p -> p.pos().equals((Object)bedPos)).orElse(false).booleanValue()) continue;
                crime.commit(level2, this, bedPos);
                return;
            }
        });
    }
}

