/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.thief.neoforge.event;

import com.mojang.brigadier.CommandDispatcher;
import io.github.mortuusars.thief.event.CommonEvents;
import io.github.mortuusars.thief.event.ServerEvents;
import io.github.mortuusars.thief.neoforge.RegisterImpl;
import io.github.mortuusars.thief.network.neoforge.PacketsImpl;
import io.github.mortuusars.thief.network.packet.C2SPackets;
import io.github.mortuusars.thief.network.packet.CommonPackets;
import io.github.mortuusars.thief.network.packet.S2CPackets;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class NeoForgeCommonEvents {

    @EventBusSubscriber(modid="thief", bus=EventBusSubscriber.Bus.GAME)
    public static class GameBus {
        @SubscribeEvent
        public static void onBlockDestroyed(BlockEvent.BreakEvent event) {
            Player player = event.getPlayer();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ServerEvents.onBlockDestroyedByPlayer(serverPlayer, event.getPos(), event.getState());
            }
        }

        @SubscribeEvent
        public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ServerEvents.onBlockInteract(serverPlayer, event.getPos(), event.getHand());
            }
        }

        @SubscribeEvent
        public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
            if (CommonEvents.onEntityInteracted(event.getEntity(), event.getHand(), event.getTarget()) != InteractionResult.PASS) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onEntityInteract(LivingDeathEvent event) {
            Entity entity = event.getSource().getEntity();
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                ServerEvents.onEntityKilled(player, event.getEntity(), event.getSource());
            }
        }

        @SubscribeEvent
        public static void onPlayerTick(PlayerTickEvent.Post event) {
            CommonEvents.onPlayerTick(event.getEntity());
        }

        @SubscribeEvent
        public static void registerCommands(RegisterCommandsEvent event) {
            CommonEvents.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
        }
    }

    @EventBusSubscriber(modid="thief", bus=EventBusSubscriber.Bus.MOD)
    public static class ModBus {
        @SubscribeEvent
        public static void commonSetup(FMLCommonSetupEvent event) {
            event.enqueueWork(() -> {
                for (Map.Entry<ResourceLocation, StatFormatter> entry : RegisterImpl.STATS.entrySet()) {
                    Stats.CUSTOM.get((Object)entry.getKey(), entry.getValue());
                }
            });
        }

        @SubscribeEvent
        public static void registerPackets(RegisterPayloadHandlersEvent event) {
            PayloadRegistrar registrar = event.registrar("1");
            for (CustomPacketPayload.TypeAndCodec<? extends FriendlyByteBuf, ? extends CustomPacketPayload> definition : S2CPackets.getDefinitions()) {
                registrar.playToClient(definition.type(), definition.codec(), PacketsImpl::handle);
            }
            for (CustomPacketPayload.TypeAndCodec<? extends FriendlyByteBuf, ? extends CustomPacketPayload> definition : C2SPackets.getDefinitions()) {
                registrar.playToServer(definition.type(), definition.codec(), PacketsImpl::handle);
            }
            for (CustomPacketPayload.TypeAndCodec<? extends FriendlyByteBuf, ? extends CustomPacketPayload> definition : CommonPackets.getDefinitions()) {
                registrar.playBidirectional(definition.type(), definition.codec(), PacketsImpl::handle);
            }
        }
    }
}

