/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.thief.world;

import com.mojang.logging.LogUtils;
import io.github.mortuusars.thief.Config;
import io.github.mortuusars.thief.Thief;
import io.github.mortuusars.thief.api.witness.WitnessReaction;
import io.github.mortuusars.thief.world.PotentialCrime;
import io.github.mortuusars.thief.world.Reputation;
import io.github.mortuusars.thief.world.Witness;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;

public enum Crime implements ReputationEventType
{
    LIGHT("light"),
    MEDIUM("medium"),
    HEAVY("heavy");

    private static final Logger LOGGER;
    private final String name;

    private Crime(String name) {
        this.name = name;
    }

    public static boolean isInProtectedStructure(ServerLevel level, BlockPos pos) {
        return level.structureManager().getStructureWithPieceAt(pos, Thief.Tags.Structures.PROTECTED).isValid();
    }

    public String getName() {
        return this.name;
    }

    public int getMajorNegativeChange() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> (Integer)Config.Server.PUNISHMENT_LIGHT_MAJOR_NEGATIVE.get();
            case 1 -> (Integer)Config.Server.PUNISHMENT_MEDIUM_MAJOR_NEGATIVE.get();
            case 2 -> (Integer)Config.Server.PUNISHMENT_HEAVY_MAJOR_NEGATIVE.get();
        };
    }

    public int getMinorNegativeChange() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> (Integer)Config.Server.PUNISHMENT_LIGHT_MINOR_NEGATIVE.get();
            case 1 -> (Integer)Config.Server.PUNISHMENT_MEDIUM_MINOR_NEGATIVE.get();
            case 2 -> (Integer)Config.Server.PUNISHMENT_HEAVY_MINOR_NEGATIVE.get();
        };
    }

    public ResourceLocation getStat() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> Thief.Stats.CAUGHT_ON_VILLAGE_LIGHT_THEFTS.get();
            case 1 -> Thief.Stats.CAUGHT_ON_VILLAGE_MEDIUM_THEFTS.get();
            case 2 -> Thief.Stats.CAUGHT_ON_VILLAGE_HEAVY_THEFTS.get();
        };
    }

    public boolean isOverGuardAttackThreshold() {
        return ((PotentialCrime)((Object)Config.Server.GUARD_ATTACK_THRESHOLD.get())).getCrime().map(crime -> this.ordinal() >= crime.ordinal()).orElse(false);
    }

    public boolean shouldGuardsAttack(ServerLevel level, LivingEntity witness, LivingEntity criminal) {
        return this.isOverGuardAttackThreshold() && !Reputation.averageFromCrowd(criminal, Witness.getWitnesses(criminal)).ignores(this);
    }

    public String toString() {
        return this.name;
    }

    public Outcome commit(ServerLevel level, LivingEntity criminal, BlockPos crimeTargetPosition) {
        if (((Boolean)Config.Server.HERO_OF_THE_VILLAGE_CAN_STEAL.get()).booleanValue() && criminal.hasEffect(MobEffects.HERO_OF_THE_VILLAGE)) {
            return Outcome.NONE;
        }
        if (((Boolean)Config.Server.CRIME_ONLY_IN_PROTECTED_STRUCTURE.get()).booleanValue() && !Crime.isInProtectedStructure(level, crimeTargetPosition)) {
            return Outcome.NONE;
        }
        List<LivingEntity> witnesses = Witness.getWitnesses(criminal);
        if (witnesses.isEmpty()) {
            return Outcome.NONE;
        }
        Reputation reputation = Reputation.averageFromCrowd(criminal, witnesses);
        if (reputation.ignores(this)) {
            return Outcome.NONE;
        }
        for (LivingEntity witness : witnesses) {
            WitnessReaction.handle(level, this, witness, criminal);
        }
        if (criminal instanceof Player) {
            Player player = (Player)criminal;
            player.displayClientMessage((Component)Component.translatable((String)("gui.thief.crime_commited." + this.getName())), true);
            player.awardStat(this.getStat());
        }
        LOGGER.debug("{} with average reputation '{}', has commited a {} crime and was seen by {} witnesses.", new Object[]{criminal.getName(), reputation.getName(), this.getName(), witnesses.size()});
        return new Outcome(true, witnesses);
    }

    public static PotentialCrime fromBlockStateBreaking(ServerPlayer player, BlockPos pos, BlockState state) {
        if (state.is(Thief.Tags.Blocks.BREAK_PROTECTED_HEAVY)) {
            return PotentialCrime.HEAVY;
        }
        if (state.is(Thief.Tags.Blocks.BREAK_PROTECTED_MEDIUM)) {
            return PotentialCrime.MEDIUM;
        }
        if (state.is(Thief.Tags.Blocks.BREAK_PROTECTED_LIGHT)) {
            return PotentialCrime.LIGHT;
        }
        return PotentialCrime.NONE;
    }

    public static PotentialCrime fromBlockStateInteracting(ServerPlayer player, BlockPos pos, BlockState state) {
        if (state.is(Thief.Tags.Blocks.INTERACT_PROTECTED_HEAVY)) {
            return PotentialCrime.HEAVY;
        }
        if (state.is(Thief.Tags.Blocks.INTERACT_PROTECTED_MEDIUM)) {
            return PotentialCrime.MEDIUM;
        }
        if (state.is(Thief.Tags.Blocks.INTERACT_PROTECTED_LIGHT)) {
            return PotentialCrime.LIGHT;
        }
        return PotentialCrime.NONE;
    }

    public static PotentialCrime fromKilling(ServerPlayer player, LivingEntity target) {
        if (target.getType().is(Thief.Tags.EntityTypes.KILLING_PROTECTED_HEAVY)) {
            return PotentialCrime.HEAVY;
        }
        if (target.getType().is(Thief.Tags.EntityTypes.KILLING_PROTECTED_MEDIUM)) {
            return PotentialCrime.MEDIUM;
        }
        if (target.getType().is(Thief.Tags.EntityTypes.KILLING_PROTECTED_LIGHT)) {
            return PotentialCrime.LIGHT;
        }
        return PotentialCrime.NONE;
    }

    static {
        LOGGER = LogUtils.getLogger();
    }

    public record Outcome(boolean punished, List<LivingEntity> witnesses) {
        public static final Outcome NONE = new Outcome(false, Collections.emptyList());
    }
}

