/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.thief.world;

import io.github.mortuusars.thief.Config;
import io.github.mortuusars.thief.world.Crime;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;

public enum Reputation {
    HATED("hated", -46775),
    UNWELCOME("unwelcome", -30642),
    DISTRUSTED("distrusted", -85415),
    NEUTRAL("neutral", -1863),
    ACCEPTED("accepted", -1048702),
    RESPECTED("respected", -7409577),
    HONORED("honored", -11206711);

    private final String name;
    private final int color;

    private Reputation(String name, int color) {
        this.name = name;
        this.color = color;
    }

    public String getName() {
        return this.name;
    }

    public int getColor() {
        return this.color;
    }

    public MutableComponent getLocalizedName() {
        return Component.translatable((String)("gui.thief.reputation." + this.name));
    }

    public MutableComponent getLocalizedNameWithColor() {
        return this.getLocalizedName().withStyle(Style.EMPTY.withColor(this.color));
    }

    public MutableComponent getLocalizedDescription() {
        return Component.translatable((String)("gui.thief.reputation." + this.name + ".description"));
    }

    public boolean isLowerOrEqualTo(Reputation reputation) {
        return this.ordinal() <= reputation.ordinal();
    }

    public boolean isGreaterOrEqualTo(Reputation reputation) {
        return this.ordinal() >= reputation.ordinal();
    }

    public boolean ignores(Crime crime) {
        return switch (crime) {
            default -> throw new MatchException(null, null);
            case Crime.LIGHT -> this.isGreaterOrEqualTo(ACCEPTED);
            case Crime.MEDIUM -> this.isGreaterOrEqualTo(RESPECTED);
            case Crime.HEAVY -> this.isGreaterOrEqualTo(HONORED);
        };
    }

    public boolean canTrade() {
        return this.isGreaterOrEqualTo((Reputation)((Object)Config.Server.TRADE_REPUTATION_THRESHOLD.get()));
    }

    public static Reputation fromValue(Villager villager, LivingEntity entity) {
        int reputation = villager.getGossips().getReputation(entity.getUUID(), gossipType -> true);
        return Reputation.fromValue(reputation);
    }

    public static Reputation fromValue(int reputation) {
        if (reputation <= -100) {
            return HATED;
        }
        if (reputation <= -50) {
            return UNWELCOME;
        }
        if (reputation < 0) {
            return DISTRUSTED;
        }
        if (reputation < 10) {
            return NEUTRAL;
        }
        if (reputation < 20) {
            return ACCEPTED;
        }
        if (reputation < 30) {
            return RESPECTED;
        }
        return HONORED;
    }

    public static int averageValueFromVillagers(LivingEntity subject, List<Villager> villagers) {
        return (int)villagers.stream().mapToInt(villager -> villager.getGossips().getReputation(subject.getUUID(), gossipType -> true)).average().orElse(0.0);
    }

    public static Reputation averageFromVillagers(LivingEntity subject, List<Villager> villagers) {
        return Reputation.fromValue(Reputation.averageValueFromVillagers(subject, villagers));
    }

    public static int averageValueFromCrowd(LivingEntity entity, List<LivingEntity> crowd) {
        return (int)crowd.stream().mapToInt(e -> Reputation.valueOf(entity, e)).average().orElse(0.0);
    }

    public static Reputation averageFromCrowd(LivingEntity subject, List<LivingEntity> crowd) {
        return Reputation.fromValue(Reputation.averageValueFromCrowd(subject, crowd));
    }

    public static int valueOf(LivingEntity subject, LivingEntity entityWithReputation) {
        if (entityWithReputation instanceof Villager) {
            Villager villager = (Villager)entityWithReputation;
            return villager.getGossips().getReputation(subject.getUUID(), gossipType -> true);
        }
        return 0;
    }
}

