/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.thief.world;

import io.github.mortuusars.thief.Config;
import io.github.mortuusars.thief.Thief;
import io.github.mortuusars.thief.world.stealth.Stealth;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class Witness {
    public static List<LivingEntity> getWitnesses(LivingEntity criminal) {
        Player player;
        if (criminal instanceof Player && ((player = (Player)criminal).isCreative() || player.isSpectator())) {
            return Collections.emptyList();
        }
        double visibility = Stealth.getVisibility(criminal);
        int radius = (Integer)Config.Server.WITNESS_MAX_DISTANCE.get();
        AABB crimeScene = new AABB(criminal.blockPosition()).inflate((double)radius, (double)((float)radius * 0.5f), (double)radius);
        return criminal.level().getEntitiesOfClass(LivingEntity.class, crimeScene).stream().filter(e -> Witness.isWitness(criminal, e, visibility)).toList();
    }

    public static <T extends LivingEntity> List<T> getWitnesses(LivingEntity criminal, Class<T> entityClass) {
        Player player;
        if (criminal instanceof Player && ((player = (Player)criminal).isCreative() || player.isSpectator())) {
            return Collections.emptyList();
        }
        double visibility = Stealth.getVisibility(criminal);
        int radius = (Integer)Config.Server.WITNESS_MAX_DISTANCE.get();
        AABB crimeScene = new AABB(criminal.blockPosition()).inflate((double)radius, (double)((float)radius * 0.5f), (double)radius);
        return criminal.level().getEntitiesOfClass(entityClass, crimeScene).stream().filter(e -> Witness.isWitness(criminal, e, visibility)).toList();
    }

    public static boolean isWitness(LivingEntity criminal, LivingEntity entity, double visibility) {
        if (!entity.getType().is(Thief.Tags.EntityTypes.WITNESSES)) {
            return false;
        }
        float distance = entity.distanceTo((Entity)criminal);
        if ((double)distance <= (double)((Integer)Config.Server.WITNESS_ALWAYS_NOTICE_DISTANCE.get()).intValue() / 2.0) {
            return true;
        }
        if (entity.isSleeping()) {
            return false;
        }
        if (distance <= (float)((Integer)Config.Server.WITNESS_ALWAYS_NOTICE_DISTANCE.get()).intValue()) {
            return true;
        }
        if ((double)distance > (double)((Integer)Config.Server.WITNESS_MAX_DISTANCE.get()).intValue() * visibility) {
            return false;
        }
        return entity.hasLineOfSight((Entity)criminal);
    }
}

