/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.thief.world.stealth.modifier;

import io.github.mortuusars.thief.world.stealth.Stealth;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;

public class DarknessModifier
implements Stealth.VisibilityModifier {
    @Override
    public double modify(LivingEntity entity, double value) {
        int lightLevel = DarknessModifier.getLightLevelAt(entity.level(), entity.blockPosition());
        return value * (double)Mth.map((float)lightLevel, (float)0.0f, (float)15.0f, (float)0.25f, (float)1.0f);
    }

    public static int getLightLevelAt(Level level, BlockPos pos) {
        if (level.isClientSide) {
            level.updateSkyBrightness();
        }
        int skyBrightness = level.getBrightness(LightLayer.SKY, pos);
        int blockBrightness = level.getBrightness(LightLayer.BLOCK, pos);
        return skyBrightness < 15 ? Math.max(blockBrightness, (int)((float)skyBrightness * ((float)(15 - level.getSkyDarken()) / 15.0f))) : Math.max(blockBrightness, 15 - level.getSkyDarken());
    }
}

