/*
 * Decompiled with CFR 0.152.
 */
package ru.Terra.commands;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import ru.Terra.rancam;
import ru.Terra.utils.CameraLists;
import ru.Terra.utils.CameraManager;
import ru.Terra.utils.DataManager;
import ru.Terra.utils.Messages;
import ru.Terra.utils.PlayerCam;

public class RanCMD
implements CommandExecutor,
TabCompleter {
    private static JavaPlugin plugin = rancam.getInstance();
    private static Logger log = plugin.getLogger();
    private static File dataFile = new File(plugin.getDataFolder(), "data.yml");
    private static YamlConfiguration dataConfig = YamlConfiguration.loadConfiguration((File)dataFile);

    public boolean onCommand(CommandSender commandSender, Command command, String s, String[] strings) {
        Player player;
        if (!(commandSender instanceof Player)) {
            player = null;
            if (strings[0].equalsIgnoreCase("delete")) {
                try {
                    CameraManager.DeleteCons(Integer.parseInt(strings[1]));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    log.severe(Messages.CAMERA_INVALID_FORMAT.toString());
                }
                return true;
            }
            if (strings[0].equalsIgnoreCase("stop")) {
                PlayerCam.cameraStop(player, "console");
                return true;
            }
            if (strings[0].equalsIgnoreCase("start")) {
                String folderCameraListsPath = "plugins/rancam/cameralist";
                String fileCamerasListName = String.valueOf(CameraLists.getCurrentRanCameraList()) + ".yml";
                File fileCameraLists = new File(folderCameraListsPath, fileCamerasListName);
                YamlConfiguration confCameraLists = YamlConfiguration.loadConfiguration((File)fileCameraLists);
                try {
                    if (confCameraLists.contains("cameras.")) {
                        if (DataManager.getInCam().equalsIgnoreCase("interactive")) {
                            PlayerCam.cameraEnable(strings[1], player, "console", "interactive");
                        } else if (DataManager.getInCam().equalsIgnoreCase("nonInteractive")) {
                            PlayerCam.cameraEnable(strings[1], player, "console", "nonInteractive");
                        } else if (!Objects.equals(DataManager.getInCam(), "interactive") && !Objects.equals(DataManager.getInCam(), "nonInteractive")) {
                            log.severe(Messages.CAMERA_WRONG_MODE.toString());
                        }
                    } else {
                        log.severe(Messages.CAMERA_LIST_EMPTY.toString());
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    log.severe(Messages.CAMERA_INVALID_FORMAT.toString());
                }
                return true;
            }
            if (strings.length == 1 && strings[0].equalsIgnoreCase("reload")) {
                CameraManager.reload();
                log.info(Messages.COMMAND_RELOAD.toString());
                return true;
            }
            if (strings[0].equalsIgnoreCase("mode")) {
                DataManager.setInCam(strings[1]);
                log.severe(Messages.CAMERA_MODE.toString().replace("%mode%", strings[1]));
                return true;
            }
            if (strings[0].equalsIgnoreCase("lists")) {
                if (strings[1].equalsIgnoreCase("create")) {
                    try {
                        CameraLists.createList(strings[2]);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    log.info(Messages.CAMERA_LIST_CREATE.toString().replace("%list%", strings[2]));
                    return true;
                }
                if (strings[1].equalsIgnoreCase("get")) {
                    log.info(CameraLists.getCurrentRanCameraList());
                    log.info(CameraLists.getCurrentHandCameraList());
                    return true;
                }
                if (strings[1].equalsIgnoreCase("set")) {
                    if (strings[2].equalsIgnoreCase("CurrentRanCameraList")) {
                        CameraLists.setCurrentRanCameraList(strings[3]);
                        log.info(Messages.CAMERA_LIST_SET.toString().replace("%list%", strings[3]));
                    }
                    if (strings[2].equalsIgnoreCase("CurrentHandCameraList")) {
                        CameraLists.setCurrentHandCameraList(strings[3]);
                        log.info(Messages.CAMERA_LIST_SET.toString().replace("%list%", strings[3]));
                    }
                    return true;
                }
                if (strings[1].equalsIgnoreCase("delete")) {
                    CameraLists.deleteList(strings[2]);
                    log.info(Messages.CAMERA_LIST_DELETE.toString().replace("%list%", strings[2]));
                    return true;
                }
            }
        }
        if (commandSender instanceof Player) {
            player = (Player)commandSender;
            if (player.hasPermission("rancam.list") && strings[0].equalsIgnoreCase("list")) {
                String folderCameraListsPath = "plugins/rancam/cameralist";
                String fileCamerasListName = String.valueOf(CameraLists.getCurrentRanCameraList()) + ".yml";
                File fileCameraLists = new File(folderCameraListsPath, fileCamerasListName);
                YamlConfiguration confCameraLists = YamlConfiguration.loadConfiguration((File)fileCameraLists);
                if (confCameraLists.contains("cameras")) {
                    List<Integer> kamerasID = CameraManager.getCameraIds(CameraLists.getCurrentRanCameraList());
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "CONFIG: " + String.valueOf(ChatColor.WHITE) + CameraLists.getCurrentRanCameraList() + ".yml");
                    for (Integer id : kamerasID) {
                        HashMap<String, Object> WXYZ = CameraManager.getCamerasWXYZ(id);
                        Pattern pattern = Pattern.compile("CraftWorld\\{name=(.*)\\}");
                        Matcher matcher = pattern.matcher(String.valueOf(WXYZ.get("world")));
                        if (matcher.find()) {
                            String worldName = matcher.group(1);
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "ID: " + id + ":\n   " + String.valueOf(ChatColor.WHITE) + " WORLD: " + String.valueOf(ChatColor.GRAY) + worldName + String.valueOf(ChatColor.WHITE) + ", X: " + String.valueOf(ChatColor.GRAY) + String.valueOf(WXYZ.get("X")) + String.valueOf(ChatColor.WHITE) + ", Y: " + String.valueOf(ChatColor.GRAY) + String.valueOf(WXYZ.get("Y")) + String.valueOf(ChatColor.WHITE) + ", Z: " + String.valueOf(ChatColor.GRAY) + String.valueOf(WXYZ.get("Z")) + String.valueOf(ChatColor.WHITE) + ", TITLE: " + String.valueOf(ChatColor.GRAY) + confCameraLists.getString("cameras." + id + ".title"));
                            continue;
                        }
                        if (confCameraLists.getKeys(false).isEmpty()) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + Messages.CAMERA_INVALID_FORMAT.toString());
                            continue;
                        }
                        player.sendMessage(String.valueOf(ChatColor.RED) + Messages.CAMERA_INVALID_FORMAT.toString());
                    }
                    return true;
                }
                player.sendMessage(String.valueOf(ChatColor.RED) + Messages.CAMERA_LIST_EMPTY.toString());
                return true;
            }
            if (player.hasPermission("rancam.rancam")) {
                if (strings.length == 1 && strings[0].equalsIgnoreCase("reload")) {
                    CameraManager.reload();
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + Messages.COMMAND_RELOAD.toString());
                    return true;
                }
                if (strings[0].equalsIgnoreCase("delete")) {
                    try {
                        CameraManager.Delete(Integer.parseInt(strings[1]), player);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + Messages.CAMERA_INVALID_FORMAT.toString());
                    }
                    return true;
                }
                if (strings[0].equalsIgnoreCase("create")) {
                    try {
                        int id = Integer.parseInt(strings[1]);
                        Location location = player.getLocation();
                        String title = String.join((CharSequence)" ", Arrays.copyOfRange(strings, 2, strings.length));
                        CameraManager.Create(id, String.valueOf(location), title, player);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + Messages.CAMERA_INVALID_FORMAT.toString());
                    }
                    return true;
                }
                if (strings[0].equalsIgnoreCase("teleport")) {
                    try {
                        CameraManager.Teleport(Integer.parseInt(strings[1]), player);
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + Messages.CAMERA_INVALID_FORMAT.toString());
                    }
                    return true;
                }
                if (strings[0].equalsIgnoreCase("start")) {
                    String folderCameraListsPath = "plugins/rancam/cameralist";
                    String fileCamerasListName = String.valueOf(CameraLists.getCurrentRanCameraList()) + ".yml";
                    File fileCameraLists = new File(folderCameraListsPath, fileCamerasListName);
                    YamlConfiguration confCameraLists = YamlConfiguration.loadConfiguration((File)fileCameraLists);
                    try {
                        if (confCameraLists.contains("cameras.")) {
                            if (DataManager.getInCam().equalsIgnoreCase("interactive")) {
                                PlayerCam.cameraEnable(strings[1], player, "player", "interactive");
                            } else if (DataManager.getInCam().equalsIgnoreCase("nonInteractive")) {
                                PlayerCam.cameraEnable(strings[1], player, "player", "nonInteractive");
                            } else if (!Objects.equals(DataManager.getInCam(), "interactive") && !Objects.equals(DataManager.getInCam(), "nonInteractive")) {
                                player.sendMessage(String.valueOf(ChatColor.RED) + Messages.CAMERA_WRONG_MODE.toString());
                            }
                        } else {
                            player.sendMessage(String.valueOf(ChatColor.RED) + Messages.CAMERA_LIST_EMPTY.toString());
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + Messages.CAMERA_INVALID_FORMAT.toString());
                    }
                    return true;
                }
                if (strings[0].equalsIgnoreCase("stop")) {
                    PlayerCam.cameraStop(player, "player");
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + Messages.CAMERA_TOGGLED_OFF.toString());
                    return true;
                }
                if (strings[0].equalsIgnoreCase("mode")) {
                    DataManager.setInCam(strings[1]);
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + Messages.CAMERA_MODE.toString().replace("%mode%", strings[1]));
                    return true;
                }
                if (strings[0].equalsIgnoreCase("get") && strings[1].equalsIgnoreCase("mode")) {
                    File dataFile = new File(plugin.getDataFolder(), "data.yml");
                    YamlConfiguration dataConfig = YamlConfiguration.loadConfiguration((File)dataFile);
                    player.sendMessage(DataManager.getInCam());
                    return true;
                }
                if (strings[0].equalsIgnoreCase("lists")) {
                    if (strings[1].equalsIgnoreCase("create")) {
                        try {
                            CameraLists.createList(strings[2]);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + Messages.CAMERA_LIST_CREATE.toString().replace("%list%", strings[2]));
                        return true;
                    }
                    if (strings[1].equalsIgnoreCase("get")) {
                        player.sendMessage(CameraLists.getCurrentRanCameraList());
                        player.sendMessage(CameraLists.getCurrentHandCameraList());
                        return true;
                    }
                    if (strings[1].equalsIgnoreCase("set")) {
                        if (strings[2].equalsIgnoreCase("CurrentRanCameraList")) {
                            CameraLists.setCurrentRanCameraList(strings[3]);
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + Messages.CAMERA_LIST_SET.toString().replace("%list%", strings[3]));
                        }
                        if (strings[2].equalsIgnoreCase("CurrentHandCameraList")) {
                            CameraLists.setCurrentHandCameraList(strings[3]);
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + Messages.CAMERA_LIST_SET.toString().replace("%list%", strings[3]));
                        }
                        return true;
                    }
                    if (strings[1].equalsIgnoreCase("delete")) {
                        CameraLists.deleteList(strings[2]);
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + Messages.CAMERA_LIST_DELETE.toString().replace("%list%", strings[2]));
                        return true;
                    }
                }
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String s, String[] strings) {
        if (strings.length == 1) {
            return List.of("reload", "create", "teleport", "delete", "list", "start", "stop", "mode", "lists");
        }
        if (strings.length == 2) {
            if (strings[0].equalsIgnoreCase("create")) {
                String folderCameraListsPath = "plugins/rancam/cameralist";
                String fileCamerasListName = String.valueOf(CameraLists.getCurrentRanCameraList()) + ".yml";
                File fileCameraLists = new File(folderCameraListsPath, fileCamerasListName);
                YamlConfiguration confCameraLists = YamlConfiguration.loadConfiguration((File)fileCameraLists);
                List cameras = CameraManager.getCameraIds(CameraLists.getCurrentRanCameraList()).stream().toList();
                int maxCam = (Integer)cameras.stream().max(Integer::compare).orElseThrow(() -> new IllegalArgumentException("Set is empty"));
                List<String> max = Collections.singletonList(String.valueOf(maxCam + 1));
                return max;
            }
            if (strings[0].equalsIgnoreCase("delete") || strings[0].equalsIgnoreCase("teleport")) {
                File fileCameraList = new File("plugins/rancam/cameralist", CameraLists.getCurrentRanCameraList() + ".yml");
                YamlConfiguration cameraList = YamlConfiguration.loadConfiguration((File)fileCameraList);
                if (cameraList.contains("cameras") && !cameraList.getKeys(false).isEmpty()) {
                    return CameraManager.getCameraIds(CameraLists.getCurrentRanCameraList()).stream().map(String::valueOf).toList();
                }
                return List.of();
            }
            if (strings[0].equalsIgnoreCase("start")) {
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).toList();
            }
            if (strings[0].equalsIgnoreCase("mode")) {
                return List.of("interactive", "nonInteractive");
            }
            if (strings[0].equalsIgnoreCase("lists")) {
                return List.of("set", "create", "delete");
            }
        }
        if (strings.length == 3 && strings[0].equalsIgnoreCase("lists")) {
            if (strings[1].equalsIgnoreCase("set")) {
                return List.of("CurrentRanCameraList", "CurrentHandCameraList");
            }
            if (strings[1].equalsIgnoreCase("delete")) {
                return CameraLists.getListsNames();
            }
        }
        if (strings.length == 4 && (strings[2].equalsIgnoreCase("CurrentRanCameraList") || strings[2].equalsIgnoreCase("CurrentHandCameraList"))) {
            return CameraLists.getListsNames();
        }
        return List.of();
    }
}

