/*
 * Decompiled with CFR 0.152.
 */
package ru.Terra.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import ru.Terra.rancam;

public class CameraLists {
    private static JavaPlugin plugin = rancam.getInstance();
    private static Logger log = plugin.getLogger();
    private static String folderCameraListsPath = "plugins/RanCam/cameralist";
    private static File dataFile = new File(plugin.getDataFolder(), "data.yml");
    private static YamlConfiguration dataConfig = YamlConfiguration.loadConfiguration((File)dataFile);

    public static void createDefault() {
        File file = new File(folderCameraListsPath, "default.yml");
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                log.info("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f default.yml");
            }
        }
    }

    public static void createList(String id) throws IOException {
        File file = new File(folderCameraListsPath, id + ".yml");
        if (!file.exists()) {
            file.createNewFile();
        }
    }

    public static void deleteList(String id) {
        File file = new File(folderCameraListsPath, id + ".yml");
        file.delete();
    }

    public static List<String> getListsNames() {
        File folder = new File(folderCameraListsPath);
        CameraLists.reloadData();
        if (!folder.exists() || !folder.isDirectory()) {
            return Collections.emptyList();
        }
        File[] files = folder.listFiles((dir, name) -> name.toLowerCase().endsWith(".yml"));
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>();
        for (File file : files) {
            String fileName = file.getName();
            if (!fileName.endsWith(".yml")) continue;
            names.add(fileName.substring(0, fileName.length() - 4));
        }
        return names;
    }

    public static String getCurrentRanCameraList() {
        CameraLists.reloadData();
        return dataConfig.getString("currentRanCameraList");
    }

    public static String getCurrentHandCameraList() {
        CameraLists.reloadData();
        return dataConfig.getString("currentHandCameraList");
    }

    public static void setCurrentRanCameraList(String id) {
        CameraLists.reloadData();
        dataConfig.set("currentRanCameraList", (Object)id);
        CameraLists.saveData();
    }

    public static void setCurrentHandCameraList(String id) {
        CameraLists.reloadData();
        dataConfig.set("currentHandCameraList", (Object)id);
        CameraLists.saveData();
    }

    public static void saveData() {
        try {
            dataConfig.save(dataFile);
        }
        catch (IOException e) {
            log.info("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f data.yml");
        }
    }

    public static void reloadData() {
        dataConfig = YamlConfiguration.loadConfiguration((File)dataFile);
    }
}

