/*
 * Decompiled with CFR 0.152.
 */
package ru.Terra.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.Terra.rancam;
import ru.Terra.utils.CameraLists;
import ru.Terra.utils.DataManager;
import ru.Terra.utils.Messages;
import ru.Terra.utils.PlayerCam;

public class CameraManager {
    private static JavaPlugin plugin = rancam.getInstance();
    private static Logger log = plugin.getLogger();
    private static int switchTime;
    private static String folderCameraListsPath;
    private static String fileCamerasListName;
    private static File fileCameraLists;
    private static FileConfiguration confCameraLists;

    public static int getSwitchTime() {
        switchTime = Integer.parseInt(Objects.requireNonNull(plugin.getConfig().getString("cameraSwitchTime")));
        return switchTime;
    }

    public static void Create(int id, String location, String title, Player sender) {
        CameraManager.reloadCameras();
        if (!confCameraLists.contains("cameras") || confCameraLists.getString("cameras." + id) == null) {
            try {
                confCameraLists.set("cameras." + id + ".location", (Object)location);
                confCameraLists.set("cameras." + id + ".title", (Object)title);
                confCameraLists.save(fileCameraLists);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + Messages.CAMERA_CREATED.toString().replace("%id%", String.valueOf(id)));
            }
            catch (IOException | ArrayIndexOutOfBoundsException e) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + Messages.CAMERA_INVALID_FORMAT.toString());
            }
        } else {
            sender.sendMessage(String.valueOf(ChatColor.RED) + Messages.CAMERA_EXISTING.toString().replace("%id%", String.valueOf(id)));
        }
    }

    public static void Delete(int id, Player sender) {
        CameraManager.reloadCameras();
        try {
            confCameraLists.set("cameras." + id, null);
            confCameraLists.save(fileCameraLists);
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + Messages.CAMERA_DELETED.toString().replace("%id%", String.valueOf(id)));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + Messages.CAMERA_LIST_EMPTY.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void Teleport(int id, Player sender) {
        CameraManager.reloadCameras();
        try {
            String locRaw = CameraManager.getLocationRaw(id);
            Location location = CameraManager.parseLocation(locRaw);
            sender.teleport(location);
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + Messages.CAMERA_TELEPORTED.toString().replace("%id%", String.valueOf(id)));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + Messages.CAMERA_INVALID_FORMAT.toString());
        }
        catch (NullPointerException e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + Messages.CAMERA_NOT_EXISTING.toString().replace("%id%", String.valueOf(id)));
        }
    }

    public static void DeleteCons(int id) {
        CameraManager.reloadCameras();
        try {
            confCameraLists.set("cameras." + id, null);
            confCameraLists.save(fileCameraLists);
            log.info(Messages.CAMERA_DELETED.toString().replace("%id%", String.valueOf(id)));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.severe(Messages.CAMERA_LIST_EMPTY.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void TeleportWork(int id) {
        CameraManager.reloadCameras();
        try {
            String locRaw = CameraManager.getLocationRaw(id);
            Location location = CameraManager.parseLocation(locRaw);
            Bukkit.getPlayer((String)PlayerCam.getPlayerName()).teleport(location);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.info(Messages.CAMERA_INVALID_FORMAT.toString());
        }
        catch (NullPointerException e) {
            log.info(Messages.CAMERA_NOT_EXISTING.toString().replace("%id%", String.valueOf(id)));
        }
    }

    public static List<Integer> getCameraIds(String fileName) {
        CameraManager.reloadCameras();
        File fileCameraLists = new File("plugins/rancam/cameralist", fileName + ".yml");
        YamlConfiguration confCameraLists = YamlConfiguration.loadConfiguration((File)fileCameraLists);
        if (!confCameraLists.contains("cameras")) {
            ArrayList<Integer> nothing = new ArrayList<Integer>();
            nothing.add(0);
            return nothing;
        }
        if (confCameraLists.contains("cameras")) {
            ConfigurationSection camerasSelect = confCameraLists.getConfigurationSection("cameras");
            Set cameraKeys = camerasSelect.getKeys(false);
            List<Integer> sortedCamKeys = cameraKeys.stream().map(Integer::parseInt).sorted().collect(Collectors.toList());
            return sortedCamKeys;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(1);
        return list;
    }

    public static int getRandomId() {
        CameraManager.reloadCameras();
        List<Integer> camerasIDs = CameraManager.getCameraIds(CameraLists.getCurrentRanCameraList());
        Random randm = new Random();
        String randomId = String.valueOf(camerasIDs.get(randm.nextInt(camerasIDs.size())));
        return Integer.parseInt(randomId);
    }

    public static HashMap<String, Object> getCamerasWXYZ(int id) {
        CameraManager.reloadCameras();
        String locRaw = CameraManager.getLocationRaw(id);
        Location location = CameraManager.parseLocation(locRaw);
        HashMap<String, Object> WXYZ = new HashMap<String, Object>();
        WXYZ.put("world", location.getWorld());
        WXYZ.put("X", location.getBlockX());
        WXYZ.put("Y", location.getBlockY());
        WXYZ.put("Z", location.getBlockZ());
        return WXYZ;
    }

    public static void reload() {
        Bukkit.getScheduler().cancelTasks((Plugin)plugin);
        plugin.reloadConfig();
        plugin.onDisable();
        plugin.onEnable();
    }

    public static String getLocationRaw(int id) {
        CameraManager.reloadCameras();
        return confCameraLists.getString("cameras." + id + ".location");
    }

    public static Location parseLocation(String locationString) {
        Pattern pattern = Pattern.compile("world=CraftWorld\\{name=([^}]+)\\},\\s*x=([-+]?\\d+\\.\\d+),\\s*y=([-+]?\\d+\\.\\d+),\\s*z=([-+]?\\d+\\.\\d+),\\s*pitch=([-+]?\\d+\\.\\d+),\\s*yaw=([-+]?\\d+\\.\\d+)");
        Matcher matcher = pattern.matcher(locationString);
        if (matcher.find()) {
            String worldName = matcher.group(1);
            double x = Double.parseDouble(matcher.group(2));
            double y = Double.parseDouble(matcher.group(3));
            double z = Double.parseDouble(matcher.group(4));
            float pitch = Float.parseFloat(matcher.group(5));
            float yaw = Float.parseFloat(matcher.group(6));
            World world = Bukkit.getWorld((String)worldName);
            Location location = new Location(world, x, y, z, pitch, yaw);
            location.setPitch(pitch);
            location.setYaw(yaw);
            return location;
        }
        throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0441\u0442\u0440\u043e\u043a\u0438 \u0438\u043b\u0438 \u0434\u0430\u043d\u043d\u044b\u0435");
    }

    public static void reloadCameras() {
        DataManager.reloadData();
        fileCamerasListName = CameraLists.getCurrentRanCameraList() + ".yml";
        fileCameraLists = new File(folderCameraListsPath, fileCamerasListName);
        confCameraLists = YamlConfiguration.loadConfiguration((File)fileCameraLists);
    }

    static {
        folderCameraListsPath = "plugins/RanCam/cameralist";
        fileCamerasListName = String.valueOf(CameraLists.getCurrentRanCameraList()) + ".yml";
        fileCameraLists = new File(folderCameraListsPath, fileCamerasListName);
        confCameraLists = YamlConfiguration.loadConfiguration((File)fileCameraLists);
    }
}

