/*
 * Decompiled with CFR 0.152.
 */
package ru.Terra.utils;

import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import ru.Terra.rancam;
import ru.Terra.utils.CameraLists;
import ru.Terra.utils.CameraManager;
import ru.Terra.utils.Messages;

public class PlayerCam {
    private static JavaPlugin plugin = rancam.getInstance();
    private static Logger log = plugin.getLogger();
    private static File file = new File(plugin.getDataFolder(), "data.yml");
    private static YamlConfiguration dataConfig = YamlConfiguration.loadConfiguration((File)file);
    private static String folderCameraListsPath = "plugins/RanCam/cameralist";
    private static String fileCamerasListName = String.valueOf(CameraLists.getCurrentRanCameraList()) + ".yml";
    private static File fileCameraLists = new File(folderCameraListsPath, fileCamerasListName);
    private static FileConfiguration confCameraLists = YamlConfiguration.loadConfiguration((File)fileCameraLists);
    static int taskId;
    static int taskId2;

    public static void cameraStop(Player sender, String mode) {
        switch (mode) {
            case "player": {
                try {
                    Bukkit.getScheduler().cancelTask(taskId);
                    Bukkit.getScheduler().cancelTask(taskId2);
                    PlayerCam.setCamUse(false);
                    Bukkit.getPlayer((String)PlayerCam.getPlayerName()).removePotionEffect(PotionEffectType.REGENERATION);
                    Bukkit.getPlayer((String)PlayerCam.getPlayerName()).removePotionEffect(PotionEffectType.RESISTANCE);
                }
                catch (NullPointerException e) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + Messages.COMMAND_PLAYER_NOT_EXISTING.toString());
                }
                break;
            }
            case "console": {
                try {
                    Bukkit.getScheduler().cancelTask(taskId);
                    Bukkit.getScheduler().cancelTask(taskId2);
                    PlayerCam.setCamUse(false);
                    Bukkit.getPlayer((String)PlayerCam.getPlayerName()).removePotionEffect(PotionEffectType.REGENERATION);
                    Bukkit.getPlayer((String)PlayerCam.getPlayerName()).removePotionEffect(PotionEffectType.RESISTANCE);
                    log.info(Messages.CAMERA_TOGGLED_OFF.toString());
                    break;
                }
                catch (NullPointerException e) {
                    log.warning(Messages.COMMAND_PLAYER_NOT_EXISTING.toString());
                }
            }
        }
    }

    public static void MoveTo(int id, Player sender, String mode) {
        switch (mode) {
            case "player": {
                try {
                    String locRaw = CameraManager.getLocationRaw(id);
                    Location location = CameraManager.parseLocation(locRaw);
                    Bukkit.getPlayer((String)PlayerCam.getHandCamName()).teleport(location);
                    sender.sendMessage(String.valueOf(ChatColor.GREEN) + Messages.HANDCAM_TELEPORTED.toString().replace("%id%", String.valueOf(id)));
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + Messages.CAMERA_INVALID_FORMAT.toString());
                }
                catch (NullPointerException e) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + Messages.HANDCAM_INVALID.toString());
                }
                break;
            }
            case "console": {
                try {
                    String locRaw = CameraManager.getLocationRaw(id);
                    Location location = CameraManager.parseLocation(locRaw);
                    Bukkit.getPlayer((String)PlayerCam.getHandCamName()).teleport(location);
                    log.info(Messages.HANDCAM_TELEPORTED.toString().replace("%id%", String.valueOf(id)));
                    break;
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    log.severe(Messages.CAMERA_INVALID_FORMAT.toString());
                    break;
                }
                catch (NullPointerException e) {
                    log.severe(Messages.HANDCAM_INVALID.toString());
                }
            }
        }
    }

    public static void cameraEnable(String player, Player sender, String mode, String interactive) {
        block36: {
            block8 : switch (mode) {
                case "player": {
                    switch (interactive) {
                        case "interactive": {
                            try {
                                PlayerCam.setPlayerName(player);
                                PlayerCam.setCamUse(true);
                                Bukkit.getPlayer((String)PlayerCam.getPlayerName()).addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 2000000000, 255));
                                Bukkit.getPlayer((String)PlayerCam.getPlayerName()).addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, 2000000000, 255));
                                Bukkit.getPlayer((String)PlayerCam.getPlayerName()).setGameMode(GameMode.SURVIVAL);
                                int taskId = Bukkit.getScheduler().runTaskTimer((Plugin)plugin, () -> {
                                    int swTime = CameraManager.getSwitchTime();
                                    if (PlayerCam.getCamUse()) {
                                        PlayerCam.setCurrentCamID(CameraManager.getRandomId());
                                        CameraManager.TeleportWork(PlayerCam.getCurrentCamID());
                                    }
                                }, 0L, 20L * (long)CameraManager.getSwitchTime()).getTaskId();
                                sender.sendMessage(String.valueOf(ChatColor.GREEN) + Messages.CAMERA_TOGGLED_ON.toString().replace("%player%", PlayerCam.getPlayerName()));
                            }
                            catch (NullPointerException e) {
                                PlayerCam.setCamUse(false);
                                sender.sendMessage(String.valueOf(ChatColor.RED) + Messages.COMMAND_PLAYER_NOT_EXISTING.toString());
                            }
                            catch (JsonParseException e) {
                                sender.sendMessage(String.valueOf(ChatColor.RED) + Messages.CAMERA_LIST_EMPTY.toString());
                            }
                            break;
                        }
                        case "nonInteractive": {
                            try {
                                Player player1 = Bukkit.getPlayerExact((String)player);
                                PlayerCam.setPlayerName(player);
                                PlayerCam.setCamUse(true);
                                int taskId = Bukkit.getScheduler().runTaskTimer((Plugin)plugin, () -> {
                                    int swTime = CameraManager.getSwitchTime();
                                    if (PlayerCam.getCamUse()) {
                                        PlayerCam.setCurrentCamID(CameraManager.getRandomId());
                                        CameraManager.TeleportWork(PlayerCam.getCurrentCamID());
                                    }
                                }, 0L, 20L * (long)CameraManager.getSwitchTime()).getTaskId();
                                int taskId2 = Bukkit.getScheduler().runTaskTimer((Plugin)plugin, () -> {
                                    int swTime = CameraManager.getSwitchTime();
                                    if (PlayerCam.getCamUse()) {
                                        String locRaw = CameraManager.getLocationRaw(PlayerCam.getCurrentCamID());
                                        Location location = CameraManager.parseLocation(locRaw);
                                        if (player1 != null && player1.isOnline()) {
                                            Bukkit.getPlayer((String)PlayerCam.getPlayerName()).teleport(location);
                                        } else {
                                            PlayerCam.cameraStop(null, "console");
                                        }
                                    }
                                }, 0L, 0L).getTaskId();
                                sender.sendMessage(String.valueOf(ChatColor.GREEN) + Messages.CAMERA_TOGGLED_ON.toString().replace("%player%", PlayerCam.getPlayerName()));
                                break;
                            }
                            catch (NullPointerException e) {
                                PlayerCam.setCamUse(false);
                                sender.sendMessage(String.valueOf(ChatColor.RED) + Messages.COMMAND_PLAYER_NOT_EXISTING.toString());
                                break;
                            }
                            catch (JsonParseException e) {
                                sender.sendMessage(String.valueOf(ChatColor.RED) + Messages.CAMERA_LIST_EMPTY.toString());
                            }
                        }
                    }
                    break;
                }
                case "console": {
                    switch (interactive) {
                        case "interactive": {
                            try {
                                PlayerCam.setPlayerName(player);
                                PlayerCam.setCamUse(true);
                                Bukkit.getPlayer((String)PlayerCam.getPlayerName()).addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 2000000000, 255));
                                Bukkit.getPlayer((String)PlayerCam.getPlayerName()).addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, 2000000000, 255));
                                Bukkit.getPlayer((String)PlayerCam.getPlayerName()).setGameMode(GameMode.SURVIVAL);
                                int taskId = Bukkit.getScheduler().runTaskTimer((Plugin)plugin, () -> {
                                    int swTime = CameraManager.getSwitchTime();
                                    if (PlayerCam.getCamUse()) {
                                        PlayerCam.setCurrentCamID(CameraManager.getRandomId());
                                        CameraManager.TeleportWork(PlayerCam.getCurrentCamID());
                                    }
                                }, 0L, 20L * (long)CameraManager.getSwitchTime()).getTaskId();
                                log.info(Messages.CAMERA_TOGGLED_ON.toString().replace("%player%", PlayerCam.getPlayerName()));
                            }
                            catch (NullPointerException e) {
                                PlayerCam.setCamUse(false);
                                log.info(Messages.COMMAND_PLAYER_NOT_EXISTING.toString());
                            }
                            catch (JsonParseException e) {
                                log.info(Messages.CAMERA_LIST_EMPTY.toString());
                            }
                            break block36;
                        }
                        case "nonInteractive": {
                            try {
                                Player player1 = Bukkit.getPlayerExact((String)player);
                                PlayerCam.setPlayerName(player);
                                PlayerCam.setCamUse(true);
                                int taskId = Bukkit.getScheduler().runTaskTimer((Plugin)plugin, () -> {
                                    int swTime = CameraManager.getSwitchTime();
                                    if (PlayerCam.getCamUse()) {
                                        PlayerCam.setCurrentCamID(CameraManager.getRandomId());
                                        CameraManager.TeleportWork(PlayerCam.getCurrentCamID());
                                    }
                                }, 0L, 20L * (long)CameraManager.getSwitchTime()).getTaskId();
                                int taskId2 = Bukkit.getScheduler().runTaskTimer((Plugin)plugin, () -> {
                                    int swTime = CameraManager.getSwitchTime();
                                    if (PlayerCam.getCamUse()) {
                                        String locRaw = CameraManager.getLocationRaw(PlayerCam.getCurrentCamID());
                                        Location location = CameraManager.parseLocation(locRaw);
                                        if (player1 != null && player1.isOnline()) {
                                            Bukkit.getPlayer((String)PlayerCam.getPlayerName()).teleport(location);
                                        } else {
                                            PlayerCam.cameraStop(null, "console");
                                        }
                                    }
                                }, 0L, 0L).getTaskId();
                                log.info(Messages.CAMERA_TOGGLED_ON.toString().replace("%player%", PlayerCam.getPlayerName()));
                                break block8;
                            }
                            catch (NullPointerException e) {
                                PlayerCam.setCamUse(false);
                                log.info(Messages.COMMAND_PLAYER_NOT_EXISTING.toString());
                                break block8;
                            }
                            catch (JsonParseException e) {
                                log.info(Messages.CAMERA_LIST_EMPTY.toString());
                            }
                        }
                    }
                }
            }
        }
    }

    public static void cameraWork() {
        Bukkit.getScheduler().runTaskTimer((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                if (PlayerCam.getCamUse()) {
                    try {
                        Bukkit.getPlayer((String)PlayerCam.getPlayerName()).spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(confCameraLists.getString("cameras." + PlayerCam.getCurrentCamID() + ".title")));
                    }
                    catch (NullPointerException e) {
                        plugin.getLogger().warning(Messages.COMMAND_PLAYER_NOT_EXISTING.toString());
                    }
                    try {
                        Bukkit.getPlayer((String)PlayerCam.getPlayerName()).setLevel(PlayerCam.getCurrentCamID());
                    }
                    catch (IllegalArgumentException e) {
                        plugin.getLogger().warning(Messages.CAMERA_NEGATIVE_EXP.toString().replace("%id%", String.valueOf(PlayerCam.getCurrentCamID())));
                    }
                    catch (NullPointerException e) {
                        plugin.getLogger().warning(Messages.COMMAND_PLAYER_NOT_EXISTING.toString());
                    }
                }
            }
        }, 0L, 0L);
    }

    public static void enableStart() {
        if (PlayerCam.getCamUse()) {
            try {
                Bukkit.getPlayer((String)PlayerCam.getPlayerName()).addPotionEffect(new PotionEffect(PotionEffectType.REGENERATION, 2000000000, 255));
                Bukkit.getPlayer((String)PlayerCam.getPlayerName()).addPotionEffect(new PotionEffect(PotionEffectType.RESISTANCE, 2000000000, 255));
                Bukkit.getPlayer((String)PlayerCam.getPlayerName()).setGameMode(GameMode.SURVIVAL);
                int taskId = Bukkit.getScheduler().runTaskTimer((Plugin)plugin, () -> {
                    int swTime = CameraManager.getSwitchTime();
                    if (PlayerCam.getCamUse()) {
                        PlayerCam.setCurrentCamID(CameraManager.getRandomId());
                        CameraManager.TeleportWork(PlayerCam.getCurrentCamID());
                    }
                }, 0L, 20L * (long)CameraManager.getSwitchTime()).getTaskId();
                log.info(String.valueOf(ChatColor.GREEN) + Messages.CAMERA_TOGGLED_ON.toString().replace("%player%", PlayerCam.getPlayerName()));
            }
            catch (NullPointerException e) {
                log.info(String.valueOf(ChatColor.RED) + Messages.COMMAND_PLAYER_NOT_EXISTING.toString());
                Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> PlayerCam.enableStart(), 40L);
            }
            catch (JsonParseException e) {
                log.info(Messages.CAMERA_LIST_EMPTY.toString());
            }
        }
    }

    public static boolean getCamUse() {
        return Boolean.parseBoolean(String.valueOf(dataConfig.get("camUse")));
    }

    public static String getPlayerName() {
        return String.valueOf(dataConfig.get("playerName"));
    }

    public static int getCurrentCamID() {
        return Integer.parseInt(String.valueOf(dataConfig.get("currentCamID")));
    }

    public static String getHandCamName() {
        return String.valueOf(dataConfig.get("handCamName"));
    }

    public static void setCamUse(boolean i) {
        dataConfig.set("camUse", (Object)i);
        PlayerCam.reloadData();
        PlayerCam.saveData();
    }

    public static void setPlayerName(String i) {
        dataConfig.set("playerName", (Object)i);
        PlayerCam.reloadData();
        PlayerCam.saveData();
    }

    public static void setCurrentCamID(int i) {
        dataConfig.set("currentCamID", (Object)i);
        PlayerCam.reloadData();
        PlayerCam.saveData();
    }

    public static void setHandCamName(String i) {
        dataConfig.set("handCamName", (Object)i);
        PlayerCam.reloadData();
        PlayerCam.saveData();
    }

    public static void saveData() {
        try {
            dataConfig.save(file);
        }
        catch (IOException e) {
            log.info("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f data.yml");
        }
    }

    public static void reloadData() {
        folderCameraListsPath = "plugins/RanCam/cameralist";
        fileCamerasListName = String.valueOf(CameraLists.getCurrentRanCameraList()) + ".yml";
        fileCameraLists = new File(folderCameraListsPath, fileCamerasListName);
        confCameraLists = YamlConfiguration.loadConfiguration((File)fileCameraLists);
    }
}

