/*
 * Decompiled with CFR 0.152.
 */
package ru.Terra.commands;

import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import ru.Terra.rancam;
import ru.Terra.utils.Camera.CameraLists;
import ru.Terra.utils.Camera.CameraManager;
import ru.Terra.utils.Camera.PlayerCam;
import ru.Terra.utils.Messages;

public class HandCMD
implements CommandExecutor,
TabCompleter {
    private static JavaPlugin plugin = rancam.getInstance();
    static Logger log = plugin.getLogger();

    public boolean onCommand(CommandSender commandSender, Command command, String s, String[] strings) {
        String currList = CameraLists.getCurrentRanCameraList();
        if (!(commandSender instanceof Player)) {
            if (strings[0].equalsIgnoreCase("moveTo")) {
                try {
                    PlayerCam.MoveTo(strings[1], null, "player");
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    log.severe(Messages.CAMERA_INVALID_FORMAT.toString());
                }
                return true;
            }
            if (strings[0].equalsIgnoreCase("set")) {
                PlayerCam.setHandCamName(strings[1]);
                log.info(Messages.HANDCAM_SET.toString().replace("%player%", strings[1]));
                return true;
            }
        }
        if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            if (player.hasPermission("handcam.move") && strings[0].equalsIgnoreCase("moveTo")) {
                try {
                    PlayerCam.MoveTo(strings[1], player, "player");
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    player.sendMessage(String.valueOf(ChatColor.RED) + Messages.CAMERA_INVALID_FORMAT.toString());
                }
                return true;
            }
            if (strings[0].equalsIgnoreCase("set")) {
                PlayerCam.setHandCamName(strings[1]);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + Messages.HANDCAM_SET.toString().replace("%player%", strings[1]));
                return true;
            }
            if (strings[0].equalsIgnoreCase("list")) {
                ConfigurationSection section = CameraLists.getConfigurationSection("cameras." + currList);
                if (section != null && section.getKeys(false) != null && !section.getKeys(false).isEmpty()) {
                    List<String> kamerasID = CameraManager.getCameraIds("hand");
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "LIST: " + String.valueOf(ChatColor.WHITE) + CameraLists.getCurrentHandCameraList());
                    for (String id : kamerasID) {
                        HashMap<String, Object> WXYZ = CameraManager.getCamerasWXYZ(id);
                        Pattern pattern = Pattern.compile("CraftWorld\\{name=(.*)\\}");
                        Matcher matcher = pattern.matcher(String.valueOf(WXYZ.get("world")));
                        if (matcher.find()) {
                            String worldName = matcher.group(1);
                            player.sendMessage(String.valueOf(ChatColor.GREEN) + "ID: " + id + ":\n   " + String.valueOf(ChatColor.WHITE) + " WORLD: " + String.valueOf(ChatColor.GRAY) + worldName + String.valueOf(ChatColor.WHITE) + ", X: " + String.valueOf(ChatColor.GRAY) + String.valueOf(WXYZ.get("X")) + String.valueOf(ChatColor.WHITE) + ", Y: " + String.valueOf(ChatColor.GRAY) + String.valueOf(WXYZ.get("Y")) + String.valueOf(ChatColor.WHITE) + ", Z: " + String.valueOf(ChatColor.GRAY) + String.valueOf(WXYZ.get("Z")) + String.valueOf(ChatColor.WHITE) + ", TITLE: " + String.valueOf(ChatColor.GRAY) + CameraLists.getString("cameras." + currList + "." + id + ".title"));
                            continue;
                        }
                        if (section == null && section.getKeys(false) == null && section.getKeys(false).isEmpty()) {
                            player.sendMessage(String.valueOf(ChatColor.RED) + Messages.CAMERA_INVALID_FORMAT.toString());
                            continue;
                        }
                        player.sendMessage(String.valueOf(ChatColor.RED) + Messages.CAMERA_INVALID_FORMAT.toString());
                    }
                    return true;
                }
                player.sendMessage(String.valueOf(ChatColor.RED) + Messages.CAMERA_LIST_EMPTY.toString());
                return true;
            }
        }
        return true;
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String s, String[] strings) {
        if (strings.length == 1) {
            return List.of("moveTo", "set", "list");
        }
        if (strings.length == 2) {
            if (strings[0].equalsIgnoreCase("moveTo")) {
                if (CameraLists.contains("cameras") && !CameraLists.getKeys().isEmpty()) {
                    return CameraManager.getCameraIds("hand").stream().map(String::valueOf).toList();
                }
                return List.of();
            }
            if (strings[0].equalsIgnoreCase("set")) {
                return Bukkit.getOnlinePlayers().stream().map(Player::getName).toList();
            }
        }
        return List.of();
    }
}

