/*
 * Decompiled with CFR 0.152.
 */
package ru.Terra.utils.Camera;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import ru.Terra.rancam;
import ru.Terra.utils.DataManager;

public class CameraLists {
    private static JavaPlugin plugin = rancam.getInstance();
    private static Logger log = plugin.getLogger();
    private static File file = new File(plugin.getDataFolder(), "cameras.yml");
    private static YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);

    public static void createDefault() {
        if (!file.exists()) {
            try {
                file.createNewFile();
                log.fine("Successful cameras.yml creation");
            }
            catch (IOException e) {
                log.severe("Error creating cameras.yml");
                e.printStackTrace();
            }
        }
    }

    public static void createList(String id) {
        config.set("cameras." + id, (Object)"");
        CameraLists.save();
    }

    public static void deleteList(String id) {
        config.set("cameras." + id, null);
        CameraLists.save();
    }

    public static List<String> getLists() {
        CameraLists.reload();
        ConfigurationSection section = config.getConfigurationSection("cameras");
        if (section == null) {
            return Collections.emptyList();
        }
        return new ArrayList<String>(section.getKeys(false));
    }

    public static boolean contains(String key) {
        CameraLists.reload();
        return config.contains(key);
    }

    public static ConfigurationSection getConfigurationSection(String path) {
        ConfigurationSection selection = config.getConfigurationSection(path);
        if (selection != null) {
            return selection;
        }
        return null;
    }

    public static Set<String> getKeys() {
        return config.getKeys(false);
    }

    public static void create(String currList, String id, String location, String title) {
        CameraLists.setString("cameras." + currList + "." + id + ".location", location);
        CameraLists.setString("cameras." + currList + "." + id + ".title", title);
        CameraLists.save();
    }

    public static void delete(String currList, String id) {
        config.set("cameras." + currList + "." + id, null);
        CameraLists.save();
    }

    public static void setString(String key, String value) {
        config.set(key, (Object)value);
        CameraLists.save();
    }

    public static void setInteger(String key, int value) {
        config.set(key, (Object)value);
        CameraLists.save();
    }

    public static void setStringList(String key, List<String> value) {
        config.set(key, value);
        CameraLists.save();
    }

    public static String getString(String key) {
        CameraLists.reload();
        return config.getString(key);
    }

    public static int getInteger(String key) {
        CameraLists.reload();
        return config.getInt(key);
    }

    public static List<String> getStringList(String key) {
        CameraLists.reload();
        return config.getStringList(key);
    }

    public static String getCurrentRanCameraList() {
        return DataManager.getString("currentRanCameraList");
    }

    public static String getCurrentHandCameraList() {
        return DataManager.getString("currentHandCameraList");
    }

    public static void setCurrentRanCameraList(String id) {
        DataManager.setString("currentRanCameraList", id);
    }

    public static void setCurrentHandCameraList(String id) {
        DataManager.setString("currentHandCameraList", id);
    }

    public static void save() {
        try {
            config.save(file);
        }
        catch (IOException e) {
            log.info("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f cameras.yml");
            e.printStackTrace();
        }
    }

    public static void reload() {
        config = YamlConfiguration.loadConfiguration((File)file);
    }
}

