/*
 * Decompiled with CFR 0.152.
 */
package ru.Terra.utils.Camera;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import ru.Terra.rancam;
import ru.Terra.utils.Camera.CameraLists;
import ru.Terra.utils.Camera.PlayerCam;
import ru.Terra.utils.Messages;

public class CameraManager {
    private static JavaPlugin plugin = rancam.getInstance();
    private static Logger log = plugin.getLogger();
    private static int switchTime;

    public static int getSwitchTime() {
        switchTime = Integer.parseInt(Objects.requireNonNull(plugin.getConfig().getString("cameraSwitchTime")));
        return switchTime;
    }

    public static void Create(String id, String location, String title, Player sender) {
        String currList = CameraLists.getCurrentRanCameraList();
        if (!CameraLists.contains("cameras") || CameraLists.getString("cameras." + currList + "." + id) == null) {
            try {
                CameraLists.create(currList, id, location, title);
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + Messages.CAMERA_CREATED.toString().replace("%id%", String.valueOf(id)));
            }
            catch (ArrayIndexOutOfBoundsException e) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + Messages.CAMERA_INVALID_FORMAT.toString());
            }
        } else if (CameraLists.getString("cameras." + currList + "." + id) != null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + Messages.CAMERA_EXISTING.toString().replace("%id%", String.valueOf(id)));
        }
    }

    public static void Delete(String id, Player sender) {
        String currList = CameraLists.getCurrentRanCameraList();
        try {
            CameraLists.delete(currList, id);
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + Messages.CAMERA_DELETED.toString().replace("%id%", String.valueOf(id)));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + Messages.CAMERA_LIST_EMPTY.toString());
        }
    }

    public static void Teleport(String id, Player sender) {
        String currList = CameraLists.getCurrentRanCameraList();
        try {
            String locRaw = CameraManager.getLocationRaw(currList, id);
            Location location = CameraManager.parseLocation(locRaw);
            sender.teleport(location);
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + Messages.CAMERA_TELEPORTED.toString().replace("%id%", String.valueOf(id)));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + Messages.CAMERA_INVALID_FORMAT.toString());
        }
        catch (NullPointerException e) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + Messages.CAMERA_NOT_EXISTING.toString().replace("%id%", String.valueOf(id)));
        }
    }

    public static void DeleteCons(String id) {
        String currList = CameraLists.getCurrentRanCameraList();
        try {
            CameraLists.delete(currList, id);
            log.info(Messages.CAMERA_DELETED.toString().replace("%id%", String.valueOf(id)));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.severe(Messages.CAMERA_LIST_EMPTY.toString());
        }
    }

    public static void TeleportWork(String id) {
        String currList = CameraLists.getCurrentRanCameraList();
        try {
            String locRaw = CameraManager.getLocationRaw(currList, id);
            Location location = CameraManager.parseLocation(locRaw);
            Bukkit.getPlayer((String)PlayerCam.getPlayerName()).teleport(location);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            log.info(Messages.CAMERA_INVALID_FORMAT.toString());
        }
        catch (NullPointerException e) {
            log.info(Messages.CAMERA_NOT_EXISTING.toString().replace("%id%", String.valueOf(id)));
        }
    }

    public static List<String> getCameraIds(String cameraMode) {
        String currList = "";
        switch (cameraMode) {
            case "rand": {
                currList = CameraLists.getCurrentRanCameraList();
                break;
            }
            case "hand": {
                currList = CameraLists.getCurrentHandCameraList();
            }
        }
        if (!CameraLists.contains("cameras")) {
            ArrayList<String> nothing = new ArrayList<String>();
            nothing.add("0");
            return nothing;
        }
        if (CameraLists.contains("cameras")) {
            ConfigurationSection camerasSelect = CameraLists.getConfigurationSection("cameras." + currList);
            Set cameraKeys = camerasSelect.getKeys(false);
            List<String> sortedCamKeys = cameraKeys.stream().map(String::valueOf).sorted().collect(Collectors.toList());
            return sortedCamKeys;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add("1");
        return list;
    }

    public static int getRandomId() {
        List<String> camerasIDs = CameraManager.getCameraIds("rand");
        Random randm = new Random();
        String randomId = String.valueOf(camerasIDs.get(randm.nextInt(camerasIDs.size())));
        return Integer.parseInt(randomId);
    }

    public static HashMap<String, Object> getCamerasWXYZ(String id) {
        String currList = CameraLists.getCurrentRanCameraList();
        String locRaw = CameraManager.getLocationRaw(currList, id);
        Location location = CameraManager.parseLocation(locRaw);
        HashMap<String, Object> WXYZ = new HashMap<String, Object>();
        WXYZ.put("world", location.getWorld());
        WXYZ.put("X", location.getBlockX());
        WXYZ.put("Y", location.getBlockY());
        WXYZ.put("Z", location.getBlockZ());
        return WXYZ;
    }

    public static void reload() {
        Bukkit.getScheduler().cancelTasks((Plugin)plugin);
        plugin.reloadConfig();
        plugin.onDisable();
        plugin.onEnable();
    }

    public static String getLocationRaw(String currList, String id) {
        return CameraLists.getString("cameras." + currList + "." + id + ".location");
    }

    public static Location parseLocation(String locationString) {
        Pattern pattern = Pattern.compile("world=CraftWorld\\{name=([^}]+)\\},\\s*x=([-+]?\\d+\\.\\d+),\\s*y=([-+]?\\d+\\.\\d+),\\s*z=([-+]?\\d+\\.\\d+),\\s*pitch=([-+]?\\d+\\.\\d+),\\s*yaw=([-+]?\\d+\\.\\d+)");
        Matcher matcher = pattern.matcher(locationString);
        if (matcher.find()) {
            String worldName = matcher.group(1);
            double x = Double.parseDouble(matcher.group(2));
            double y = Double.parseDouble(matcher.group(3));
            double z = Double.parseDouble(matcher.group(4));
            float pitch = Float.parseFloat(matcher.group(5));
            float yaw = Float.parseFloat(matcher.group(6));
            World world = Bukkit.getWorld((String)worldName);
            Location location = new Location(world, x, y, z, pitch, yaw);
            location.setPitch(pitch);
            location.setYaw(yaw);
            return location;
        }
        throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0441\u0442\u0440\u043e\u043a\u0438 \u0438\u043b\u0438 \u0434\u0430\u043d\u043d\u044b\u0435");
    }
}

