/*
 * Decompiled with CFR 0.152.
 */
package ru.Terra.utils;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;
import ru.Terra.rancam;

public class DataManager {
    private static JavaPlugin plugin = rancam.getInstance();
    private static Logger log = plugin.getLogger();
    private static File dataFile = new File(plugin.getDataFolder(), "data.yml");
    private static YamlConfiguration dataConfig = YamlConfiguration.loadConfiguration((File)dataFile);

    public static void loadData() {
        if (!dataFile.exists()) {
            plugin.saveResource("data.yml", false);
            log.fine("Successful data.yml creation");
        }
    }

    public static void setString(String key, String value) {
        dataConfig.set(key, (Object)value);
        DataManager.saveData();
    }

    public static void setInteger(String key, int value) {
        dataConfig.set(key, (Object)value);
        DataManager.saveData();
    }

    public static void setStringList(String key, List<String> value) {
        dataConfig.set(key, value);
        DataManager.saveData();
    }

    public static String getString(String key) {
        DataManager.reloadData();
        return dataConfig.getString(key);
    }

    public static int getInteger(String key) {
        DataManager.reloadData();
        return dataConfig.getInt(key);
    }

    public static List<String> getStringList(String key) {
        DataManager.reloadData();
        return dataConfig.getStringList(key);
    }

    public static void saveData() {
        try {
            dataConfig.save(dataFile);
        }
        catch (IOException e) {
            log.info("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u044f data.yml");
            e.printStackTrace();
        }
    }

    public static void reloadData() {
        dataConfig = YamlConfiguration.loadConfiguration((File)dataFile);
    }
}

