/*
 * Decompiled with CFR 0.152.
 */
package com.bobobo.plugins.borderplus.db;

import com.bobobo.plugins.borderplus.BorderPlus;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;

public class SQLiteManager {
    private final BorderPlus plugin;
    private Connection connection;

    public SQLiteManager(BorderPlus plugin) {
        this.plugin = plugin;
        this.connect();
        this.createTableIfNotExists();
        this.createCollectiveTables();
    }

    private void connect() {
        try {
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + String.valueOf(this.plugin.getDataFolder()) + "/donations.db");
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error connecting to the database: " + e.getMessage());
        }
    }

    private void createTableIfNotExists() {
        try (PreparedStatement statement = this.connection.prepareStatement("CREATE TABLE IF NOT EXISTS donations (player_name TEXT PRIMARY KEY, total_blocks INTEGER NOT NULL)");){
            statement.execute();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error creating table in the database: " + e.getMessage());
        }
    }

    private void checkConnection() {
        try {
            if (this.connection == null || this.connection.isClosed()) {
                this.connect();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error checking or reconnecting to the database: " + e.getMessage());
        }
    }

    public void updateDonation(Player player, int actualAmount) {
        this.checkConnection();
        String playerName = player.getName();
        try (PreparedStatement statement = this.connection.prepareStatement("INSERT INTO donations (player_name, total_blocks) VALUES (?, ?) ON CONFLICT(player_name) DO UPDATE SET total_blocks = donations.total_blocks + EXCLUDED.total_blocks");){
            statement.setString(1, playerName);
            statement.setInt(2, actualAmount);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error updating donation for player: " + playerName + " - " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getTopDonorName(int position) {
        this.checkConnection();
        try (PreparedStatement statement = this.connection.prepareStatement("SELECT player_name FROM donations ORDER BY total_blocks DESC LIMIT 1 OFFSET ?");){
            statement.setInt(1, position - 1);
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return this.plugin.getConfig().getString("messages.no_data", "No data");
            String string = resultSet.getString("player_name");
            return string;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error retrieving top donor name: " + e.getMessage());
        }
        return this.plugin.getConfig().getString("messages.no_data", "No data");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getTopDonorBlocks(int position) {
        this.checkConnection();
        try (PreparedStatement statement = this.connection.prepareStatement("SELECT total_blocks FROM donations ORDER BY total_blocks DESC LIMIT 1 OFFSET ?");){
            statement.setInt(1, position - 1);
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return 0;
            int n = resultSet.getInt("total_blocks");
            return n;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error retrieving top donor blocks: " + e.getMessage());
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getPlayerRank(String playerName) {
        this.checkConnection();
        try (PreparedStatement statement = this.connection.prepareStatement("SELECT (SELECT COUNT(*) FROM donations d WHERE d.total_blocks >= t.total_blocks) as rank FROM donations t WHERE player_name = ?");){
            statement.setString(1, playerName);
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return -1;
            int n = resultSet.getInt("rank");
            return n;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error retrieving player rank: " + e.getMessage());
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getPlayerBlocks(String name) {
        this.checkConnection();
        try (PreparedStatement statement = this.connection.prepareStatement("SELECT total_blocks FROM donations WHERE player_name = ?");){
            statement.setString(1, name);
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return 0;
            int n = resultSet.getInt("total_blocks");
            return n;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error retrieving blocks for player: " + name + " - " + e.getMessage());
        }
        return 0;
    }

    private void createCollectiveTables() {
        try (Statement statement = this.connection.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS collective_donations (world_name TEXT PRIMARY KEY,total_needed INTEGER NOT NULL,total_contributed INTEGER NOT NULL DEFAULT 0)");
            statement.execute("CREATE TABLE IF NOT EXISTS player_contributions (player_name TEXT,world_name TEXT,contribution INTEGER NOT NULL,PRIMARY KEY(player_name, world_name))");
            for (String worldName : this.plugin.getBorderConfig().getWorldSettingsMap().keySet()) {
                int totalNeeded = this.plugin.getBorderConfig().getCollectiveGoal(worldName);
                PreparedStatement ps = this.connection.prepareStatement("INSERT OR IGNORE INTO collective_donations (world_name, total_needed) VALUES (?, ?)");
                try {
                    ps.setString(1, worldName);
                    ps.setInt(2, totalNeeded);
                    ps.executeUpdate();
                }
                finally {
                    if (ps == null) continue;
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error creating collective tables: " + e.getMessage());
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public int getTotalContributed(String worldName) {
        this.checkConnection();
        int totalContributed = 0;
        try (PreparedStatement statement = this.connection.prepareStatement("SELECT total_contributed FROM collective_donations WHERE world_name = ?");){
            statement.setString(1, worldName);
            try (ResultSet rs = statement.executeQuery();){
                if (rs.next()) {
                    totalContributed = rs.getInt("total_contributed");
                }
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error getting total contributed for world " + worldName + ": " + e.getMessage());
        }
        return totalContributed;
    }

    public int getTotalContributed() {
        this.checkConnection();
        int totalContributed = 0;
        try (Statement statement = this.connection.createStatement();
             ResultSet rs = statement.executeQuery("SELECT SUM(total_contributed) as total FROM collective_donations");){
            if (rs.next()) {
                totalContributed = rs.getInt("total");
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error getting total contributed across all worlds: " + e.getMessage());
        }
        return totalContributed;
    }

    public void updateCollectiveContribution(Player player, String worldName, int amount) {
        this.checkConnection();
        try {
            this.connection.setAutoCommit(false);
            try (PreparedStatement statement = this.connection.prepareStatement("UPDATE collective_donations SET total_contributed = total_contributed + ? WHERE world_name = ?");){
                statement.setInt(1, amount);
                statement.setString(2, worldName);
                statement.executeUpdate();
            }
            statement = this.connection.prepareStatement("INSERT INTO player_contributions (player_name, world_name, contribution) VALUES (?, ?, ?) ON CONFLICT(player_name, world_name) DO UPDATE SET contribution = player_contributions.contribution + EXCLUDED.contribution");
            try {
                statement.setString(1, player.getName());
                statement.setString(2, worldName);
                statement.setInt(3, amount);
                statement.executeUpdate();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            this.connection.commit();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
            }
            catch (SQLException ex) {
                this.plugin.getLogger().severe("Error rolling back transaction: " + ex.getMessage());
            }
            this.plugin.getLogger().severe("Error updating collective contribution: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getPlayerContribution(String playerName, String worldName) {
        this.checkConnection();
        try (PreparedStatement statement = this.connection.prepareStatement("SELECT contribution FROM player_contributions WHERE player_name = ? AND world_name = ?");){
            statement.setString(1, playerName);
            statement.setString(2, worldName);
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return 0;
            int n = resultSet.getInt("contribution");
            return n;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error retrieving player contribution: " + e.getMessage());
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getPlayerContribution(String playerName) {
        this.checkConnection();
        try (PreparedStatement statement = this.connection.prepareStatement("SELECT SUM(contribution) as total_contribution FROM player_contributions WHERE player_name = ?");){
            statement.setString(1, playerName);
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return 0;
            int n = resultSet.getInt("total_contribution");
            return n;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error retrieving player total contribution: " + e.getMessage());
        }
        return 0;
    }

    public void resetCollectiveContributions(String worldName) {
        this.checkConnection();
        try {
            this.connection.setAutoCommit(false);
            try (PreparedStatement statement = this.connection.prepareStatement("UPDATE collective_donations SET total_contributed = 0 WHERE world_name = ?");){
                statement.setString(1, worldName);
                statement.executeUpdate();
            }
            statement = this.connection.prepareStatement("DELETE FROM player_contributions WHERE world_name = ?");
            try {
                statement.setString(1, worldName);
                statement.executeUpdate();
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            this.connection.commit();
            this.connection.setAutoCommit(true);
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
            }
            catch (SQLException ex) {
                this.plugin.getLogger().severe("Error rolling back transaction: " + ex.getMessage());
            }
            this.plugin.getLogger().severe("Error resetting collective contributions: " + e.getMessage());
        }
    }

    public List<Map.Entry<String, Integer>> getTopContributors(String worldName, int limit) {
        this.checkConnection();
        ArrayList<Map.Entry<String, Integer>> topContributors = new ArrayList<Map.Entry<String, Integer>>();
        try (PreparedStatement statement = this.connection.prepareStatement("SELECT player_name, contribution FROM player_contributions WHERE world_name = ? ORDER BY contribution DESC LIMIT ?");){
            statement.setString(1, worldName);
            statement.setInt(2, limit);
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                topContributors.add(new AbstractMap.SimpleEntry<String, Integer>(resultSet.getString("player_name"), resultSet.getInt("contribution")));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error retrieving top contributors: " + e.getMessage());
        }
        return topContributors;
    }

    public List<Map.Entry<String, Integer>> getTopContributors(int limit) {
        this.checkConnection();
        ArrayList<Map.Entry<String, Integer>> topContributors = new ArrayList<Map.Entry<String, Integer>>();
        try (PreparedStatement statement = this.connection.prepareStatement("SELECT player_name, SUM(contribution) as total_contribution FROM player_contributions GROUP BY player_name ORDER BY total_contribution DESC LIMIT ?");){
            statement.setInt(1, limit);
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                topContributors.add(new AbstractMap.SimpleEntry<String, Integer>(resultSet.getString("player_name"), resultSet.getInt("total_contribution")));
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("Error retrieving top contributors across all worlds: " + e.getMessage());
        }
        return topContributors;
    }
}

