/*
 * Decompiled with CFR 0.152.
 */
package com.bobobo.plugins.borderplus.utils.gui;

import com.bobobo.plugins.borderplus.BorderPlus;
import com.bobobo.plugins.borderplus.config.BorderConfig;
import com.bobobo.plugins.borderplus.inventory.CustomInventoryHolder;
import com.bobobo.plugins.borderplus.utils.gui.RotationStorageManager;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class GUIRotationManager {
    private final BorderPlus plugin;
    private final RotationStorageManager storageManager;
    private final Map<String, Long> lastRotationTimes;
    private BukkitTask rotationTask;
    private boolean isEnabled;
    private int rotationIntervalSeconds;
    private boolean autoRotationNotifications;
    private boolean manualRotationNotifications;
    private boolean collectiveOnlyNotifications;
    private boolean worldOnlyNotifications;

    public GUIRotationManager(BorderPlus plugin) {
        this.plugin = plugin;
        this.storageManager = new RotationStorageManager(plugin);
        this.lastRotationTimes = new HashMap<String, Long>();
        this.loadConfig();
        this.initializeRotations();
        this.startRotationTask();
    }

    private void loadConfig() {
        FileConfiguration config = this.plugin.getConfig();
        this.isEnabled = config.getBoolean("gui_rotation.enabled", true);
        this.rotationIntervalSeconds = config.getInt("gui_rotation.interval_seconds", 300);
        this.autoRotationNotifications = config.getBoolean("gui_rotation.notifications.auto_rotation", true);
        this.manualRotationNotifications = config.getBoolean("gui_rotation.notifications.manual_rotation", true);
        this.collectiveOnlyNotifications = config.getBoolean("gui_rotation.notifications.collective_only", false);
        this.worldOnlyNotifications = config.getBoolean("gui_rotation.notifications.world_only", false);
        BorderPlus.logInfo(this.plugin.getMessagesConfig().getMessage("log_gui_rotation_enabled", Map.of("enabled", String.valueOf(this.isEnabled))));
        BorderPlus.logInfo(this.plugin.getMessagesConfig().getMessage("log_rotation_interval", Map.of("seconds", String.valueOf(this.rotationIntervalSeconds))));
        BorderPlus.logInfo(this.plugin.getMessagesConfig().getMessage("log_auto_notifications", Map.of("enabled", String.valueOf(this.autoRotationNotifications))));
        BorderPlus.logInfo(this.plugin.getMessagesConfig().getMessage("log_manual_notifications", Map.of("enabled", String.valueOf(this.manualRotationNotifications))));
    }

    private void initializeRotations() {
        if (!this.isEnabled) {
            return;
        }
        long now = System.currentTimeMillis() / 1000L;
        for (String worldKey : this.plugin.getBorderConfig().getWorldSettingsMap().keySet()) {
            BorderConfig.WorldSettings worldSettings = this.plugin.getBorderConfig().getWorldSettings(worldKey);
            String guiFileName = worldSettings.getGuiName();
            String collectiveGuiFileName = worldSettings.getCollectiveGuiName();
            if (guiFileName != null && !guiFileName.isEmpty()) {
                this.seedOrApplyExisting(worldKey, guiFileName, now);
            }
            if (collectiveGuiFileName == null || collectiveGuiFileName.isEmpty()) continue;
            this.seedOrApplyExisting(worldKey, collectiveGuiFileName, now);
        }
    }

    private void seedOrApplyExisting(String worldName, String guiFileName, long now) {
        if (this.storageManager.hasRotations(worldName, guiFileName)) {
            Map<String, Object> existingRotations = this.storageManager.getCurrentRotations(worldName, guiFileName);
            this.applyRotationsToFile(guiFileName, existingRotations);
            this.plugin.getGUIConfig().reloadGUIForWorld(worldName, guiFileName);
            Long stored = this.storageManager.getLastRotationTime(worldName, guiFileName);
            long seeded = stored != null ? stored : now;
            this.lastRotationTimes.put(worldName + "_" + guiFileName, seeded);
        } else {
            this.lastRotationTimes.put(worldName + "_" + guiFileName, now);
            this.storageManager.setLastRotationTime(worldName, guiFileName, now);
        }
    }

    private void startRotationTask() {
        if (!this.isEnabled) {
            return;
        }
        this.rotationTask = new BukkitRunnable(){

            public void run() {
                GUIRotationManager.this.checkAndRotateGUIs();
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 600L);
        BorderPlus.logInfo(this.plugin.getMessagesConfig().getMessage("log_rotation_task_started", Map.of()));
    }

    private void checkAndRotateGUIs() {
        long currentTime = System.currentTimeMillis() / 1000L;
        for (String worldName : this.plugin.getBorderConfig().getWorldSettingsMap().keySet()) {
            BorderConfig.WorldSettings worldSettings = this.plugin.getBorderConfig().getWorldSettings(worldName);
            String guiFileName = worldSettings.getGuiName();
            String collectiveGuiFileName = worldSettings.getCollectiveGuiName();
            if (guiFileName != null) {
                this.checkAndRotateGUIFile(worldName, guiFileName, currentTime);
            }
            if (collectiveGuiFileName == null) continue;
            this.checkAndRotateGUIFile(worldName, collectiveGuiFileName, currentTime);
        }
    }

    private void checkAndRotateGUIFile(String worldName, String guiFileName, long currentTime) {
        String key = worldName + "_" + guiFileName;
        Long lastRotation = this.lastRotationTimes.get(key);
        if (lastRotation == null) {
            Long stored = this.storageManager.getLastRotationTime(worldName, guiFileName);
            long seeded = stored != null ? stored : currentTime;
            this.lastRotationTimes.put(key, seeded);
            return;
        }
        if (currentTime - lastRotation >= (long)this.rotationIntervalSeconds) {
            this.rotateGUIFile(worldName, guiFileName);
            this.lastRotationTimes.put(key, currentTime);
            this.storageManager.setLastRotationTime(worldName, guiFileName, currentTime);
        }
    }

    private void processGUISection(FileConfiguration config, String sectionPath, Map<String, Object> rotations) {
        ConfigurationSection itemsSection = config.getConfigurationSection(sectionPath);
        if (itemsSection == null) {
            return;
        }
        for (String itemKey : itemsSection.getKeys(false)) {
            ConfigurationSection rotationSection;
            String itemPath = sectionPath + "." + itemKey;
            if (!config.contains(itemPath + ".rotation") || (rotationSection = config.getConfigurationSection(itemPath + ".rotation")) == null) continue;
            this.applyRotation(itemPath, rotationSection, rotations);
        }
    }

    private void applyRotation(String itemPath, ConfigurationSection rotationSection, Map<String, Object> rotations) {
        List amounts;
        List costs;
        List materials;
        boolean rotateMaterial = rotationSection.getBoolean("rotate_material", false);
        if (rotateMaterial && rotationSection.contains("materials") && !(materials = rotationSection.getStringList("materials")).isEmpty()) {
            String randomMaterial = (String)materials.get(ThreadLocalRandom.current().nextInt(materials.size()));
            rotations.put(itemPath + ".material", randomMaterial);
            rotations.put(itemPath + ".required_material", randomMaterial);
        }
        if (rotationSection.contains("costs") && !(costs = rotationSection.getDoubleList("costs")).isEmpty()) {
            double randomCost = (Double)costs.get(ThreadLocalRandom.current().nextInt(costs.size()));
            rotations.put(itemPath + ".cost", randomCost);
        }
        if (rotationSection.contains("amounts") && !(amounts = rotationSection.getIntegerList("amounts")).isEmpty()) {
            int randomAmount = (Integer)amounts.get(ThreadLocalRandom.current().nextInt(amounts.size()));
            rotations.put(itemPath + ".contribution_amount", randomAmount);
            rotations.put(itemPath + ".weight", randomAmount);
        }
    }

    private void rotateGUIFile(String worldName, String guiFileName) {
        this.rotateGUIFile(worldName, guiFileName, false);
    }

    private void rotateGUIFile(String worldName, String guiFileName, boolean isManual) {
        Map<String, Object> rotations = this.processGUIFile(guiFileName);
        if (rotations == null) {
            return;
        }
        this.storageManager.setRotations(worldName, guiFileName, rotations);
        this.applyRotationsToFile(guiFileName, rotations);
        this.plugin.getGUIConfig().reloadGUIForWorld(worldName, guiFileName);
        this.updateOpenGUIs(worldName, guiFileName);
        if (!isManual) {
            this.notifyGUIRotation(worldName, guiFileName);
        }
        String displayName = this.getWorldDisplayName(worldName);
        BorderPlus.logInfo(this.plugin.getMessagesConfig().getMessage("log_gui_rotated", Map.of("world", displayName, "gui", guiFileName, "seconds", String.valueOf(this.rotationIntervalSeconds))));
    }

    private void updateOpenGUIs(String worldName, String guiFileName) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            CustomInventoryHolder holder;
            Inventory openInventory;
            if (!player.getWorld().getName().equals(worldName) || !((openInventory = player.getOpenInventory().getTopInventory()).getHolder() instanceof CustomInventoryHolder) || !(holder = (CustomInventoryHolder)openInventory.getHolder()).getWorldName().equals(worldName) && !holder.getWorldName().equals("collective_" + worldName)) continue;
            this.updateInventoryItems(openInventory, worldName, guiFileName);
        }
    }

    private void updateInventoryItems(Inventory inventory, String worldName, String guiFileName) {
        Map<String, Object> rotations = this.storageManager.getCurrentRotations(worldName, guiFileName);
        if (rotations == null || rotations.isEmpty()) {
            return;
        }
        for (int slot = 0; slot < inventory.getSize(); ++slot) {
            ItemStack itemStack = inventory.getItem(slot);
            if (itemStack != null && itemStack.getType() != Material.AIR) continue;
        }
    }

    private void notifyGUIRotation(String worldName, String guiFileName) {
        if (!this.autoRotationNotifications) {
            return;
        }
        boolean isCollectiveGUI = guiFileName.contains("collective");
        if (this.collectiveOnlyNotifications && !isCollectiveGUI) {
            return;
        }
        if (this.worldOnlyNotifications && isCollectiveGUI) {
            return;
        }
        String displayName = this.getWorldDisplayName(worldName);
        String message = this.plugin.getMessagesConfig().getMessage("gui_rotation_changed", Map.of("world", displayName, "gui", guiFileName));
        Bukkit.getWorld((String)worldName).getPlayers().forEach(player -> player.sendMessage(message));
    }

    public Map<String, Object> getCurrentRotations(String worldName, String guiFileName) {
        return this.storageManager.getCurrentRotations(worldName, guiFileName);
    }

    public long getTimeUntilNextRotation(String worldName, String guiFileName) {
        String key = worldName + "_" + guiFileName;
        Long lastRotation = this.lastRotationTimes.get(key);
        if (lastRotation == null) {
            return 0L;
        }
        long currentTime = System.currentTimeMillis() / 1000L;
        long timePassed = currentTime - lastRotation;
        long timeRemaining = (long)this.rotationIntervalSeconds - timePassed;
        return Math.max(0L, timeRemaining);
    }

    public void forceRotateGUI(String worldName, String guiFileName) {
        this.rotateGUIFile(worldName, guiFileName, true);
        this.notifyManualRotation(worldName, guiFileName);
    }

    private void notifyManualRotation(String worldName, String guiFileName) {
        if (!this.manualRotationNotifications) {
            return;
        }
        boolean isCollectiveGUI = guiFileName.contains("collective");
        if (this.collectiveOnlyNotifications && !isCollectiveGUI) {
            return;
        }
        if (this.worldOnlyNotifications && isCollectiveGUI) {
            return;
        }
        String displayName = this.getWorldDisplayName(worldName);
        String message = this.plugin.getMessagesConfig().getMessage("gui_rotated_manually", Map.of("world", displayName, "gui", guiFileName));
        Bukkit.getWorld((String)worldName).getPlayers().forEach(player -> player.sendMessage(message));
    }

    public void reload() {
        if (this.rotationTask != null) {
            this.rotationTask.cancel();
        }
        this.lastRotationTimes.clear();
        this.storageManager.reload();
        this.loadConfig();
        this.initializeRotations();
        this.startRotationTask();
    }

    public void shutdown() {
        if (this.rotationTask != null) {
            this.rotationTask.cancel();
        }
    }

    private Map<String, Object> processGUIFile(String guiFileName) {
        File guiFile = new File(this.plugin.getDataFolder(), guiFileName);
        if (!guiFile.exists()) {
            return null;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)guiFile);
        HashMap<String, Object> rotations = new HashMap<String, Object>();
        this.processGUISection((FileConfiguration)config, "menus.border_menu.items", rotations);
        this.processGUISection((FileConfiguration)config, "menus.collective_menu.items", rotations);
        return rotations;
    }

    private void applyRotationsToFile(String guiFileName, Map<String, Object> rotations) {
        File guiFile = new File(this.plugin.getDataFolder(), guiFileName);
        if (!guiFile.exists()) {
            return;
        }
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)guiFile);
            for (Map.Entry<String, Object> entry : rotations.entrySet()) {
                config.set(entry.getKey(), entry.getValue());
            }
            config.save(guiFile);
            BorderPlus.logInfo("Re-applied stored rotations to GUI file: " + guiFileName);
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to apply rotations to GUI file: " + guiFileName);
            e.printStackTrace();
        }
    }

    private String getWorldDisplayName(String worldName) {
        BorderConfig.WorldSettings worldSettings = this.plugin.getBorderConfig().getWorldSettings(worldName);
        return worldSettings != null ? worldSettings.getDisplayName() : worldName;
    }

    public boolean isManualRotationNotificationsEnabled() {
        return this.manualRotationNotifications;
    }
}

