/*
 * Decompiled with CFR 0.152.
 */
package me.owdding.skyocean.utils.storage;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import me.owdding.skyocean.SkyOcean;
import me.owdding.skyocean.utils.Utils;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import tech.thatgravyboat.skyblockapi.api.events.base.Subscription;
import tech.thatgravyboat.skyblockapi.api.events.base.predicates.TimePassed;
import tech.thatgravyboat.skyblockapi.api.events.time.TickEvent;
import tech.thatgravyboat.skyblockapi.helpers.McClient;
import tech.thatgravyboat.skyblockapi.utils.json.Json;
import tech.thatgravyboat.skyblockapi.utils.json.JsonObjectBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 \u001e*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0001:\u0001\u001eBA\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\t\u00a2\u0006\u0004\b\f\u0010\rB-\b\u0016\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\n\u00a2\u0006\u0004\b\f\u0010\u000eJ\r\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\r\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00028\u00008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001f"}, d2={"Lme/owdding/skyocean/utils/storage/DataStorage;", "", "T", "", "version", "Lkotlin/Function0;", "defaultData", "", "fileName", "Lkotlin/Function1;", "Lcom/mojang/serialization/Codec;", "codec", "<init>", "(ILkotlin/jvm/functions/Function0;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "(Lkotlin/jvm/functions/Function0;Ljava/lang/String;Lcom/mojang/serialization/Codec;)V", "get", "()Ljava/lang/Object;", "", "save", "()V", "delete", "saveToSystem", "I", "Ljava/nio/file/Path;", "path", "Ljava/nio/file/Path;", "data", "Ljava/lang/Object;", "currentCodec", "Lcom/mojang/serialization/Codec;", "Companion", "SkyOcean-1.21.5"})
@SourceDebugExtension(value={"SMAP\nDataStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataStorage.kt\nme/owdding/skyocean/utils/storage/DataStorage\n+ 2 JsonBuilderKt.java\ntech/thatgravyboat/skyblockapi/utils/json/JsonBuilderKt\n*L\n1#1,112:1\n8#2,3:113\n*S KotlinDebug\n*F\n+ 1 DataStorage.kt\nme/owdding/skyocean/utils/storage/DataStorage\n*L\n100#1:113,3\n*E\n"})
public final class DataStorage<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int version;
    @NotNull
    private final Path path;
    @NotNull
    private final T data;
    @NotNull
    private final Codec<T> currentCodec;
    @NotNull
    private static final Set<DataStorage<?>> requiresSave = new LinkedHashSet();
    @NotNull
    private static final Path defaultPath;

    public DataStorage(int version, @NotNull Function0<? extends T> defaultData, @NotNull String fileName, @NotNull Function1<? super Integer, ? extends Codec<T>> codec) {
        Intrinsics.checkNotNullParameter(defaultData, (String)"defaultData");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        this.version = version;
        Path path = defaultPath.resolve(fileName + ".json");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.path = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(this.path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            PathsKt.createParentDirectories((Path)this.path, (FileAttribute[])new FileAttribute[0]);
            this.data = defaultData.invoke();
        } else {
            Object newData = null;
            try {
                JsonObject readJson = (JsonObject)Utils.INSTANCE.readJson(this.path);
                int version2 = readJson.get("@skyocean:version").getAsInt();
                JsonElement data = readJson.get("@skyocean:data");
                int n = this.version;
                for (int version3 = version2; version3 < n; ++version3) {
                    data = Json.INSTANCE.toJsonOrThrow(Json.INSTANCE.toDataOrThrow(data, (Codec)codec.invoke((Object)version3)), (Codec)codec.invoke((Object)version3));
                }
                Codec codec2 = (Codec)codec.invoke((Object)version2);
                newData = Json.INSTANCE.toDataOrThrow(data, codec2);
            }
            catch (Exception e) {
                SkyOcean.INSTANCE.error("Failed to load " + PathsKt.relativeTo((Path)this.path, (Path)defaultPath) + ".", e);
                newData = defaultData.invoke();
            }
            this.data = newData;
        }
        this.currentCodec = (Codec)codec.invoke((Object)this.version);
    }

    public /* synthetic */ DataStorage(int n, Function0 function0, String string, Function1 function1, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        this(n, function0, string, function1);
    }

    public DataStorage(@NotNull Function0<? extends T> defaultData, @NotNull String fileName, @NotNull Codec<T> codec) {
        Intrinsics.checkNotNullParameter(defaultData, (String)"defaultData");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        this(0, defaultData, fileName, arg_0 -> DataStorage._init_$lambda$0(codec, arg_0));
    }

    @NotNull
    public final T get() {
        return this.data;
    }

    public final void save() {
        requiresSave.add(this);
    }

    public final void delete() {
        try {
            Files.deleteIfExists(this.path);
        }
        catch (Exception e) {
            SkyOcean.INSTANCE.error("Failed to delete " + this.path, e);
        }
    }

    private final void saveToSystem() {
        SkyOcean.INSTANCE.debug("Saving " + this.path);
        try {
            JsonObjectBuilder json$iv;
            int version = this.version;
            boolean $i$f$JsonObject = false;
            JsonObjectBuilder $this$saveToSystem_u24lambda_u240 = json$iv = new JsonObjectBuilder();
            boolean bl = false;
            $this$saveToSystem_u24lambda_u240.set("@skyocean:version", (Number)version);
            JsonElement jsonElement = Json.INSTANCE.toJson(this.data, this.currentCodec);
            if (jsonElement == null) {
                SkyOcean.INSTANCE.warn("Failed to encode " + this.data + " to json");
                return;
            }
            $this$saveToSystem_u24lambda_u240.set("@skyocean:data", jsonElement);
            JsonObject json = json$iv.build();
            Utils.writeJson$default(Utils.INSTANCE, this.path, (JsonElement)json, null, null, 6, null);
            FileUtils.write((File)this.path.toFile(), (CharSequence)Json.INSTANCE.toPrettyString((JsonElement)json), (Charset)Charsets.UTF_8);
            SkyOcean.INSTANCE.debug("saved " + this.path);
        }
        catch (Exception e) {
            SkyOcean.INSTANCE.error("Failed to save " + this.data + " to file", e);
        }
    }

    private static final Codec _init_$lambda$0(Codec $codec, int it) {
        return $codec;
    }

    static {
        Path path = McClient.INSTANCE.getConfig().resolve("skyocean/data");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        defaultPath = path;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0003R!\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\r\u001a\u00020\f8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lme/owdding/skyocean/utils/storage/DataStorage$Companion;", "", "<init>", "()V", "", "onTick", "", "Lme/owdding/skyocean/utils/storage/DataStorage;", "requiresSave", "Ljava/util/Set;", "getRequiresSave", "()Ljava/util/Set;", "Ljava/nio/file/Path;", "defaultPath", "Ljava/nio/file/Path;", "getDefaultPath", "()Ljava/nio/file/Path;", "SkyOcean-1.21.5"})
    @SourceDebugExtension(value={"SMAP\nDataStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataStorage.kt\nme/owdding/skyocean/utils/storage/DataStorage$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,112:1\n37#2,2:113\n13805#3,2:115\n*S KotlinDebug\n*F\n+ 1 DataStorage.kt\nme/owdding/skyocean/utils/storage/DataStorage$Companion\n*L\n47#1:113,2\n50#1:115,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<DataStorage<?>> getRequiresSave() {
            return requiresSave;
        }

        @Subscription(event={TickEvent.class})
        @TimePassed(duration="5s")
        public final void onTick() {
            Collection $this$toTypedArray$iv = this.getRequiresSave();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            DataStorage[] toSave = thisCollection$iv.toArray(new DataStorage[0]);
            this.getRequiresSave().clear();
            CompletableFuture.runAsync(() -> Companion.onTick$lambda$0(toSave));
        }

        @NotNull
        public final Path getDefaultPath() {
            return defaultPath;
        }

        private static final void onTick$lambda$0(DataStorage[] $toSave) {
            DataStorage[] $this$forEach$iv = $toSave;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                DataStorage element$iv;
                DataStorage it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                it.saveToSystem();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

