/*
 * Decompiled with CFR 0.152.
 */
package me.owdding.skyocean.utils.storage;

import com.mojang.serialization.Codec;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.owdding.skyocean.SkyOcean;
import me.owdding.skyocean.utils.storage.DataStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.skyblockapi.helpers.McClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\r\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0001B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\r\u001a\u00020\t2\u0006\u0010\f\u001a\u00028\u0000\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\f\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J!\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001b0\u001aH\u0000\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0019\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\u001f\u00a2\u0006\u0004\b \u0010\u001dJ\r\u0010!\u001a\u00020\t\u00a2\u0006\u0004\b!\u0010\u000bR\u0017\u0010\u0004\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\"\u001a\u0004\b#\u0010$R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010%\u001a\u0004\b&\u0010'R&\u0010(\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001b0\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+\u00a8\u0006,"}, d2={"Lme/owdding/skyocean/utils/storage/FolderStorage;", "", "T", "", "folder", "Lcom/mojang/serialization/Codec;", "codec", "<init>", "(Ljava/lang/String;Lcom/mojang/serialization/Codec;)V", "", "load", "()V", "value", "add", "(Ljava/lang/Object;)V", "id", "set", "(Ljava/lang/String;Ljava/lang/Object;)V", "get", "(Ljava/lang/String;)Ljava/lang/Object;", "remove", "(Ljava/lang/String;)V", "", "Ljava/nio/file/Path;", "files", "()Ljava/util/List;", "", "Lme/owdding/skyocean/utils/storage/DataStorage;", "getStorages$SkyOcean_1_21_5", "()Ljava/util/Map;", "getStorages", "", "getAll", "refresh", "Ljava/lang/String;", "getFolder", "()Ljava/lang/String;", "Lcom/mojang/serialization/Codec;", "getCodec", "()Lcom/mojang/serialization/Codec;", "storages", "Ljava/util/Map;", "defaultPath", "Ljava/nio/file/Path;", "SkyOcean-1.21.5"})
@SourceDebugExtension(value={"SMAP\nFolderStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FolderStorage.kt\nme/owdding/skyocean/utils/storage/FolderStorage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,69:1\n1617#2,9:70\n1869#2:79\n1870#2:81\n1626#2:82\n774#2:91\n865#2,2:92\n1252#2,4:96\n1#3:80\n1#3:90\n382#4,7:83\n463#4:94\n413#4:95\n*S KotlinDebug\n*F\n+ 1 FolderStorage.kt\nme/owdding/skyocean/utils/storage/FolderStorage\n*L\n22#1:70,9\n22#1:79\n22#1:81\n22#1:82\n59#1:91\n59#1:92,2\n62#1:96,4\n22#1:80\n42#1:83,7\n62#1:94\n62#1:95\n*E\n"})
public final class FolderStorage<T> {
    @NotNull
    private final String folder;
    @NotNull
    private final Codec<T> codec;
    @NotNull
    private final Map<String, DataStorage<T>> storages;
    @NotNull
    private final Path defaultPath;

    public FolderStorage(@NotNull String folder, @NotNull Codec<T> codec) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        this.folder = folder;
        this.codec = codec;
        this.storages = new LinkedHashMap();
        Path path = McClient.INSTANCE.getConfig().resolve("skyocean/data/" + this.folder);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.defaultPath = path;
        this.load();
    }

    @NotNull
    public final String getFolder() {
        return this.folder;
    }

    @NotNull
    public final Codec<T> getCodec() {
        return this.codec;
    }

    /*
     * WARNING - void declaration
     */
    public final void load() {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Iterable iterable = this.files();
        Map<String, DataStorage<T>> map = this.storages;
        boolean $i$f$mapNotNull = false;
        void var3_4 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair it$iv$iv;
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Path it = (Path)element$iv$iv;
            boolean bl2 = false;
            String id = PathsKt.getNameWithoutExtension((Path)it);
            try {
                pair = TuplesKt.to((Object)id, new DataStorage(0, FolderStorage::load$lambda$0$0, this.folder + "/" + id, arg_0 -> FolderStorage.load$lambda$0$1(this, arg_0)));
            }
            catch (Exception e) {
                SkyOcean.INSTANCE.error("Failed to load storage file: " + PathsKt.relativeTo((Path)it, (Path)McClient.INSTANCE.getConfig()), e);
                pair = null;
            }
            if (pair == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        MapsKt.putAll(map, (Iterable)((List)destination$iv$iv));
    }

    public final void add(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.set(String.valueOf(value.hashCode()), value);
    }

    /*
     * WARNING - void declaration
     */
    public final void set(@NotNull String id, @NotNull T value) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Map<String, DataStorage<T>> map = this.storages;
        String key$iv = id;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            DataStorage answer$iv = new DataStorage(0, () -> FolderStorage.set$lambda$0$0(value), this.folder + "/" + id, arg_0 -> FolderStorage.set$lambda$0$1(this, arg_0));
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((DataStorage)object).save();
    }

    @Nullable
    public final T get(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        DataStorage<T> dataStorage = this.storages.get(id);
        return (T)(dataStorage != null ? dataStorage.get() : null);
    }

    public final void remove(@NotNull String id) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            DataStorage<T> dataStorage = this.storages.remove(id);
            if (dataStorage == null) break block0;
            dataStorage.delete();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Path> files() {
        void $this$filterTo$iv$iv;
        Path path;
        Path $this$files_u24lambda_u240 = path = this.defaultPath;
        boolean $i$a$-apply-FolderStorage$files$22 = false;
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories($this$files_u24lambda_u240, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        Iterable $this$filter$iv = CollectionsKt.toList((Iterable)PathsKt.listDirectoryEntries((Path)path, (String)"*.json"));
        boolean $i$f$filter = false;
        Iterable $i$a$-apply-FolderStorage$files$22 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path it = (Path)element$iv$iv;
            boolean bl = false;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!(Files.isRegularFile(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && Intrinsics.areEqual((Object)PathsKt.getExtension((Path)it), (Object)"json"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final Map<String, DataStorage<T>> getStorages$SkyOcean_1_21_5() {
        return this.storages;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, T> getAll() {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Map<String, DataStorage<T>> $this$mapValues$iv = this.storages;
        boolean $i$f$mapValues = false;
        Map<String, DataStorage<T>> map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            Object t = ((DataStorage)it.getValue()).get();
            map3.put(k, t);
        }
        return destination$iv$iv$iv;
    }

    public final void refresh() {
        this.storages.clear();
        this.load();
    }

    private static final Object load$lambda$0$0() {
        throw new IllegalStateException("No default data for folder storage!");
    }

    private static final Codec load$lambda$0$1(FolderStorage this$0, int it) {
        return this$0.codec;
    }

    private static final Object set$lambda$0$0(Object $value) {
        return $value;
    }

    private static final Codec set$lambda$0$1(FolderStorage this$0, int it) {
        return this$0.codec;
    }
}

