/*
 * Decompiled with CFR 0.152.
 */
package me.owdding.skyocean.utils.storage;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import me.owdding.skyocean.SkyOcean;
import me.owdding.skyocean.utils.Utils;
import me.owdding.skyocean.utils.storage.DataStorage;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tech.thatgravyboat.skyblockapi.api.events.base.Subscription;
import tech.thatgravyboat.skyblockapi.api.events.base.predicates.TimePassed;
import tech.thatgravyboat.skyblockapi.api.events.profile.ProfileChangeEvent;
import tech.thatgravyboat.skyblockapi.api.events.time.TickEvent;
import tech.thatgravyboat.skyblockapi.helpers.McPlayer;
import tech.thatgravyboat.skyblockapi.utils.json.Json;
import tech.thatgravyboat.skyblockapi.utils.json.JsonObjectBuilder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 )*\b\b\u0000\u0010\u0002*\u00020\u00012\u00020\u0001:\u0001)BA\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\t\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0017\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u0019\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0019\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0018R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u001bR\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u001cR\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR)\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\t8\u0006\u00a2\u0006\f\n\u0004\b\u000b\u0010 \u001a\u0004\b!\u0010\"R\u0016\u0010#\u001a\u00028\u00008\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0016\u0010&\u001a\u00020%8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b&\u0010'R\u0018\u0010(\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b(\u0010\u001d\u00a8\u0006*"}, d2={"Lme/owdding/skyocean/utils/storage/ProfileStorage;", "", "T", "", "version", "Lkotlin/Function0;", "defaultData", "", "fileName", "Lkotlin/Function1;", "Lcom/mojang/serialization/Codec;", "codec", "<init>", "(ILkotlin/jvm/functions/Function0;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "", "isCurrentlyActive", "()Z", "get", "()Ljava/lang/Object;", "new", "", "set", "(Ljava/lang/Object;)V", "save", "()V", "load", "saveToSystem", "I", "Lkotlin/jvm/functions/Function0;", "Ljava/lang/String;", "getFileName", "()Ljava/lang/String;", "Lkotlin/jvm/functions/Function1;", "getCodec", "()Lkotlin/jvm/functions/Function1;", "data", "Ljava/lang/Object;", "Ljava/nio/file/Path;", "lastPath", "Ljava/nio/file/Path;", "lastProfile", "Companion", "skyocean_versions1218"})
@SourceDebugExtension(value={"SMAP\nProfileStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileStorage.kt\nme/owdding/skyocean/utils/storage/ProfileStorage\n+ 2 ProfileStorage.kt\nme/owdding/skyocean/utils/storage/ProfileStorage$Companion\n+ 3 JsonBuilderKt.java\ntech/thatgravyboat/skyblockapi/utils/json/JsonBuilderKt\n*L\n1#1,142:1\n54#2:143\n54#2:144\n8#3,3:145\n*S KotlinDebug\n*F\n+ 1 ProfileStorage.kt\nme/owdding/skyocean/utils/storage/ProfileStorage\n*L\n99#1:143\n117#1:144\n129#1:145,3\n*E\n"})
public final class ProfileStorage<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int version;
    @NotNull
    private Function0<? extends T> defaultData;
    @NotNull
    private final String fileName;
    @NotNull
    private final Function1<Integer, Codec<T>> codec;
    private T data;
    private Path lastPath;
    @Nullable
    private String lastProfile;
    @NotNull
    private static final Set<ProfileStorage<?>> requiresSave = new LinkedHashSet();
    @Nullable
    private static String currentProfile;

    public ProfileStorage(int version, @NotNull Function0<? extends T> defaultData, @NotNull String fileName, @NotNull Function1<? super Integer, ? extends Codec<T>> codec) {
        Intrinsics.checkNotNullParameter(defaultData, (String)"defaultData");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        this.version = version;
        this.defaultData = defaultData;
        this.fileName = fileName;
        this.codec = codec;
    }

    public /* synthetic */ ProfileStorage(int i2, Function0 function0, String string, Function1 function1, int j, DefaultConstructorMarker defaultConstructorMarker) {
        if ((j & 1) != 0) {
            i2 = 0;
        }
        this(i2, function0, string, function1);
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    @NotNull
    public final Function1<Integer, Codec<T>> getCodec() {
        return this.codec;
    }

    private final boolean isCurrentlyActive() {
        return this.lastProfile != null && ProfileStorage.Companion.hasProfile() && Intrinsics.areEqual((Object)currentProfile, (Object)this.lastProfile);
    }

    @Nullable
    public final T get() {
        Unit unit;
        if (this.isCurrentlyActive()) {
            Object object = this.data;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"data");
                object = Unit.INSTANCE;
            }
            return object;
        }
        this.saveToSystem();
        this.load();
        if (this.data != null) {
            T t = this.data;
            unit = (Unit)t;
            if (t == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"data");
                unit = Unit.INSTANCE;
            }
        } else {
            unit = null;
        }
        return (T)unit;
    }

    public final void set(@NotNull T object) {
        Intrinsics.checkNotNullParameter(object, (String)"new");
        if (this.isCurrentlyActive()) {
            this.data = object;
            return;
        }
        this.saveToSystem();
        this.load();
        if (this.data != null) {
            this.data = object;
        }
    }

    public final void save() {
        requiresSave.add(this);
    }

    public final void load() {
        Path path;
        if (!ProfileStorage.Companion.hasProfile()) {
            return;
        }
        String string = this.lastProfile = currentProfile;
        if (string == null) {
            return;
        }
        String lastProfile = string;
        Object this_$iv = Companion;
        boolean $i$f$getDefaultPath = false;
        Path path2 = DataStorage.Companion.getDefaultPath().resolve(McPlayer.INSTANCE.getUuid().toString()).resolve(lastProfile).resolve(this.fileName + ".json");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        this.lastPath = path2;
        Path path3 = this.lastPath;
        if (path3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lastPath");
            path3 = null;
        }
        if (!Files.exists(path = path3, Arrays.copyOf(this_$iv = new LinkOption[0], ((LinkOption[])this_$iv).length))) {
            Path path4 = this.lastPath;
            if (path4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"lastPath");
                path4 = null;
            }
            PathsKt.createParentDirectories((Path)path4, (FileAttribute[])new FileAttribute[0]);
            this.data = this.defaultData.invoke();
            this.saveToSystem();
            return;
        }
        try {
            Path path5 = this.lastPath;
            if (path5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"lastPath");
                path5 = null;
            }
            JsonObject readJson = (JsonObject)Utils.INSTANCE.readJson(path5);
            int version = readJson.get("@skyocean:version").getAsInt();
            JsonElement data = readJson.get("@skyocean:data");
            Codec codec = (Codec)this.codec.invoke((Object)version);
            this.data = Json.INSTANCE.toDataOrThrow(data, codec);
        }
        catch (Exception e) {
            Path path6 = this.lastPath;
            if (path6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"lastPath");
                path6 = null;
            }
            this_$iv = Companion;
            $i$f$getDefaultPath = false;
            SkyOcean.INSTANCE.error("Failed to load " + PathsKt.relativeTo((Path)path6, (Path)DataStorage.Companion.getDefaultPath()) + ".", e);
            this.data = this.defaultData.invoke();
            this.saveToSystem();
        }
    }

    private final void saveToSystem() {
        if (this.data == null) {
            return;
        }
        Path path = this.lastPath;
        if (path == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"lastPath");
            path = null;
        }
        SkyOcean.INSTANCE.debug("Saving " + path);
        try {
            JsonObjectBuilder json$iv;
            int version = this.version;
            Codec codec = (Codec)this.codec.invoke((Object)version);
            boolean $i$f$JsonObject = false;
            JsonObjectBuilder $this$saveToSystem_u24lambda_u240 = json$iv = new JsonObjectBuilder();
            boolean i2 = false;
            $this$saveToSystem_u24lambda_u240.set("@skyocean:version", (Number)version);
            Object object = this.data;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"data");
                object = Unit.INSTANCE;
            }
            JsonElement jsonElement = Json.INSTANCE.toJson(object, codec);
            if (jsonElement == null) {
                Object object2 = this.data;
                if (object2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"data");
                    object2 = Unit.INSTANCE;
                }
                SkyOcean.INSTANCE.warn("Failed to encode " + object2 + " to json");
                return;
            }
            $this$saveToSystem_u24lambda_u240.set("@skyocean:data", jsonElement);
            JsonObject json = json$iv.build();
            Path path2 = this.lastPath;
            if (path2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"lastPath");
                path2 = null;
            }
            Utils.writeJson$default(Utils.INSTANCE, path2, (JsonElement)json, null, null, 6, null);
            Path path3 = this.lastPath;
            if (path3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"lastPath");
                path3 = null;
            }
            FileUtils.write((File)path3.toFile(), (CharSequence)Json.INSTANCE.toPrettyString((JsonElement)json), (Charset)Charsets.UTF_8);
            Path path4 = this.lastPath;
            if (path4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"lastPath");
                path4 = null;
            }
            SkyOcean.INSTANCE.debug("saved " + path4);
        }
        catch (Exception e) {
            Object object = this.data;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"data");
                object = Unit.INSTANCE;
            }
            SkyOcean.INSTANCE.error("Failed to save " + object + " to file", e);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\u0003J\u000f\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000b\u0010\fR!\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\r8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0014\u001a\u0004\u0018\u00010\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0012\u0010\u001d\u001a\u00020\u001a8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lme/owdding/skyocean/utils/storage/ProfileStorage$Companion;", "", "<init>", "()V", "Ltech/thatgravyboat/skyblockapi/api/events/profile/ProfileChangeEvent;", "event", "", "onProfileSwitch", "(Ltech/thatgravyboat/skyblockapi/api/events/profile/ProfileChangeEvent;)V", "onTick", "", "hasProfile", "()Z", "", "Lme/owdding/skyocean/utils/storage/ProfileStorage;", "requiresSave", "Ljava/util/Set;", "getRequiresSave", "()Ljava/util/Set;", "", "currentProfile", "Ljava/lang/String;", "getCurrentProfile", "()Ljava/lang/String;", "setCurrentProfile", "(Ljava/lang/String;)V", "Ljava/nio/file/Path;", "getDefaultPath", "()Ljava/nio/file/Path;", "defaultPath", "skyocean_versions1218"})
    @SourceDebugExtension(value={"SMAP\nProfileStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProfileStorage.kt\nme/owdding/skyocean/utils/storage/ProfileStorage$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,142:1\n37#2:143\n36#2,3:144\n13472#3,2:147\n*S KotlinDebug\n*F\n+ 1 ProfileStorage.kt\nme/owdding/skyocean/utils/storage/ProfileStorage$Companion\n*L\n45#1:143\n45#1:144,3\n48#1:147,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<ProfileStorage<?>> getRequiresSave() {
            return requiresSave;
        }

        @Nullable
        public final String getCurrentProfile() {
            return currentProfile;
        }

        public final void setCurrentProfile(@Nullable String string) {
            currentProfile = string;
        }

        @Subscription
        public final void onProfileSwitch(@NotNull ProfileChangeEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.setCurrentProfile(event.getName());
        }

        @Subscription(event={TickEvent.class})
        @TimePassed(duration="5s")
        public final void onTick() {
            Collection $this$toTypedArray$iv = this.getRequiresSave();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            ProfileStorage[] toSave = thisCollection$iv.toArray(new ProfileStorage[0]);
            this.getRequiresSave().clear();
            CompletableFuture.runAsync(() -> Companion.onTick$lambda$1(toSave));
        }

        @NotNull
        public final Path getDefaultPath() {
            boolean $i$f$getDefaultPath = false;
            return DataStorage.Companion.getDefaultPath();
        }

        private final boolean hasProfile() {
            return this.getCurrentProfile() != null;
        }

        private static final void onTick$lambda$1(ProfileStorage[] $toSave) {
            ProfileStorage[] $this$forEach$iv = $toSave;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int j = 0; j < n; ++j) {
                ProfileStorage element$iv;
                ProfileStorage it = element$iv = $this$forEach$iv[j];
                boolean i2 = false;
                it.saveToSystem();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

