/*
 * Decompiled with CFR 0.152.
 */
package me.owdding.skyocean.utils.boundingboxes;

import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import me.owdding.skyocean.utils.boundingboxes.Branch;
import me.owdding.skyocean.utils.boundingboxes.Leaf;
import me.owdding.skyocean.utils.boundingboxes.Node;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3341;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u001d\b\u0016\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0007\"\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\n\u0010\u000bJ'\u0010\u0011\u001a\u00020\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\f\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0015\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0018\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0013H\u0086\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001aR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010 \u001a\u00020\u001f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!\u00a8\u0006\""}, d2={"Lme/owdding/skyocean/utils/boundingboxes/Octree;", "", "", "Lnet/minecraft/class_3341;", "boxes", "<init>", "(Ljava/util/List;)V", "", "([Lnet/minecraft/class_3341;)V", "", "toString", "()Ljava/lang/String;", "Lkotlin/Function2;", "Lme/owdding/skyocean/utils/boundingboxes/Node;", "", "", "visitor", "visitNode", "(Lkotlin/jvm/functions/Function2;)V", "Lnet/minecraft/class_2338;", "pos", "Lme/owdding/skyocean/utils/boundingboxes/Leaf;", "findLeaf", "(Lnet/minecraft/class_2338;)Lme/owdding/skyocean/utils/boundingboxes/Leaf;", "", "isInside", "(Lnet/minecraft/class_2338;)Z", "contains", "Ljava/util/List;", "getBoxes", "()Ljava/util/List;", "Lme/owdding/skyocean/utils/boundingboxes/Branch;", "root", "Lme/owdding/skyocean/utils/boundingboxes/Branch;", "SkyOcean-1.21.8"})
public final class Octree {
    @NotNull
    private final List<class_3341> boxes;
    @NotNull
    private final Branch root;

    public Octree(@NotNull List<? extends class_3341> boxes) {
        Intrinsics.checkNotNullParameter(boxes, (String)"boxes");
        this.boxes = boxes;
        Object t = class_3341.method_35413((Iterable)this.boxes).get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
        class_3341 encapsulatingBox = (class_3341)t;
        class_2338 center = encapsulatingBox.method_22874();
        int span = Math.max(encapsulatingBox.method_35414(), encapsulatingBox.method_14663()) / 2 + 5;
        class_3341 class_33412 = new class_3341(center).method_59718(span, span, span);
        Intrinsics.checkNotNullExpressionValue((Object)class_33412, (String)"inflatedBy(...)");
        this.root = new Branch(class_33412, this.boxes);
    }

    @NotNull
    public final List<class_3341> getBoxes() {
        return this.boxes;
    }

    public Octree(class_3341 ... boxes) {
        Intrinsics.checkNotNullParameter((Object)boxes, (String)"boxes");
        this(CollectionsKt.listOf((Object[])Arrays.copyOf(boxes, boxes.length)));
    }

    @NotNull
    public String toString() {
        return this.root.toString();
    }

    public final void visitNode(@NotNull Function2<? super Node, ? super Integer, Unit> visitor) {
        Intrinsics.checkNotNullParameter(visitor, (String)"visitor");
        this.root.visit(visitor, 0);
    }

    @Nullable
    public final Leaf findLeaf(@NotNull class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (!this.root.getBox().method_14662((class_2382)pos)) {
            return null;
        }
        return this.root.getNode(pos);
    }

    public final boolean isInside(@NotNull class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Leaf leaf = this.findLeaf(pos);
        return leaf != null ? leaf.isInside(pos) : false;
    }

    public final boolean contains(@NotNull class_2338 pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.isInside(pos);
    }
}

