/*
 * Decompiled with CFR 0.152.
 */
package api.hbm.fluidmk2;

import api.hbm.fluidmk2.FluidNetMK2;
import api.hbm.fluidmk2.IFluidConnectorMK2;
import api.hbm.fluidmk2.IFluidProviderMK2;
import api.hbm.fluidmk2.IFluidReceiverMK2;
import api.ntm1of90.compat.fluid.HBMForgeFluidCompat;
import api.ntm1of90.compat.fluid.bridge.NTMFluidNetworkBridge;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.tank.FluidTank;
import com.hbm.uninos.GenNode;
import com.hbm.uninos.UniNodespace;
import com.hbm.util.Compat;
import com.hbm.util.fauxpointtwelve.DirPos;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public interface IFluidStandardSenderMK2
extends IFluidProviderMK2 {
    default public void tryProvide(FluidTank tank, World world, DirPos pos) {
        this.tryProvide(tank.getTankType(), tank.getPressure(), world, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
    }

    default public void tryProvide(FluidType type, World world, DirPos pos) {
        this.tryProvide(type, 0, world, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
    }

    default public void tryProvide(FluidType type, int pressure, World world, DirPos pos) {
        this.tryProvide(type, pressure, world, pos.getX(), pos.getY(), pos.getZ(), pos.getDir());
    }

    default public void tryProvide(FluidTank tank, World world, int x, int y, int z, ForgeDirection dir) {
        this.tryProvide(tank.getTankType(), tank.getPressure(), world, x, y, z, dir);
    }

    default public void tryProvide(FluidType type, World world, int x, int y, int z, ForgeDirection dir) {
        this.tryProvide(type, 0, world, x, y, z, dir);
    }

    default public void tryProvide(FluidType type, int pressure, World world, int x, int y, int z, ForgeDirection dir) {
        IFluidHandler forgeHandler;
        IFluidReceiverMK2 rec;
        GenNode node;
        IFluidConnectorMK2 con;
        TileEntity te = Compat.getTileStandard(world, x, y, z);
        boolean red = false;
        if (te instanceof IFluidConnectorMK2 && (con = (IFluidConnectorMK2)te).canConnect(type, dir.getOpposite()) && (node = UniNodespace.getNode(world, x, y, z, type.getNetworkProvider())) != null && node.net != null) {
            ((FluidNetMK2)node.net).addProvider(this);
            red = true;
        }
        if (te != this && te instanceof IFluidReceiverMK2 && (rec = (IFluidReceiverMK2)te).canConnect(type, dir.getOpposite())) {
            long provides = Math.min(this.getFluidAvailable(type, pressure), this.getProviderSpeed(type, pressure));
            long receives = Math.min(rec.getDemand(type, pressure), rec.getReceiverSpeed(type, pressure));
            long toTransfer = Math.min(provides, receives);
            toTransfer -= rec.transferFluid(type, pressure, toTransfer);
            this.useUpFluid(type, pressure, toTransfer);
        }
        if (te != this && HBMForgeFluidCompat.isForgeFluidHandler(te) && NTMFluidNetworkBridge.canForgeHandlerAcceptFluid(forgeHandler = HBMForgeFluidCompat.getForgeFluidHandler(te), type, dir.getOpposite())) {
            long provides = Math.min(this.getFluidAvailable(type, pressure), this.getProviderSpeed(type, pressure));
            if (provides <= 0L) {
                return;
            }
            for (FluidTank tank : this.getSendingTanks()) {
                int transferred;
                if (tank.getTankType() != type || tank.getPressure() != pressure || tank.getFill() <= 0 || (transferred = NTMFluidNetworkBridge.transferToForge(tank, forgeHandler, dir.getOpposite(), tank.getFill())) <= 0) continue;
                tank.setFill(tank.getFill() - transferred);
            }
        }
    }

    public FluidTank[] getSendingTanks();

    @Override
    default public long getFluidAvailable(FluidType type, int pressure) {
        long amount = 0L;
        for (FluidTank tank : this.getSendingTanks()) {
            if (tank.getTankType() != type || tank.getPressure() != pressure) continue;
            amount += (long)tank.getFill();
        }
        return amount;
    }

    @Override
    default public void useUpFluid(FluidType type, int pressure, long amount) {
        int tanks = 0;
        for (FluidTank tank : this.getSendingTanks()) {
            if (tank.getTankType() != type || tank.getPressure() != pressure) continue;
            ++tanks;
        }
        if (tanks > 1) {
            int firstRound = (int)Math.floor((double)amount / (double)tanks);
            FluidTank[] fluidTankArray = this.getSendingTanks();
            int n = fluidTankArray.length;
            for (int tank = 0; tank < n; ++tank) {
                FluidTank tank2 = fluidTankArray[tank];
                if (tank2.getTankType() != type || tank2.getPressure() != pressure) continue;
                int toRem = Math.min(firstRound, tank2.getFill());
                tank2.setFill(tank2.getFill() - toRem);
                amount -= (long)toRem;
            }
        }
        if (amount > 0L) {
            for (FluidTank tank : this.getSendingTanks()) {
                if (tank.getTankType() != type || tank.getPressure() != pressure) continue;
                int toRem = (int)Math.min(amount, (long)tank.getFill());
                tank.setFill(tank.getFill() - toRem);
                amount -= (long)toRem;
            }
        }
    }

    @Override
    default public int[] getProvidingPressureRange(FluidType type) {
        int[] nArray;
        int lowest = 5;
        int highest = 0;
        for (FluidTank tank : this.getSendingTanks()) {
            if (tank.getTankType() != type) continue;
            if (tank.getPressure() < lowest) {
                lowest = tank.getPressure();
            }
            if (tank.getPressure() <= highest) continue;
            highest = tank.getPressure();
        }
        if (lowest <= highest) {
            int[] nArray2 = new int[2];
            nArray2[0] = lowest;
            nArray = nArray2;
            nArray2[1] = highest;
        } else {
            nArray = DEFAULT_PRESSURE_RANGE;
        }
        return nArray;
    }

    @Override
    default public long getProviderSpeed(FluidType type, int pressure) {
        return 1000000000L;
    }
}

