/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.ae2;

import api.ntm1of90.compat.fluid.render.ColoredForgeFluid;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class AE2CorePatcher {
    private static boolean initialized = false;
    private static Map<String, Integer> fluidColors = new HashMap<String, Integer>();

    public static void initialize() {
        if (initialized) {
            return;
        }
        if (!Loader.isModLoaded((String)"appliedenergistics2")) {
            System.out.println("[NTM] Applied Energistics 2 not detected, skipping AE2 core patcher");
            return;
        }
        try {
            AE2CorePatcher.registerFluidColors();
            AE2CorePatcher.directlyPatchAE2();
            System.out.println("[NTM] AE2 core patcher initialized");
        }
        catch (Exception e) {
            System.err.println("[NTM] Error initializing AE2 core patcher: " + e.getMessage());
        }
        initialized = true;
    }

    private static void registerFluidColors() {
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            if (!(fluid instanceof ColoredForgeFluid)) continue;
            int color = ((ColoredForgeFluid)fluid).getColorARGB();
            fluidColors.put(fluid.getName(), color);
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void directlyPatchAE2() {
        try {
            Class<?> fluidRenderMapClass = Class.forName("appeng.client.texture.FluidRenderMap");
            Object instance = fluidRenderMapClass.getMethod("instance", new Class[0]).invoke(null, new Object[0]);
            Field colorsField = fluidRenderMapClass.getDeclaredField("colors");
            colorsField.setAccessible(true);
            Map colors = (Map)colorsField.get(instance);
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                if (!(fluid instanceof ColoredForgeFluid)) continue;
                int color = ((ColoredForgeFluid)fluid).getColorARGB();
                colors.put(fluid, color);
            }
            System.out.println("[NTM] Successfully patched AE2's FluidRenderMap directly");
        }
        catch (Exception e) {
            System.err.println("[NTM] Could not patch AE2's FluidRenderMap directly: " + e.getMessage());
            try {
                Class<?> fluidRenderMapClass = Class.forName("appeng.client.texture.FluidRenderMap");
                Object instance = fluidRenderMapClass.getMethod("instance", new Class[0]).invoke(null, new Object[0]);
                Method registerMethod = fluidRenderMapClass.getMethod("registerFluid", Fluid.class, Integer.TYPE);
                for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                    if (!(fluid instanceof ColoredForgeFluid)) continue;
                    int color = ((ColoredForgeFluid)fluid).getColorARGB();
                    registerMethod.invoke(instance, fluid, color);
                }
                System.out.println("[NTM] Successfully registered fluids with AE2's FluidRenderMap");
            }
            catch (Exception ex) {
                System.err.println("[NTM] Could not register fluids with AE2's FluidRenderMap: " + ex.getMessage());
            }
        }
    }

    public static int getFluidColor(Fluid fluid) {
        if (fluid == null) {
            return -1;
        }
        Integer color = fluidColors.get(fluid.getName());
        return color != null ? color : -1;
    }
}

