/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.ae2;

import api.ntm1of90.compat.fluid.render.ColoredForgeFluid;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

@SideOnly(value=Side.CLIENT)
public class AE2FluidCellPatcher {
    private static boolean initialized = false;
    private static Map<String, Integer> fluidColors = new HashMap<String, Integer>();

    public static void initialize() {
        if (initialized) {
            return;
        }
        if (!Loader.isModLoaded((String)"appliedenergistics2")) {
            System.out.println("[NTM] Applied Energistics 2 not detected, skipping AE2 fluid cell patcher");
            return;
        }
        try {
            FMLCommonHandler.instance().bus().register((Object)new AE2FluidCellPatcher());
            AE2FluidCellPatcher.initializeAE2();
            System.out.println("[NTM] AE2 fluid cell patcher initialized");
        }
        catch (Exception e) {
            System.err.println("[NTM] Error initializing AE2 fluid cell patcher: " + e.getMessage());
        }
        initialized = true;
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void initializeAE2() {
        try {
            AE2FluidCellPatcher.registerFluidColors();
            AE2FluidCellPatcher.patchFluidCellInventory();
            AE2FluidCellPatcher.patchFluidCellRenderer();
            AE2FluidCellPatcher.patchFluidCellDisplay();
            System.out.println("[NTM] Successfully initialized AE2 fluid cell patcher");
        }
        catch (Exception e) {
            System.err.println("[NTM] Error initializing AE2 fluid cell patcher: " + e.getMessage());
        }
    }

    private static void registerFluidColors() {
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            if (!(fluid instanceof ColoredForgeFluid)) continue;
            int color = ((ColoredForgeFluid)fluid).getColorARGB();
            fluidColors.put(fluid.getName(), color);
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void patchFluidCellInventory() {
        try {
            Class<?> fluidCellInventoryClass = Class.forName("appeng.me.storage.FluidCellInventory");
            Field fluidColorsField = null;
            for (Field field : fluidCellInventoryClass.getDeclaredFields()) {
                if (field.getType() != Map.class) continue;
                field.setAccessible(true);
                fluidColorsField = field;
                break;
            }
            if (fluidColorsField != null) {
                Map fluidColorsMap = (Map)fluidColorsField.get(null);
                for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                    if (!(fluid instanceof ColoredForgeFluid)) continue;
                    int color = ((ColoredForgeFluid)fluid).getColorARGB();
                    fluidColorsMap.put(fluid, color);
                }
                System.out.println("[NTM] Successfully patched AE2's FluidCellInventory");
            } else {
                System.err.println("[NTM] Could not find fluid colors field in FluidCellInventory");
            }
        }
        catch (Exception e) {
            System.err.println("[NTM] Could not patch AE2's FluidCellInventory: " + e.getMessage());
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void patchFluidCellRenderer() {
        try {
            Class<?> fluidCellRendererClass = Class.forName("appeng.client.render.FluidCellRenderer");
            Method instanceMethod = fluidCellRendererClass.getMethod("instance", new Class[0]);
            Object instance = instanceMethod.invoke(null, new Object[0]);
            Field fluidColorsField = null;
            for (Field field : fluidCellRendererClass.getDeclaredFields()) {
                if (field.getType() != Map.class) continue;
                field.setAccessible(true);
                fluidColorsField = field;
                break;
            }
            if (fluidColorsField != null) {
                Map fluidColorsMap = (Map)fluidColorsField.get(instance);
                for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                    if (!(fluid instanceof ColoredForgeFluid)) continue;
                    int color = ((ColoredForgeFluid)fluid).getColorARGB();
                    fluidColorsMap.put(fluid, color);
                }
                System.out.println("[NTM] Successfully patched AE2's FluidCellRenderer");
            } else {
                System.err.println("[NTM] Could not find fluid colors field in FluidCellRenderer");
            }
        }
        catch (Exception e) {
            System.err.println("[NTM] Could not patch AE2's FluidCellRenderer: " + e.getMessage());
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void patchFluidCellDisplay() {
        try {
            Class<?> fluidCellDisplayClass = Class.forName("appeng.client.gui.widgets.GuiFluidTank");
            Field fluidColorsField = null;
            for (Field field : fluidCellDisplayClass.getDeclaredFields()) {
                if (field.getType() != Map.class) continue;
                field.setAccessible(true);
                fluidColorsField = field;
                break;
            }
            if (fluidColorsField != null) {
                Map fluidColorsMap = (Map)fluidColorsField.get(null);
                for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                    if (!(fluid instanceof ColoredForgeFluid)) continue;
                    int color = ((ColoredForgeFluid)fluid).getColorARGB();
                    fluidColorsMap.put(fluid, color);
                }
                System.out.println("[NTM] Successfully patched AE2's fluid cell display");
            } else {
                System.err.println("[NTM] Could not find fluid colors field in fluid cell display");
            }
        }
        catch (Exception e) {
            System.err.println("[NTM] Could not patch AE2's fluid cell display: " + e.getMessage());
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.func_82737_E() % 100L == 0L) {
            try {
                AE2FluidCellPatcher.patchFluidCellInventory();
                AE2FluidCellPatcher.patchFluidCellRenderer();
                AE2FluidCellPatcher.patchFluidCellDisplay();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static int getFluidColor(Fluid fluid) {
        if (fluid == null) {
            return -1;
        }
        Integer color = fluidColors.get(fluid.getName());
        return color != null ? color : -1;
    }
}

