/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.ae2;

import api.ntm1of90.compat.ae2.AE2CompatTest;
import api.ntm1of90.compat.fluid.FluidDisplayItem;
import api.ntm1of90.compat.fluid.render.ColoredForgeFluid;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

@SideOnly(value=Side.CLIENT)
public class AE2FluidCompat {
    private static boolean initialized = false;
    private static Object fluidRenderMap = null;
    private static Method registerFluidMethod = null;

    public static void initialize() {
        if (initialized) {
            return;
        }
        if (!Loader.isModLoaded((String)"appliedenergistics2")) {
            System.out.println("[NTM] Applied Energistics 2 not detected, skipping AE2 compatibility");
            return;
        }
        try {
            FMLCommonHandler.instance().bus().register((Object)new AE2FluidCompat());
            AE2FluidCompat.initializeAE2();
            System.out.println("[NTM] AE2 compatibility initialized");
        }
        catch (Exception e) {
            System.err.println("[NTM] Error initializing AE2 compatibility: " + e.getMessage());
        }
        initialized = true;
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void initializeAE2() {
        try {
            Class<?> fluidRenderMapClass = Class.forName("appeng.client.texture.FluidRenderMap");
            Method instanceMethod = fluidRenderMapClass.getMethod("instance", new Class[0]);
            fluidRenderMap = instanceMethod.invoke(null, new Object[0]);
            registerFluidMethod = fluidRenderMapClass.getMethod("registerFluid", Fluid.class, Integer.TYPE);
            AE2FluidCompat.registerAllFluids();
            AE2FluidCompat.patchFluidCellInventory();
            AE2FluidCompat.registerFluidItems();
            AE2CompatTest.initialize();
            System.out.println("[NTM] Successfully initialized AE2 integration");
        }
        catch (Exception e) {
            System.err.println("[NTM] Error initializing AE2 integration: " + e.getMessage());
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void registerAllFluids() {
        if (fluidRenderMap == null || registerFluidMethod == null) {
            return;
        }
        try {
            int count = 0;
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                if (!(fluid instanceof ColoredForgeFluid)) continue;
                int colorWithAlpha = ((ColoredForgeFluid)fluid).getColorARGB();
                registerFluidMethod.invoke(fluidRenderMap, fluid, colorWithAlpha);
                ++count;
            }
            System.out.println("[NTM] Registered " + count + " fluids with AE2");
        }
        catch (Exception e) {
            System.err.println("[NTM] Error registering fluids with AE2: " + e.getMessage());
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void patchFluidCellInventory() {
        try {
            Map fluidColorsMap;
            Class<?> fluidCellInventoryClass = Class.forName("appeng.me.storage.FluidCellInventory");
            Field fluidColorsField = null;
            for (Field field : fluidCellInventoryClass.getDeclaredFields()) {
                if (field.getType() != Map.class) continue;
                field.setAccessible(true);
                fluidColorsField = field;
                break;
            }
            if (fluidColorsField != null && (fluidColorsMap = (Map)fluidColorsField.get(null)) != null) {
                for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                    if (!(fluid instanceof ColoredForgeFluid)) continue;
                    int colorWithAlpha = ((ColoredForgeFluid)fluid).getColorARGB();
                    fluidColorsMap.put(fluid, colorWithAlpha);
                }
                System.out.println("[NTM] Successfully patched AE2's fluid cell inventory");
            }
        }
        catch (Exception e) {
            System.err.println("[NTM] Error patching AE2's fluid cell inventory: " + e.getMessage());
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void registerFluidItems() {
        try {
            Class<?> fluidCellInventoryClass = Class.forName("appeng.me.storage.FluidCellInventory");
            Field fluidItemsField = null;
            for (Field field : fluidCellInventoryClass.getDeclaredFields()) {
                Map map;
                if (field.getType() != Map.class) continue;
                field.setAccessible(true);
                Object fieldValue = field.get(null);
                if (fieldValue instanceof Map && !(map = (Map)fieldValue).isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        if (!(entry.getKey() instanceof Fluid) || !(entry.getValue() instanceof ItemStack)) continue;
                        fluidItemsField = field;
                        break;
                    }
                }
                if (fluidItemsField != null) break;
            }
            if (fluidItemsField != null) {
                Map fluidItemsMap = (Map)fluidItemsField.get(null);
                if (fluidItemsMap != null) {
                    int count = 0;
                    for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                        ItemStack itemStack;
                        if (!(fluid instanceof ColoredForgeFluid) || (itemStack = FluidDisplayItem.getItemStackForFluid(fluid)) == null) continue;
                        fluidItemsMap.put(fluid, itemStack);
                        System.out.println("[NTM] Registered item for fluid in AE2: " + fluid.getName());
                        ++count;
                    }
                    System.out.println("[NTM] Registered " + count + " fluid items with AE2");
                }
            } else {
                System.err.println("[NTM] Could not find fluid items field in FluidCellInventory");
            }
        }
        catch (Exception e) {
            System.err.println("[NTM] Error registering fluid items with AE2: " + e.getMessage());
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.func_82737_E() % 100L == 0L) {
            AE2FluidCompat.registerAllFluids();
            AE2FluidCompat.patchFluidCellInventory();
            AE2FluidCompat.registerFluidItems();
        }
    }
}

