/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.ae2;

import api.ntm1of90.compat.fluid.render.ColoredForgeFluid;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class AE2FluidGUIHandler {
    private static boolean initialized = false;
    private static Map<String, Integer> fluidColors = new HashMap<String, Integer>();
    private static Class<?> fluidSlotClass = null;
    private static Field fluidField = null;

    public static void initialize() {
        if (initialized) {
            return;
        }
        if (!Loader.isModLoaded((String)"appliedenergistics2")) {
            System.out.println("[NTM] Applied Energistics 2 not detected, skipping AE2 fluid GUI handler");
            return;
        }
        try {
            MinecraftForge.EVENT_BUS.register((Object)new AE2FluidGUIHandler());
            AE2FluidGUIHandler.initializeAE2();
            System.out.println("[NTM] AE2 fluid GUI handler initialized");
        }
        catch (Exception e) {
            System.err.println("[NTM] Error initializing AE2 fluid GUI handler: " + e.getMessage());
        }
        initialized = true;
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void initializeAE2() {
        try {
            fluidSlotClass = Class.forName("appeng.client.gui.widgets.GuiFluidSlot");
            fluidField = fluidSlotClass.getDeclaredField("myFluid");
            fluidField.setAccessible(true);
            AE2FluidGUIHandler.registerFluidColors();
            System.out.println("[NTM] Successfully hooked into AE2's GUI system");
        }
        catch (Exception e) {
            System.err.println("[NTM] Could not hook into AE2's GUI system: " + e.getMessage());
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void registerFluidColors() {
        try {
            Class<?> fluidRenderClass = Class.forName("appeng.client.gui.widgets.GuiFluidTank");
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                if (!(fluid instanceof ColoredForgeFluid)) continue;
                int color = ((ColoredForgeFluid)fluid).getColorARGB();
                fluidColors.put(fluid.getName(), color);
                try {
                    Method registerColorMethod = fluidRenderClass.getMethod("registerFluidColor", Fluid.class, Integer.TYPE);
                    registerColorMethod.invoke(null, fluid, color);
                    System.out.println("[NTM] Registered color for fluid in AE2 GUI: " + fluid.getName() + " (0x" + Integer.toHexString(color) + ")");
                }
                catch (Exception e) {
                    System.err.println("[NTM] Could not register color for fluid in AE2 GUI: " + e.getMessage());
                }
            }
            System.out.println("[NTM] Registered fluid colors with AE2's GUI system");
        }
        catch (Exception e) {
            System.err.println("[NTM] Could not register fluid colors with AE2's GUI system: " + e.getMessage());
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (!Loader.isModLoaded((String)"appliedenergistics2")) {
            return;
        }
        GuiScreen gui = event.gui;
        if (gui == null) {
            return;
        }
        if (gui.getClass().getName().startsWith("appeng.client.gui")) {
            this.scheduleGuiUpdate(gui);
        }
    }

    private void scheduleGuiUpdate(final GuiScreen gui) {
        FMLCommonHandler.instance().bus().register(new Object(){
            private int ticksWaited = 0;

            @SubscribeEvent
            public void onClientTick(TickEvent.ClientTickEvent event) {
                if (event.phase != TickEvent.Phase.END) {
                    return;
                }
                ++this.ticksWaited;
                if (this.ticksWaited >= 5) {
                    FMLCommonHandler.instance().bus().unregister((Object)this);
                    if (Minecraft.func_71410_x().field_71462_r == gui) {
                        try {
                            AE2FluidGUIHandler.this.findAndUpdateFluidSlots(gui);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        });
    }

    @Optional.Method(modid="appliedenergistics2")
    private void findAndUpdateFluidSlots(GuiScreen gui) {
        try {
            Field[] fields;
            for (Field field : fields = gui.getClass().getDeclaredFields()) {
                Object fluidObj;
                field.setAccessible(true);
                if (fluidSlotClass == null || !fluidSlotClass.isAssignableFrom(field.getType())) continue;
                Object fluidSlot = field.get(gui);
                if (fluidField == null || !((fluidObj = fluidField.get(fluidSlot)) instanceof Fluid)) continue;
                Fluid fluid = (Fluid)fluidObj;
                this.updateFluidSlotColor(fluidSlot, fluid);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private void updateFluidSlotColor(Object fluidSlot, Fluid fluid) {
        try {
            int color = AE2FluidGUIHandler.getFluidColorForAE2(fluid);
            Method setColorMethod = fluidSlotClass.getMethod("setColor", Integer.TYPE);
            setColorMethod.invoke(fluidSlot, color);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void applyFluidColorForAE2(Fluid fluid) {
        if (fluid == null) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            return;
        }
        Integer color = fluidColors.get(fluid.getName());
        if (color != null) {
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static int getFluidColorForAE2(Fluid fluid) {
        if (fluid == null) {
            return -1;
        }
        Integer color = fluidColors.get(fluid.getName());
        return color != null ? color : -1;
    }
}

