/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.ae2;

import api.ntm1of90.compat.fluid.render.ColoredForgeFluid;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class AE2FluidStorageHandler {
    private static boolean initialized = false;
    private static Map<String, Integer> fluidColors = new HashMap<String, Integer>();
    private static Class<?> fluidCellClass = null;
    private static Method getFluidFromCell = null;

    public static void initialize() {
        if (initialized) {
            return;
        }
        if (!Loader.isModLoaded((String)"appliedenergistics2")) {
            System.out.println("[NTM] Applied Energistics 2 not detected, skipping AE2 fluid storage handler");
            return;
        }
        try {
            MinecraftForge.EVENT_BUS.register((Object)new AE2FluidStorageHandler());
            FMLCommonHandler.instance().bus().register((Object)new AE2FluidStorageHandler());
            AE2FluidStorageHandler.initializeAE2();
            System.out.println("[NTM] AE2 fluid storage handler initialized");
        }
        catch (Exception e) {
            System.err.println("[NTM] Error initializing AE2 fluid storage handler: " + e.getMessage());
        }
        initialized = true;
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void initializeAE2() {
        try {
            fluidCellClass = Class.forName("appeng.items.storage.ItemFluidStorage");
            getFluidFromCell = fluidCellClass.getMethod("getFluidFromCell", ItemStack.class);
            AE2FluidStorageHandler.registerFluidColors();
            System.out.println("[NTM] Successfully hooked into AE2's fluid storage system");
        }
        catch (Exception e) {
            System.err.println("[NTM] Could not hook into AE2's fluid storage system: " + e.getMessage());
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private static void registerFluidColors() {
        try {
            Class<?> fluidStorageClass = Class.forName("appeng.me.storage.FluidCellInventory");
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                if (!(fluid instanceof ColoredForgeFluid)) continue;
                int color = ((ColoredForgeFluid)fluid).getColorARGB();
                fluidColors.put(fluid.getName(), color);
                try {
                    Method registerColorMethod = fluidStorageClass.getMethod("registerFluidColor", Fluid.class, Integer.TYPE);
                    registerColorMethod.invoke(null, fluid, color);
                    System.out.println("[NTM] Registered color for fluid in AE2 storage: " + fluid.getName() + " (0x" + Integer.toHexString(color) + ")");
                }
                catch (Exception e) {
                    System.err.println("[NTM] Could not register color for fluid in AE2 storage: " + e.getMessage());
                }
            }
            System.out.println("[NTM] Registered fluid colors with AE2's fluid storage system");
        }
        catch (Exception e) {
            System.err.println("[NTM] Could not register fluid colors with AE2's fluid storage system: " + e.getMessage());
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!Loader.isModLoaded((String)"appliedenergistics2")) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.func_82737_E() % 20L == 0L) {
            this.updateFluidCellColors();
        }
    }

    @Optional.Method(modid="appliedenergistics2")
    private void updateFluidCellColors() {
        try {
            Class<?> fluidCellInventoryClass = Class.forName("appeng.me.storage.FluidCellInventory");
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                if (!(fluid instanceof ColoredForgeFluid)) continue;
                int color = ((ColoredForgeFluid)fluid).getColorARGB();
                try {
                    Method registerColorMethod = fluidCellInventoryClass.getMethod("registerFluidColor", Fluid.class, Integer.TYPE);
                    registerColorMethod.invoke(null, fluid, color);
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void applyFluidColorForAE2(Fluid fluid) {
        if (fluid == null) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            return;
        }
        Integer color = fluidColors.get(fluid.getName());
        if (color != null) {
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            float a = (float)(color >> 24 & 0xFF) / 255.0f;
            GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        } else {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static int getFluidColorForAE2(Fluid fluid) {
        if (fluid == null) {
            return -1;
        }
        Integer color = fluidColors.get(fluid.getName());
        return color != null ? color : -1;
    }
}

