/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.fluid;

import api.ntm1of90.compat.fluid.render.NTMFluidColorApplier;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidDisplayItem
extends Item {
    private static FluidDisplayItem instance;
    private static Map<String, Integer> fluidToMetaMap;
    private static Map<Integer, String> metaToFluidMap;
    private static int nextMeta;
    private IIcon icon;

    public FluidDisplayItem() {
        this.func_77627_a(true);
        this.func_77625_d(1);
        this.func_77655_b("fluidDisplayItem");
        this.func_111206_d("minecraft:bucket_water");
    }

    public static FluidDisplayItem getInstance() {
        if (instance == null) {
            instance = new FluidDisplayItem();
        }
        return instance;
    }

    public static int registerFluid(Fluid fluid) {
        if (fluid == null) {
            return 0;
        }
        String fluidName = fluid.getName();
        if (fluidToMetaMap.containsKey(fluidName)) {
            return fluidToMetaMap.get(fluidName);
        }
        int meta = nextMeta++;
        fluidToMetaMap.put(fluidName, meta);
        metaToFluidMap.put(meta, fluidName);
        return meta;
    }

    public static Fluid getFluidForMeta(int meta) {
        String fluidName = metaToFluidMap.get(meta);
        if (fluidName == null) {
            return null;
        }
        return FluidRegistry.getFluid((String)fluidName);
    }

    public static int getMetaForFluid(Fluid fluid) {
        if (fluid == null) {
            return 0;
        }
        String fluidName = fluid.getName();
        if (fluidToMetaMap.containsKey(fluidName)) {
            return fluidToMetaMap.get(fluidName);
        }
        return FluidDisplayItem.registerFluid(fluid);
    }

    public static ItemStack getItemStackForFluid(Fluid fluid) {
        if (fluid == null) {
            return null;
        }
        int meta = FluidDisplayItem.getMetaForFluid(fluid);
        return new ItemStack((Item)FluidDisplayItem.getInstance(), 1, meta);
    }

    public static ItemStack getItemStackForFluidStack(FluidStack fluidStack) {
        if (fluidStack == null || fluidStack.getFluid() == null) {
            return null;
        }
        return FluidDisplayItem.getItemStackForFluid(fluidStack.getFluid());
    }

    public static FluidStack getFluidStackForItemStack(ItemStack itemStack, int amount) {
        if (itemStack == null || itemStack.func_77973_b() != FluidDisplayItem.getInstance()) {
            return null;
        }
        Fluid fluid = FluidDisplayItem.getFluidForMeta(itemStack.func_77960_j());
        if (fluid == null) {
            return null;
        }
        return new FluidStack(fluid, amount);
    }

    public String func_77653_i(ItemStack stack) {
        Fluid fluid = FluidDisplayItem.getFluidForMeta(stack.func_77960_j());
        if (fluid == null) {
            return "Unknown Fluid";
        }
        return fluid.getLocalizedName(new FluidStack(fluid, 1000));
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        Fluid fluid = FluidDisplayItem.getFluidForMeta(stack.func_77960_j());
        if (fluid == null) {
            return 0xFFFFFF;
        }
        return NTMFluidColorApplier.getFluidColorForInventory(fluid);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.icon = register.func_94245_a("minecraft:bucket_water");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        return this.icon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return false;
    }

    static {
        fluidToMetaMap = new HashMap<String, Integer>();
        metaToFluidMap = new HashMap<Integer, String>();
        nextMeta = 1;
    }
}

