/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.fluid;

import api.hbm.fluidmk2.IFluidUserMK2;
import api.ntm1of90.compat.fluid.registry.ForgeFluidAdapterRegistry;
import com.hbm.main.MainRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class ForgeFluidCapabilityHook {
    private static boolean initialized = false;

    public static void initialize() {
        if (initialized) {
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)new ForgeFluidCapabilityHook());
        FMLCommonHandler.instance().bus().register((Object)new ForgeFluidCapabilityHook());
        initialized = true;
        MainRegistry.logger.info("ForgeFluidCapabilityHook initialized");
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        boolean handled;
        ItemStack heldItem;
        IFluidHandler fluidHandler;
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        TileEntity tileEntity = event.world.func_147438_o(event.x, event.y, event.z);
        if (tileEntity == null) {
            return;
        }
        if (tileEntity instanceof IFluidHandler) {
            return;
        }
        if (tileEntity instanceof IFluidUserMK2 && (fluidHandler = ForgeFluidAdapterRegistry.getFluidHandler(tileEntity)) != null && (heldItem = event.entityPlayer.func_70694_bm()) != null && FluidContainerRegistry.isContainer((ItemStack)heldItem) && (handled = this.handleFluidContainerInteraction(heldItem, fluidHandler, event.entityPlayer))) {
            event.useBlock = Event.Result.ALLOW;
            event.useItem = Event.Result.DENY;
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        ForgeFluidAdapterRegistry.clearAdapters();
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (WorldServer world : MinecraftServer.func_71276_C().field_71305_c) {
            for (Object obj : world.field_147482_g) {
                TileEntity tileEntity;
                if (!(obj instanceof TileEntity) || (tileEntity = (TileEntity)obj) == null || tileEntity.func_145837_r() || !(tileEntity instanceof IFluidUserMK2) || tileEntity instanceof IFluidHandler) continue;
                ForgeFluidAdapterRegistry.getFluidHandler(tileEntity);
            }
        }
    }

    private boolean handleFluidContainerInteraction(ItemStack container, IFluidHandler fluidHandler, EntityPlayer player) {
        if (container == null || fluidHandler == null) {
            return false;
        }
        FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)container);
        if (fluid != null) {
            int filled = fluidHandler.fill(ForgeDirection.UNKNOWN, fluid, false);
            if (filled > 0) {
                ItemStack emptyContainer;
                fluidHandler.fill(ForgeDirection.UNKNOWN, fluid, true);
                if (!player.field_71075_bZ.field_75098_d && (emptyContainer = FluidContainerRegistry.drainFluidContainer((ItemStack)container)) != null) {
                    if (container.field_77994_a == 1) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, emptyContainer);
                    } else {
                        --container.field_77994_a;
                        if (!player.field_71071_by.func_70441_a(emptyContainer)) {
                            player.func_71019_a(emptyContainer, false);
                        }
                    }
                }
                return true;
            }
        } else {
            FluidTankInfo[] tankInfo = fluidHandler.getTankInfo(ForgeDirection.UNKNOWN);
            if (tankInfo != null && tankInfo.length > 0) {
                for (FluidTankInfo info : tankInfo) {
                    FluidStack drained;
                    FluidStack fluidToExtract;
                    ItemStack filledContainer;
                    if (info.fluid == null || info.fluid.amount <= 0 || (filledContainer = FluidContainerRegistry.fillFluidContainer((FluidStack)info.fluid, (ItemStack)container)) == null || (fluidToExtract = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filledContainer)) == null || (drained = fluidHandler.drain(ForgeDirection.UNKNOWN, fluidToExtract, true)) == null || drained.amount <= 0) continue;
                    if (!player.field_71075_bZ.field_75098_d) {
                        if (container.field_77994_a == 1) {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, filledContainer);
                        } else {
                            --container.field_77994_a;
                            if (!player.field_71071_by.func_70441_a(filledContainer)) {
                                player.func_71019_a(filledContainer, false);
                            }
                        }
                    }
                    return true;
                }
            }
        }
        return false;
    }
}

