/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.fluid;

import api.hbm.fluidmk2.IFluidUserMK2;
import api.ntm1of90.compat.fluid.adapter.AutoForgeFluidAdapter;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;

public class ForgeFluidCompatMixin {
    private static final Map<IFluidUserMK2, AutoForgeFluidAdapter> adapterCache = new HashMap<IFluidUserMK2, AutoForgeFluidAdapter>();

    public static AutoForgeFluidAdapter getAdapter(IFluidUserMK2 fluidUser, TileEntity tileEntity) {
        if (!adapterCache.containsKey(fluidUser)) {
            adapterCache.put(fluidUser, new AutoForgeFluidAdapter(fluidUser, tileEntity));
        }
        return adapterCache.get(fluidUser);
    }

    public static int fill(IFluidUserMK2 fluidUser, TileEntity tileEntity, ForgeDirection from, FluidStack resource, boolean doFill) {
        return ForgeFluidCompatMixin.getAdapter(fluidUser, tileEntity).fill(from, resource, doFill);
    }

    public static FluidStack drain(IFluidUserMK2 fluidUser, TileEntity tileEntity, ForgeDirection from, FluidStack resource, boolean doDrain) {
        return ForgeFluidCompatMixin.getAdapter(fluidUser, tileEntity).drain(from, resource, doDrain);
    }

    public static FluidStack drain(IFluidUserMK2 fluidUser, TileEntity tileEntity, ForgeDirection from, int maxDrain, boolean doDrain) {
        return ForgeFluidCompatMixin.getAdapter(fluidUser, tileEntity).drain(from, maxDrain, doDrain);
    }

    public static boolean canFill(IFluidUserMK2 fluidUser, TileEntity tileEntity, ForgeDirection from, Fluid fluid) {
        return ForgeFluidCompatMixin.getAdapter(fluidUser, tileEntity).canFill(from, fluid);
    }

    public static boolean canDrain(IFluidUserMK2 fluidUser, TileEntity tileEntity, ForgeDirection from, Fluid fluid) {
        return ForgeFluidCompatMixin.getAdapter(fluidUser, tileEntity).canDrain(from, fluid);
    }

    public static FluidTankInfo[] getTankInfo(IFluidUserMK2 fluidUser, TileEntity tileEntity, ForgeDirection from) {
        return ForgeFluidCompatMixin.getAdapter(fluidUser, tileEntity).getTankInfo(from);
    }
}

