/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.fluid;

import api.ntm1of90.compat.fluid.HBMForgeFluidCompat;
import api.ntm1of90.compat.fluid.bridge.NTMFluidNetworkBridge;
import api.ntm1of90.compat.fluid.registry.FluidMappingRegistry;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;

public class HBMForgeFluidBlockCompat {
    public static boolean isForgeFluidBlock(Block block) {
        return block instanceof IFluidBlock;
    }

    public static Fluid getForgeFluid(Block block) {
        if (block instanceof IFluidBlock) {
            return ((IFluidBlock)block).getFluid();
        }
        return null;
    }

    public static FluidType getHbmFluidType(Block block) {
        Fluid fluid = HBMForgeFluidBlockCompat.getForgeFluid(block);
        if (fluid != null) {
            return FluidMappingRegistry.getHbmFluidType(fluid);
        }
        return Fluids.NONE;
    }

    public static boolean isForgeFluidHandler(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        return HBMForgeFluidCompat.isForgeFluidHandler(tile);
    }

    public static IFluidHandler getForgeFluidHandler(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        return HBMForgeFluidCompat.getForgeFluidHandler(tile);
    }

    public static int transferToForgeBlock(FluidTank hbmTank, World world, int x, int y, int z, ForgeDirection direction, int maxAmount) {
        IFluidHandler forgeHandler = HBMForgeFluidBlockCompat.getForgeFluidHandler((IBlockAccess)world, x, y, z);
        if (forgeHandler != null) {
            return NTMFluidNetworkBridge.transferToForge(hbmTank, forgeHandler, direction, maxAmount);
        }
        return 0;
    }

    public static int transferFromForgeBlock(World world, int x, int y, int z, FluidTank hbmTank, ForgeDirection direction, int maxAmount) {
        IFluidHandler forgeHandler = HBMForgeFluidBlockCompat.getForgeFluidHandler((IBlockAccess)world, x, y, z);
        if (forgeHandler != null) {
            return NTMFluidNetworkBridge.transferFromForge(forgeHandler, hbmTank, direction, maxAmount);
        }
        return 0;
    }

    public static boolean canForgeBlockAcceptFluid(IBlockAccess world, int x, int y, int z, FluidType hbmFluid, ForgeDirection direction) {
        IFluidHandler forgeHandler = HBMForgeFluidBlockCompat.getForgeFluidHandler(world, x, y, z);
        if (forgeHandler != null) {
            return NTMFluidNetworkBridge.canForgeHandlerAcceptFluid(forgeHandler, hbmFluid, direction);
        }
        return false;
    }

    public static boolean canForgeBlockProvideFluid(IBlockAccess world, int x, int y, int z, FluidType hbmFluid, ForgeDirection direction) {
        IFluidHandler forgeHandler = HBMForgeFluidBlockCompat.getForgeFluidHandler(world, x, y, z);
        if (forgeHandler != null) {
            return NTMFluidNetworkBridge.canForgeHandlerProvideFluid(forgeHandler, hbmFluid, direction);
        }
        return false;
    }

    public static IFluidHandler createForgeFluidHandler(World world, int x, int y, int z, FluidTank tank) {
        TileEntity tile = world.func_147438_o(x, y, z);
        return HBMForgeFluidCompat.createForgeFluidHandler(tile, tank);
    }

    public static IFluidHandler createForgeFluidHandler(World world, int x, int y, int z, FluidTank[] tanks) {
        TileEntity tile = world.func_147438_o(x, y, z);
        return HBMForgeFluidCompat.createForgeFluidHandler(tile, tanks);
    }
}

