/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.fluid;

import api.ntm1of90.compat.fluid.NTMFluidCompatItem;
import api.ntm1of90.compat.fluid.registry.FluidMappingRegistry;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.items.ModItems;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class NTMFluidCompat {
    public static void initialize() {
        NTMFluidCompat.registerFluidCompatItem();
        NTMFluidCompat.registerFluidItems();
        System.out.println("[NTM] Fluid compatibility initialized");
    }

    private static void registerFluidCompatItem() {
        NTMFluidCompatItem fluidCompatItem = NTMFluidCompatItem.getInstance();
        GameRegistry.registerItem((Item)fluidCompatItem, (String)"ntm_fluid_compat");
        ModItems.hbm_fluid_compat = fluidCompatItem;
        System.out.println("[NTM] Registered fluid compat item");
    }

    private static void registerFluidItems() {
        int count = 0;
        for (FluidType ntmFluid : Fluids.getAll()) {
            ItemStack fluidItem;
            Fluid forgeFluid;
            if (ntmFluid == Fluids.NONE || (forgeFluid = FluidMappingRegistry.getForgeFluid(ntmFluid)) == null || (fluidItem = NTMFluidCompatItem.getItemStackForFluid(forgeFluid)) == null) continue;
            FluidContainerRegistry.registerFluidContainer((FluidStack)new FluidStack(forgeFluid, 1000), (ItemStack)fluidItem);
            ++count;
        }
        System.out.println("[NTM] Registered " + count + " fluid items");
    }

    public static ItemStack getFluidItem(Fluid fluid) {
        return NTMFluidCompatItem.getItemStackForFluid(fluid);
    }

    public static ItemStack getFluidItem(String fluidName) {
        Fluid fluid = FluidRegistry.getFluid((String)fluidName);
        return NTMFluidCompat.getFluidItem(fluid);
    }

    public static ItemStack getFluidItem(FluidType ntmFluid) {
        if (ntmFluid == null || ntmFluid == Fluids.NONE) {
            return null;
        }
        Fluid forgeFluid = FluidMappingRegistry.getForgeFluid(ntmFluid);
        return NTMFluidCompat.getFluidItem(forgeFluid);
    }
}

