/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.fluid;

import api.ntm1of90.compat.fluid.render.NTMFluidCompatRenderer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class NTMFluidCompatItem
extends Item {
    private static NTMFluidCompatItem instance;
    private static final Map<String, ItemStack> fluidItems;

    public static NTMFluidCompatItem getInstance() {
        if (instance == null) {
            instance = new NTMFluidCompatItem();
        }
        return instance;
    }

    private NTMFluidCompatItem() {
        this.func_77655_b("ntm_fluid_compat");
        this.func_111206_d("hbm:forgefluid/water");
        this.func_77637_a(null);
    }

    public static ItemStack getItemStackForFluid(Fluid fluid) {
        if (fluid == null) {
            return null;
        }
        String fluidName = fluid.getName();
        ItemStack item = fluidItems.get(fluidName);
        if (item != null) {
            return item.func_77946_l();
        }
        item = new ItemStack((Item)NTMFluidCompatItem.getInstance());
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("fluid", fluidName);
        item.func_77982_d(tag);
        fluidItems.put(fluidName, item);
        return item.func_77946_l();
    }

    public static Fluid getFluidFromItemStack(ItemStack stack) {
        if (stack == null || stack.func_77973_b() != NTMFluidCompatItem.getInstance() || !stack.func_77942_o()) {
            return null;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (!tag.func_74764_b("fluid")) {
            return null;
        }
        String fluidName = tag.func_74779_i("fluid");
        return FluidRegistry.getFluid((String)fluidName);
    }

    public static FluidStack getFluidStackFromItemStack(ItemStack stack, int amount) {
        Fluid fluid = NTMFluidCompatItem.getFluidFromItemStack(stack);
        if (fluid == null) {
            return null;
        }
        return new FluidStack(fluid, amount);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int pass) {
        IIcon icon;
        Fluid fluid = NTMFluidCompatItem.getFluidFromItemStack(stack);
        if (fluid != null && (icon = NTMFluidCompatRenderer.getFluidIcon(fluid)) != null) {
            return icon;
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        Fluid fluid = NTMFluidCompatItem.getFluidFromItemStack(stack);
        if (fluid != null) {
            return NTMFluidCompatRenderer.getFluidColor(fluid);
        }
        return 0xFFFFFF;
    }

    public String func_77653_i(ItemStack stack) {
        Fluid fluid = NTMFluidCompatItem.getFluidFromItemStack(stack);
        if (fluid != null) {
            return fluid.getLocalizedName(new FluidStack(fluid, 1000));
        }
        return super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
    }

    static {
        fluidItems = new HashMap<String, ItemStack>();
    }
}

