/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.fluid.adapter;

import api.ntm1of90.compat.fluid.registry.FluidMappingRegistry;
import api.ntm1of90.compat.fluid.util.NTMForgeFluidConverter;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class NTMFluidNetworkAdapter
implements IFluidHandler {
    private final FluidTank ntmTank;
    private final TileEntity tileEntity;

    public NTMFluidNetworkAdapter(FluidTank tank, TileEntity tile) {
        this.ntmTank = tank;
        this.tileEntity = tile;
    }

    private int toForgeAmount(int ntmAmount) {
        return NTMForgeFluidConverter.toForgeAmount(ntmAmount);
    }

    private int toNTMAmount(int forgeAmount) {
        return NTMForgeFluidConverter.toNTMAmount(forgeAmount);
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null || resource.amount <= 0) {
            return 0;
        }
        FluidType ntmFluid = FluidMappingRegistry.getHbmFluidType(resource.getFluid());
        if (ntmFluid == Fluids.NONE) {
            return 0;
        }
        int ntmAmount = this.toNTMAmount(resource.amount);
        int currentFill = this.ntmTank.getFill();
        int maxFill = this.ntmTank.getMaxFill();
        FluidType currentType = this.ntmTank.getTankType();
        if (currentFill > 0 && currentType != ntmFluid) {
            return 0;
        }
        int fillAmount = Math.min(ntmAmount, maxFill - currentFill);
        if (fillAmount <= 0) {
            return 0;
        }
        if (doFill) {
            this.ntmTank.setTankType(ntmFluid);
            this.ntmTank.setFill(currentFill + fillAmount);
            if (this.tileEntity != null) {
                this.tileEntity.func_70296_d();
            }
        }
        return this.toForgeAmount(fillAmount);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (resource == null) {
            return null;
        }
        FluidType currentType = this.ntmTank.getTankType();
        Fluid forgeFluid = FluidMappingRegistry.getForgeFluid(currentType);
        if (forgeFluid == null || !resource.getFluid().equals(forgeFluid)) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (maxDrain <= 0) {
            return null;
        }
        int currentFill = this.ntmTank.getFill();
        FluidType currentType = this.ntmTank.getTankType();
        if (currentFill <= 0 || currentType == Fluids.NONE) {
            return null;
        }
        Fluid forgeFluid = FluidMappingRegistry.getForgeFluid(currentType);
        if (forgeFluid == null) {
            return null;
        }
        int ntmDrainAmount = this.toNTMAmount(maxDrain);
        int drainAmount = Math.min(ntmDrainAmount, currentFill);
        if (drainAmount <= 0) {
            return null;
        }
        FluidStack result = new FluidStack(forgeFluid, this.toForgeAmount(drainAmount));
        if (doDrain) {
            int newFill = currentFill - drainAmount;
            this.ntmTank.setFill(newFill);
            if (newFill <= 0) {
                this.ntmTank.setTankType(Fluids.NONE);
            }
            if (this.tileEntity != null) {
                this.tileEntity.func_70296_d();
            }
        }
        return result;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (fluid == null) {
            return false;
        }
        FluidType ntmFluid = FluidMappingRegistry.getHbmFluidType(fluid);
        if (ntmFluid == Fluids.NONE) {
            return false;
        }
        FluidType currentType = this.ntmTank.getTankType();
        int currentFill = this.ntmTank.getFill();
        return currentFill <= 0 || currentType == ntmFluid;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (this.ntmTank.getFill() <= 0) {
            return false;
        }
        if (fluid == null) {
            return true;
        }
        FluidType currentType = this.ntmTank.getTankType();
        Fluid forgeFluid = FluidMappingRegistry.getForgeFluid(currentType);
        return forgeFluid != null && forgeFluid.equals(fluid);
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        Fluid forgeFluid;
        int currentFill = this.ntmTank.getFill();
        int maxFill = this.ntmTank.getMaxFill();
        FluidType currentType = this.ntmTank.getTankType();
        FluidStack stack = null;
        if (currentFill > 0 && currentType != Fluids.NONE && (forgeFluid = FluidMappingRegistry.getForgeFluid(currentType)) != null) {
            stack = new FluidStack(forgeFluid, this.toForgeAmount(currentFill));
        }
        return new FluidTankInfo[]{new FluidTankInfo(stack, this.toForgeAmount(maxFill))};
    }
}

