/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.fluid.adapter;

import api.ntm1of90.compat.fluid.registry.FluidMappingRegistry;
import com.hbm.tileentity.TileEntityProxyBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class ProxyForgeAdapter
extends TileEntityProxyBase
implements IFluidHandler {
    private boolean isFluidHandler = false;

    public ProxyForgeAdapter() {
    }

    public ProxyForgeAdapter(boolean inventory, boolean power, boolean fluid) {
        this.isFluidHandler = fluid;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!this.isFluidHandler || resource == null || resource.amount <= 0) {
            return 0;
        }
        TileEntity te = this.getTE();
        if (te instanceof IFluidHandler) {
            return ((IFluidHandler)te).fill(from, resource, doFill);
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (!this.isFluidHandler || resource == null || resource.amount <= 0) {
            return null;
        }
        TileEntity te = this.getTE();
        if (te instanceof IFluidHandler) {
            return ((IFluidHandler)te).drain(from, resource, doDrain);
        }
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (!this.isFluidHandler || maxDrain <= 0) {
            return null;
        }
        TileEntity te = this.getTE();
        if (te instanceof IFluidHandler) {
            return ((IFluidHandler)te).drain(from, maxDrain, doDrain);
        }
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        if (!this.isFluidHandler) {
            return false;
        }
        TileEntity te = this.getTE();
        if (te instanceof IFluidHandler) {
            return ((IFluidHandler)te).canFill(from, fluid);
        }
        return false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        if (!this.isFluidHandler) {
            return false;
        }
        TileEntity te = this.getTE();
        if (te instanceof IFluidHandler) {
            return ((IFluidHandler)te).canDrain(from, fluid);
        }
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        if (!this.isFluidHandler) {
            return new FluidTankInfo[0];
        }
        TileEntity te = this.getTE();
        if (te instanceof IFluidHandler) {
            return ((IFluidHandler)te).getTankInfo(from);
        }
        return new FluidTankInfo[0];
    }

    public boolean canConnectFluid(ForgeDirection from) {
        return this.isFluidHandler;
    }

    public boolean isConnectable(ForgeDirection from) {
        return this.isFluidHandler;
    }

    public boolean canInterface(ForgeDirection from) {
        return this.isFluidHandler;
    }

    public boolean canInputFluid(ForgeDirection from) {
        return this.isFluidHandler;
    }

    public boolean canOutputFluid(ForgeDirection from) {
        return this.isFluidHandler;
    }

    public boolean canReceiveFrom(ForgeDirection from) {
        return this.isFluidHandler;
    }

    public boolean canSendTo(ForgeDirection from) {
        return this.isFluidHandler;
    }

    public boolean canAcceptFluid(ForgeDirection from) {
        return this.isFluidHandler;
    }

    public boolean canProvideFluid(ForgeDirection from) {
        return this.isFluidHandler;
    }

    public boolean isFluidHandler(ForgeDirection from) {
        return this.isFluidHandler;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isFluidHandler = nbt.func_74767_n("isFluidHandler");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("isFluidHandler", this.isFluidHandler);
    }

    static {
        FluidMappingRegistry.initialize();
    }
}

