/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.fluid.bridge;

import api.hbm.fluidmk2.IFluidProviderMK2;
import api.hbm.fluidmk2.IFluidReceiverMK2;
import api.hbm.fluidmk2.IFluidStandardSenderMK2;
import api.hbm.fluidmk2.IFluidUserMK2;
import api.ntm1of90.compat.fluid.ForgeFluidCompatManager;
import api.ntm1of90.compat.fluid.registry.FluidMappingRegistry;
import api.ntm1of90.compat.fluid.registry.ForgeFluidAdapterRegistry;
import api.ntm1of90.compat.fluid.util.NTMForgeFluidConverter;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import com.hbm.inventory.fluid.tank.FluidTank;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class NTMFluidNetworkBridge {
    public static int transferToForge(FluidTank ntmTank, IFluidHandler forgeHandler, ForgeDirection direction, int maxAmount) {
        if (ntmTank == null || forgeHandler == null || maxAmount <= 0) {
            return 0;
        }
        FluidType ntmFluidType = ntmTank.getTankType();
        int ntmFill = ntmTank.getFill();
        if (ntmFluidType == Fluids.NONE || ntmFill <= 0) {
            return 0;
        }
        Fluid forgeFluid = FluidMappingRegistry.getForgeFluid(ntmFluidType);
        if (forgeFluid == null) {
            return 0;
        }
        int transferAmount = Math.min(maxAmount, ntmFill);
        int forgeAmount = NTMForgeFluidConverter.toForgeAmount(transferAmount);
        FluidStack stack = new FluidStack(forgeFluid, forgeAmount);
        int filledAmount = forgeHandler.fill(direction.getOpposite(), stack, true);
        if (filledAmount <= 0) {
            return 0;
        }
        int ntmTransferred = NTMForgeFluidConverter.toNTMAmount(filledAmount);
        int newFill = ntmFill - ntmTransferred;
        ntmTank.setFill(newFill);
        return ntmTransferred;
    }

    public static int transferFromForge(IFluidHandler forgeHandler, FluidTank ntmTank, ForgeDirection direction, int maxAmount) {
        if (forgeHandler == null || ntmTank == null || maxAmount <= 0) {
            return 0;
        }
        FluidType currentType = ntmTank.getTankType();
        int currentFill = ntmTank.getFill();
        int maxFill = ntmTank.getMaxFill();
        int availableSpace = maxFill - currentFill;
        if (availableSpace <= 0) {
            return 0;
        }
        int transferAmount = Math.min(maxAmount, availableSpace);
        int forgeAmount = NTMForgeFluidConverter.toForgeAmount(transferAmount);
        FluidStack drainedStack = null;
        if (currentType != Fluids.NONE && currentFill > 0) {
            Fluid forgeFluid = FluidMappingRegistry.getForgeFluid(currentType);
            if (forgeFluid != null) {
                FluidStack requestStack = new FluidStack(forgeFluid, forgeAmount);
                drainedStack = forgeHandler.drain(direction.getOpposite(), requestStack, true);
            }
        } else {
            drainedStack = forgeHandler.drain(direction.getOpposite(), forgeAmount, true);
        }
        if (drainedStack == null || drainedStack.amount <= 0) {
            return 0;
        }
        NTMForgeFluidConverter.FluidPair ntmFluid = NTMForgeFluidConverter.toNTMFluid(drainedStack);
        if (ntmFluid.type == Fluids.NONE) {
            return 0;
        }
        if (currentFill > 0 && currentType != ntmFluid.type) {
            return 0;
        }
        ntmTank.setTankType(ntmFluid.type);
        ntmTank.setFill(currentFill + ntmFluid.amount);
        return ntmFluid.amount;
    }

    public static boolean canForgeHandlerAcceptFluid(IFluidHandler forgeHandler, FluidType ntmFluid, ForgeDirection direction) {
        if (forgeHandler == null || ntmFluid == Fluids.NONE) {
            return false;
        }
        Fluid forgeFluid = FluidMappingRegistry.getForgeFluid(ntmFluid);
        if (forgeFluid == null) {
            return false;
        }
        return forgeHandler.canFill(direction.getOpposite(), forgeFluid);
    }

    public static boolean canTileEntityAcceptFluid(TileEntity tileEntity, FluidType ntmFluid, ForgeDirection direction) {
        IFluidHandler handler;
        if (tileEntity == null || ntmFluid == Fluids.NONE) {
            return false;
        }
        if (tileEntity instanceof IFluidHandler) {
            return NTMFluidNetworkBridge.canForgeHandlerAcceptFluid((IFluidHandler)tileEntity, ntmFluid, direction);
        }
        if (tileEntity instanceof IFluidUserMK2 && (handler = ForgeFluidAdapterRegistry.getFluidHandler(tileEntity)) != null) {
            return NTMFluidNetworkBridge.canForgeHandlerAcceptFluid(handler, ntmFluid, direction);
        }
        return false;
    }

    public static boolean canForgeHandlerProvideFluid(IFluidHandler forgeHandler, FluidType ntmFluid, ForgeDirection direction) {
        if (forgeHandler == null || ntmFluid == Fluids.NONE) {
            return false;
        }
        Fluid forgeFluid = FluidMappingRegistry.getForgeFluid(ntmFluid);
        if (forgeFluid == null) {
            return false;
        }
        return forgeHandler.canDrain(direction.getOpposite(), forgeFluid);
    }

    public static boolean canTileEntityProvideFluid(TileEntity tileEntity, FluidType ntmFluid, ForgeDirection direction) {
        IFluidHandler handler;
        if (tileEntity == null || ntmFluid == Fluids.NONE) {
            return false;
        }
        if (tileEntity instanceof IFluidHandler) {
            return NTMFluidNetworkBridge.canForgeHandlerProvideFluid((IFluidHandler)tileEntity, ntmFluid, direction);
        }
        if (tileEntity instanceof IFluidUserMK2 && (handler = ForgeFluidAdapterRegistry.getFluidHandler(tileEntity)) != null) {
            return NTMFluidNetworkBridge.canForgeHandlerProvideFluid(handler, ntmFluid, direction);
        }
        return false;
    }

    public static NTMForgeFluidConverter.FluidPair[] getForgeHandlerFluids(IFluidHandler forgeHandler, ForgeDirection direction) {
        if (forgeHandler == null) {
            return new NTMForgeFluidConverter.FluidPair[0];
        }
        FluidTankInfo[] tankInfo = forgeHandler.getTankInfo(direction.getOpposite());
        if (tankInfo == null || tankInfo.length == 0) {
            return new NTMForgeFluidConverter.FluidPair[0];
        }
        NTMForgeFluidConverter.FluidPair[] result = new NTMForgeFluidConverter.FluidPair[tankInfo.length];
        for (int i = 0; i < tankInfo.length; ++i) {
            FluidStack stack = tankInfo[i].fluid;
            result[i] = stack != null && stack.amount > 0 ? NTMForgeFluidConverter.toNTMFluid(stack) : new NTMForgeFluidConverter.FluidPair(Fluids.NONE, 0);
        }
        return result;
    }

    public static NTMForgeFluidConverter.FluidPair[] getTileEntityFluids(TileEntity tileEntity, ForgeDirection direction) {
        IFluidHandler handler;
        if (tileEntity == null) {
            return new NTMForgeFluidConverter.FluidPair[0];
        }
        if (tileEntity instanceof IFluidHandler) {
            return NTMFluidNetworkBridge.getForgeHandlerFluids((IFluidHandler)tileEntity, direction);
        }
        if (tileEntity instanceof IFluidUserMK2 && (handler = ForgeFluidAdapterRegistry.getFluidHandler(tileEntity)) != null) {
            return NTMFluidNetworkBridge.getForgeHandlerFluids(handler, direction);
        }
        return new NTMForgeFluidConverter.FluidPair[0];
    }

    public static FluidTankInfo[] getTankInfo(IFluidUserMK2 fluidUser) {
        if (fluidUser == null) {
            return new FluidTankInfo[0];
        }
        FluidTank[] hbmTanks = fluidUser.getAllTanks();
        FluidTankInfo[] tankInfo = new FluidTankInfo[hbmTanks.length];
        for (int i = 0; i < hbmTanks.length; ++i) {
            Fluid forgeFluid;
            FluidTank tank = hbmTanks[i];
            int currentFill = tank.getFill();
            int maxFill = tank.getMaxFill();
            FluidType currentType = tank.getTankType();
            FluidStack stack = null;
            if (currentFill > 0 && currentType != Fluids.NONE && (forgeFluid = FluidMappingRegistry.getForgeFluid(currentType)) != null) {
                stack = new FluidStack(forgeFluid, NTMForgeFluidConverter.toForgeAmount(currentFill));
            }
            tankInfo[i] = new FluidTankInfo(stack, NTMForgeFluidConverter.toForgeAmount(maxFill));
        }
        return tankInfo;
    }

    public static int fillFromForge(IFluidReceiverMK2 receiver, FluidStack resource, boolean doFill) {
        if (receiver == null || resource == null || resource.amount <= 0) {
            return 0;
        }
        FluidType hbmFluid = FluidMappingRegistry.getHbmFluidType(resource.getFluid());
        if (hbmFluid == Fluids.NONE) {
            return 0;
        }
        long demand = receiver.getDemand(hbmFluid, 0);
        if (demand <= 0L) {
            return 0;
        }
        int hbmAmount = NTMForgeFluidConverter.toNTMAmount(resource.amount);
        long fillAmount = Math.min((long)hbmAmount, demand);
        if ((fillAmount = Math.min(fillAmount, receiver.getReceiverSpeed(hbmFluid, 0))) <= 0L) {
            return 0;
        }
        if (doFill) {
            long remaining = receiver.transferFluid(hbmFluid, 0, fillAmount);
            fillAmount -= remaining;
        }
        return NTMForgeFluidConverter.toForgeAmount((int)fillAmount);
    }

    public static FluidStack drainToForge(IFluidStandardSenderMK2 sender, FluidStack resource, boolean doDrain) {
        if (sender == null || resource == null || resource.amount <= 0) {
            return null;
        }
        FluidType hbmFluid = FluidMappingRegistry.getHbmFluidType(resource.getFluid());
        if (hbmFluid == Fluids.NONE) {
            return null;
        }
        FluidTank[] tanks = sender.getSendingTanks();
        if (tanks.length == 0) {
            return null;
        }
        for (FluidTank tank : tanks) {
            Fluid forgeFluid;
            int currentFill = tank.getFill();
            FluidType currentType = tank.getTankType();
            if (currentFill <= 0 || currentType != hbmFluid) continue;
            int hbmAmount = NTMForgeFluidConverter.toNTMAmount(resource.amount);
            int drainAmount = Math.min(hbmAmount, currentFill);
            if (sender instanceof IFluidProviderMK2) {
                IFluidStandardSenderMK2 provider = sender;
                drainAmount = (int)Math.min((long)drainAmount, provider.getProviderSpeed(hbmFluid, 0));
            }
            if (drainAmount <= 0) continue;
            if (doDrain) {
                tank.setFill(currentFill - drainAmount);
            }
            if ((forgeFluid = FluidMappingRegistry.getForgeFluid(currentType)) == null) continue;
            return new FluidStack(forgeFluid, NTMForgeFluidConverter.toForgeAmount(drainAmount));
        }
        return null;
    }

    public static FluidStack drainToForge(IFluidStandardSenderMK2 sender, int maxDrain, boolean doDrain) {
        if (sender == null || maxDrain <= 0) {
            return null;
        }
        FluidTank[] tanks = sender.getSendingTanks();
        if (tanks.length == 0) {
            return null;
        }
        for (FluidTank tank : tanks) {
            Fluid forgeFluid;
            int currentFill = tank.getFill();
            FluidType currentType = tank.getTankType();
            if (currentFill <= 0 || currentType == Fluids.NONE || (forgeFluid = FluidMappingRegistry.getForgeFluid(currentType)) == null) continue;
            int hbmDrainAmount = NTMForgeFluidConverter.toNTMAmount(maxDrain);
            int drainAmount = Math.min(hbmDrainAmount, currentFill);
            if (sender instanceof IFluidProviderMK2) {
                IFluidStandardSenderMK2 provider = sender;
                drainAmount = (int)Math.min((long)drainAmount, provider.getProviderSpeed(currentType, 0));
            }
            if (drainAmount <= 0) continue;
            if (doDrain) {
                tank.setFill(currentFill - drainAmount);
                if (tank.getFill() <= 0) {
                    tank.setTankType(Fluids.NONE);
                }
            }
            return new FluidStack(forgeFluid, NTMForgeFluidConverter.toForgeAmount(drainAmount));
        }
        return null;
    }

    static {
        ForgeFluidCompatManager.initialize();
        ForgeFluidAdapterRegistry.initialize();
    }
}

