/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.fluid.registry;

import api.ntm1of90.compat.fluid.registry.FluidRegistry;
import api.ntm1of90.compat.fluid.render.ColoredForgeFluid;
import api.ntm1of90.compat.fluid.util.NTMFluidLocalization;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.fluids.Fluid;

public class FluidMappingRegistry {
    private static final Map<String, FluidType> forgeToHbmMap = new HashMap<String, FluidType>();
    private static final Map<FluidType, String> hbmToForgeMap = new HashMap<FluidType, String>();
    private static boolean initialized = false;

    public static void initialize() {
        if (initialized) {
            return;
        }
        System.out.println("[NTM] Starting automatic fluid mapping between NTM and Forge fluid systems...");
        int mappedCount = 0;
        for (FluidType fluidType : Fluids.getAll()) {
            if (fluidType == Fluids.NONE) continue;
            if (fluidType.hasNoContainer() || fluidType.hasNoID()) {
                System.out.println("[NTM] Skipping special fluid: " + fluidType.getName());
                continue;
            }
            String forgeName = fluidType.getName().toLowerCase(Locale.US);
            FluidMappingRegistry.registerFluidMapping(forgeName, fluidType);
            ++mappedCount;
            FluidMappingRegistry.addFluidAliases(fluidType);
        }
        mappedCount = forgeToHbmMap.size();
        for (String forgeName : forgeToHbmMap.keySet()) {
            if (net.minecraftforge.fluids.FluidRegistry.getFluid((String)forgeName) != null) continue;
            FluidType hbmFluid = forgeToHbmMap.get(forgeName);
            ColoredForgeFluid forgeFluid = new ColoredForgeFluid(forgeName, hbmFluid);
            net.minecraftforge.fluids.FluidRegistry.registerFluid((Fluid)forgeFluid);
            System.out.println("[NTM] Registered new Forge fluid: " + forgeName + " with color 0x" + Integer.toHexString(forgeFluid.getColor()));
        }
        System.out.println("[NTM] Fluid mapping complete! Mapped " + mappedCount + " NTM fluids to Forge fluid system.");
        System.out.println("[NTM] Total number of fluid mappings created: " + forgeToHbmMap.size());
        FluidRegistry.initialize();
        NTMFluidLocalization.initialize();
        FluidMappingRegistry.printFluidMappingSummary();
        initialized = true;
    }

    public static void printFluidMappingSummary() {
        System.out.println("\n[NTM] ===== FLUID MAPPING SUMMARY =====");
        System.out.println("[NTM] Total NTM fluids mapped: " + hbmToForgeMap.size());
        System.out.println("[NTM] Total Forge fluid mappings: " + forgeToHbmMap.size());
        HashSet<FluidType> mappedHbmFluids = new HashSet<FluidType>(hbmToForgeMap.keySet());
        System.out.println("[NTM] NTM Fluids with Forge Mappings: " + mappedHbmFluids.size());
        ArrayList<FluidType> sortedHbmFluids = new ArrayList<FluidType>(mappedHbmFluids);
        sortedHbmFluids.sort((f1, f2) -> f1.getName().compareTo(f2.getName()));
        for (FluidType hbmFluid : sortedHbmFluids) {
            ArrayList<String> forgeNames = new ArrayList<String>();
            for (Map.Entry<String, FluidType> entry : forgeToHbmMap.entrySet()) {
                if (entry.getValue() != hbmFluid) continue;
                forgeNames.add(entry.getKey());
            }
            Collections.sort(forgeNames);
            System.out.println("[NTM]   - " + hbmFluid.getName() + " -> " + String.join((CharSequence)", ", forgeNames));
        }
        ArrayList<FluidType> unmappedFluids = new ArrayList<FluidType>();
        for (FluidType fluidType : Fluids.getAll()) {
            if (fluidType == Fluids.NONE || mappedHbmFluids.contains(fluidType)) continue;
            unmappedFluids.add(fluidType);
        }
        if (!unmappedFluids.isEmpty()) {
            System.out.println("\n[NTM] WARNING: The following NTM fluids were not mapped to Forge fluids:");
            for (FluidType fluid : unmappedFluids) {
                System.out.println("[NTM]   - " + fluid.getName());
            }
        }
        System.out.println("[NTM] ================================\n");
    }

    private static void addFluidAliases(FluidType fluidType) {
        String name = fluidType.getName();
        if (fluidType == Fluids.OIL) {
            FluidMappingRegistry.registerFluidMapping("crude_oil", fluidType);
        } else if (fluidType == Fluids.HEAVYOIL) {
            FluidMappingRegistry.registerFluidMapping("heavy_oil", fluidType);
        } else if (fluidType == Fluids.LIGHTOIL) {
            FluidMappingRegistry.registerFluidMapping("light_oil", fluidType);
        } else if (fluidType == Fluids.GAS) {
            FluidMappingRegistry.registerFluidMapping("natural_gas", fluidType);
        } else if (fluidType == Fluids.PETROIL) {
            FluidMappingRegistry.registerFluidMapping("fuel", fluidType);
        } else if (fluidType == Fluids.SULFURIC_ACID) {
            FluidMappingRegistry.registerFluidMapping("sulfuricacid", fluidType);
        } else if (fluidType == Fluids.UF6) {
            FluidMappingRegistry.registerFluidMapping("uranium_hexafluoride", fluidType);
        } else if (fluidType == Fluids.BIOFUEL) {
            FluidMappingRegistry.registerFluidMapping("ethanol", fluidType);
        } else if (fluidType == Fluids.HELIUM3) {
            FluidMappingRegistry.registerFluidMapping("helium", fluidType);
        } else if (fluidType == Fluids.CARBONDIOXIDE) {
            FluidMappingRegistry.registerFluidMapping("carbon_dioxide", fluidType);
        }
        String lowercaseName = name.toLowerCase(Locale.US);
        if (lowercaseName.contains("_")) {
            FluidMappingRegistry.registerFluidMapping(lowercaseName.replace("_", ""), fluidType);
        } else if (!lowercaseName.contains("_") && lowercaseName.length() > 3) {
            for (String forgeName : net.minecraftforge.fluids.FluidRegistry.getRegisteredFluids().keySet()) {
                if (!forgeName.replace("_", "").equals(lowercaseName)) continue;
                FluidMappingRegistry.registerFluidMapping(forgeName, fluidType);
                break;
            }
        }
    }

    public static void registerFluidMapping(String forgeName, FluidType hbmType) {
        FluidType existingType = forgeToHbmMap.get(forgeName);
        if (existingType != null && existingType != hbmType) {
            System.out.println("[NTM] Warning: Overriding existing fluid mapping for '" + forgeName + "' from " + existingType.getName() + " to " + hbmType.getName());
        }
        forgeToHbmMap.put(forgeName, hbmType);
        hbmToForgeMap.put(hbmType, forgeName);
        if (forgeToHbmMap.size() > 1 && existingType == null) {
            System.out.println("[NTM] Mapped Forge fluid '" + forgeName + "' to NTM fluid '" + hbmType.getName() + "'");
        }
    }

    public static FluidType getHbmFluidType(Fluid fluid) {
        String hbmName;
        if (fluid == null) {
            return Fluids.NONE;
        }
        String fluidName = fluid.getName().toLowerCase(Locale.US);
        FluidType type = forgeToHbmMap.get(fluidName);
        if (type != null) {
            return type;
        }
        for (FluidType hbmFluid : Fluids.getAll()) {
            String cleanForge;
            if (hbmFluid == Fluids.NONE) continue;
            hbmName = hbmFluid.getName().toLowerCase(Locale.US);
            if (hbmName.equals(fluidName)) {
                FluidMappingRegistry.registerFluidMapping(fluidName, hbmFluid);
                return hbmFluid;
            }
            String cleanHbm = hbmName.replace("_", "");
            if (!cleanHbm.equals(cleanForge = fluidName.replace("_", ""))) continue;
            FluidMappingRegistry.registerFluidMapping(fluidName, hbmFluid);
            return hbmFluid;
        }
        for (FluidType hbmFluid : Fluids.getAll()) {
            if (hbmFluid == Fluids.NONE) continue;
            hbmName = hbmFluid.getName().toLowerCase(Locale.US);
            if (hbmName.contains(fluidName) || fluidName.contains(hbmName)) {
                FluidMappingRegistry.registerFluidMapping(fluidName, hbmFluid);
                return hbmFluid;
            }
            if (fluidName.startsWith("fluid") && fluidName.substring(5).equals(hbmName)) {
                FluidMappingRegistry.registerFluidMapping(fluidName, hbmFluid);
                return hbmFluid;
            }
            if (!(fluidName.equals("fuel") && hbmName.equals("petroleum") || fluidName.equals("ethanol") && hbmName.equals("biofuel")) && (!fluidName.equals("crude_oil") || !hbmName.equals("oil"))) continue;
            FluidMappingRegistry.registerFluidMapping(fluidName, hbmFluid);
            return hbmFluid;
        }
        System.out.println("[NTM] Unknown Forge fluid: '" + fluid.getName() + "'. No matching NTM fluid found. This fluid will not be usable in NTM machines.");
        return Fluids.NONE;
    }

    public static String getForgeFluidName(FluidType type) {
        if (type == null || type == Fluids.NONE) {
            return null;
        }
        return hbmToForgeMap.get(type);
    }

    public static Fluid getForgeFluid(FluidType type) {
        Fluid crudeOilFluid;
        Fluid fluid;
        if (type == null || type == Fluids.NONE) {
            return null;
        }
        String fluidName = hbmToForgeMap.get(type);
        if (fluidName != null && (fluid = net.minecraftforge.fluids.FluidRegistry.getFluid((String)fluidName)) != null) {
            return fluid;
        }
        String hbmName = type.getName().toLowerCase(Locale.US);
        Fluid fluid2 = net.minecraftforge.fluids.FluidRegistry.getFluid((String)hbmName);
        if (fluid2 != null) {
            FluidMappingRegistry.registerFluidMapping(hbmName, type);
            return fluid2;
        }
        for (String forgeName : net.minecraftforge.fluids.FluidRegistry.getRegisteredFluids().keySet()) {
            String cleanForge;
            String cleanHbm = hbmName.replace("_", "");
            if (!cleanHbm.equals(cleanForge = forgeName.replace("_", ""))) continue;
            FluidMappingRegistry.registerFluidMapping(forgeName, type);
            return net.minecraftforge.fluids.FluidRegistry.getFluid((String)forgeName);
        }
        for (String forgeName : net.minecraftforge.fluids.FluidRegistry.getRegisteredFluids().keySet()) {
            if (forgeName.contains(hbmName) || hbmName.contains(forgeName)) {
                FluidMappingRegistry.registerFluidMapping(forgeName, type);
                return net.minecraftforge.fluids.FluidRegistry.getFluid((String)forgeName);
            }
            if (!forgeName.startsWith("fluid") || !forgeName.substring(5).equals(hbmName)) continue;
            FluidMappingRegistry.registerFluidMapping(forgeName, type);
            return net.minecraftforge.fluids.FluidRegistry.getFluid((String)forgeName);
        }
        if (type == Fluids.PETROIL) {
            Fluid fuelFluid = net.minecraftforge.fluids.FluidRegistry.getFluid((String)"fuel");
            if (fuelFluid != null) {
                FluidMappingRegistry.registerFluidMapping("fuel", type);
                return fuelFluid;
            }
        } else if (type == Fluids.BIOFUEL) {
            Fluid ethanolFluid = net.minecraftforge.fluids.FluidRegistry.getFluid((String)"ethanol");
            if (ethanolFluid != null) {
                FluidMappingRegistry.registerFluidMapping("ethanol", type);
                return ethanolFluid;
            }
        } else if (type == Fluids.OIL && (crudeOilFluid = net.minecraftforge.fluids.FluidRegistry.getFluid((String)"crude_oil")) != null) {
            FluidMappingRegistry.registerFluidMapping("crude_oil", type);
            return crudeOilFluid;
        }
        if (net.minecraftforge.fluids.FluidRegistry.getFluid((String)hbmName) == null) {
            int color = type.getColor();
            ColoredForgeFluid newFluid = new ColoredForgeFluid(hbmName, color);
            net.minecraftforge.fluids.FluidRegistry.registerFluid((Fluid)newFluid);
            FluidMappingRegistry.registerFluidMapping(hbmName, type);
            System.out.println("[NTM] Created new Forge fluid '" + hbmName + "' for NTM fluid '" + type.getName() + "' with color 0x" + Integer.toHexString(color));
            return newFluid;
        }
        FluidMappingRegistry.registerFluidMapping(hbmName, type);
        return null;
    }
}

