/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.fluid.registry;

import api.ntm1of90.compat.fluid.registry.FluidMappingRegistry;
import api.ntm1of90.compat.fluid.render.ColoredForgeFluid;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;

public class FluidRegistry {
    private static final Map<String, IIcon> stillIcons = new HashMap<String, IIcon>();
    private static final Map<String, IIcon> flowingIcons = new HashMap<String, IIcon>();
    private static final Map<String, IIcon> inventoryIcons = new HashMap<String, IIcon>();
    private static final Map<String, FluidProperties> fluidProperties = new HashMap<String, FluidProperties>();
    private static FluidProperties defaultProperties;

    public static void initialize() {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)new FluidRegistry());
            System.out.println("[NTM] Registered fluid registry for texture stitch events");
        }
        FluidRegistry.loadFluidProperties();
        System.out.println("[NTM] Fluid registry initialized with " + fluidProperties.size() + " fluids");
    }

    private static void loadFluidProperties() {
        try {
            InputStream inputStream = FluidRegistry.class.getClassLoader().getResourceAsStream("assets/hbm/forgefluids/fluid_registry.json");
            if (inputStream == null) {
                System.err.println("[NTM] Failed to load fluid registry JSON: File not found");
                defaultProperties = new FluidProperties("default", 0xFFFFFF, "fluid_still", "fluid_flowing", "forgefluid/default");
                return;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            JsonParser parser = new JsonParser();
            JsonObject json = parser.parse((Reader)reader).getAsJsonObject();
            JsonObject defaultJson = json.getAsJsonObject("defaultSettings");
            defaultProperties = new FluidProperties("default", 0xFFFFFF, defaultJson.get("stillTexture").getAsString(), defaultJson.get("flowingTexture").getAsString(), defaultJson.get("inventoryTexture").getAsString());
            JsonArray fluidsJson = json.getAsJsonArray("fluids");
            for (JsonElement fluidElement : fluidsJson) {
                JsonObject fluidJson = fluidElement.getAsJsonObject();
                String name = fluidJson.get("name").getAsString().toLowerCase(Locale.US);
                int color = Integer.decode(fluidJson.get("color").getAsString());
                String stillTexture = fluidJson.get("stillTexture").getAsString();
                String flowingTexture = fluidJson.get("flowingTexture").getAsString();
                String inventoryTexture = fluidJson.get("inventoryTexture").getAsString();
                FluidProperties properties = new FluidProperties(name, color, stillTexture, flowingTexture, inventoryTexture);
                fluidProperties.put(name, properties);
                System.out.println("[NTM] Loaded fluid properties for " + name + ": " + properties);
            }
            reader.close();
        }
        catch (Exception e) {
            System.err.println("[NTM] Error loading fluid registry JSON: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        TextureMap map = event.map;
        for (FluidType hbmFluid : Fluids.getAll()) {
            if (hbmFluid == Fluids.NONE) continue;
            String fluidName = hbmFluid.getName().toLowerCase(Locale.US);
            Fluid forgeFluid = FluidMappingRegistry.getForgeFluid(hbmFluid);
            if (forgeFluid == null) continue;
            if (map.func_130086_a() == 0) {
                this.registerFluidTextures(map, forgeFluid, fluidName);
                continue;
            }
            if (map.func_130086_a() != 1) continue;
            this.registerInventoryIcon(map, forgeFluid, fluidName);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void registerFluidTextures(TextureMap map, Fluid forgeFluid, String fluidName) {
        try {
            FluidProperties properties = FluidRegistry.getFluidProperties(fluidName);
            IIcon stillIcon = map.func_94245_a("hbm:" + properties.stillTexture);
            IIcon flowingIcon = map.func_94245_a("hbm:" + properties.flowingTexture);
            stillIcons.put(fluidName, stillIcon);
            flowingIcons.put(fluidName, flowingIcon);
            forgeFluid.setIcons(stillIcon, flowingIcon);
            if (forgeFluid instanceof ColoredForgeFluid) {
                ((ColoredForgeFluid)forgeFluid).setColor(properties.color);
                ((ColoredForgeFluid)forgeFluid).setHasCustomTexture(true);
            }
            System.out.println("[NTM] Registered textures for Forge fluid: " + fluidName + " (still: " + properties.stillTexture + ", flowing: " + properties.flowingTexture + ")");
        }
        catch (Exception e) {
            System.err.println("[NTM] Error registering textures for fluid " + fluidName + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void registerInventoryIcon(TextureMap map, Fluid forgeFluid, String fluidName) {
        try {
            FluidProperties properties = FluidRegistry.getFluidProperties(fluidName);
            IIcon icon = map.func_94245_a("hbm:" + properties.inventoryTexture);
            inventoryIcons.put(fluidName, icon);
            if (forgeFluid instanceof ColoredForgeFluid) {
                ((ColoredForgeFluid)forgeFluid).setInventoryIcon(icon);
            }
            System.out.println("[NTM] Registered inventory icon for fluid: " + fluidName + " (texture: " + properties.inventoryTexture + ")");
        }
        catch (Exception e) {
            System.err.println("[NTM] Error registering inventory icon for fluid " + fluidName + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static FluidProperties getFluidProperties(String fluidName) {
        FluidProperties properties = fluidProperties.get(fluidName = fluidName.toLowerCase(Locale.US));
        if (properties == null) {
            System.out.println("[NTM] No properties found for fluid " + fluidName + ", using defaults");
            properties = defaultProperties;
        }
        return properties;
    }

    @SideOnly(value=Side.CLIENT)
    public static IIcon getStillIcon(String fluidName) {
        return stillIcons.get(fluidName.toLowerCase(Locale.US));
    }

    @SideOnly(value=Side.CLIENT)
    public static IIcon getFlowingIcon(String fluidName) {
        return flowingIcons.get(fluidName.toLowerCase(Locale.US));
    }

    @SideOnly(value=Side.CLIENT)
    public static IIcon getInventoryIcon(String fluidName) {
        return inventoryIcons.get(fluidName.toLowerCase(Locale.US));
    }

    public static class FluidProperties {
        public final String name;
        public final int color;
        public final String stillTexture;
        public final String flowingTexture;
        public final String inventoryTexture;

        public FluidProperties(String name, int color, String stillTexture, String flowingTexture, String inventoryTexture) {
            this.name = name;
            this.color = color;
            this.stillTexture = stillTexture;
            this.flowingTexture = flowingTexture;
            this.inventoryTexture = inventoryTexture;
        }

        public String toString() {
            return "FluidProperties{name='" + this.name + '\'' + ", color=0x" + Integer.toHexString(this.color) + ", stillTexture='" + this.stillTexture + '\'' + ", flowingTexture='" + this.flowingTexture + '\'' + ", inventoryTexture='" + this.inventoryTexture + '\'' + '}';
        }
    }
}

