/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.fluid.render;

import api.ntm1of90.compat.fluid.registry.FluidRegistry;
import api.ntm1of90.compat.fluid.render.NTMFluidTextureMapper;
import api.ntm1of90.compat.fluid.util.NTMFluidLocalization;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.trait.FluidTraitSimple;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class ColoredForgeFluid
extends Fluid {
    private int color;
    private FluidType hbmFluidType;
    private boolean hasCustomTexture = false;
    private static Map<String, IIcon> inventoryIcons = new HashMap<String, IIcon>();

    public ColoredForgeFluid(String fluidName, FluidType hbmFluid) {
        super(fluidName);
        this.hbmFluidType = hbmFluid;
        this.color = hbmFluid.getColor();
        this.setDensity(hbmFluid.hasTrait(FluidTraitSimple.FT_Gaseous.class) ? -1000 : 1000);
        this.setViscosity(hbmFluid.hasTrait(FluidTraitSimple.FT_Viscous.class) ? 3000 : 1000);
        this.setTemperature(hbmFluid.temperature);
        this.setLuminosity(0);
    }

    public ColoredForgeFluid(String fluidName, int color) {
        super(fluidName);
        this.color = color;
    }

    public int getColor() {
        return this.color;
    }

    public FluidType getHbmFluidType() {
        return this.hbmFluidType;
    }

    public void setHasCustomTexture(boolean hasCustomTexture) {
        this.hasCustomTexture = hasCustomTexture;
    }

    public boolean hasCustomTexture() {
        return this.hasCustomTexture;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getStillIcon() {
        IIcon icon = NTMFluidTextureMapper.getStillIcon(this.getName());
        return icon != null ? icon : super.getStillIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getFlowingIcon() {
        IIcon icon = NTMFluidTextureMapper.getFlowingIcon(this.getName());
        return icon != null ? icon : super.getFlowingIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getInventoryIcon() {
        IIcon icon = inventoryIcons.get(this.getName());
        if (icon != null) {
            return icon;
        }
        icon = FluidRegistry.getInventoryIcon(this.getName());
        if (icon != null) {
            return icon;
        }
        return this.getStillIcon();
    }

    @SideOnly(value=Side.CLIENT)
    public void setInventoryIcon(IIcon icon) {
        if (icon != null) {
            inventoryIcons.put(this.getName(), icon);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void applyColorForInventory() {
        float r = (float)(this.color >> 16 & 0xFF) / 255.0f;
        float g = (float)(this.color >> 8 & 0xFF) / 255.0f;
        float b = (float)(this.color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public static void resetColor() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public String getLocalizedName() {
        return NTMFluidLocalization.getForgeFluidDisplayName(this);
    }

    public int getColor(FluidStack stack) {
        return this.color;
    }

    public int getColorARGB() {
        return 0xFF000000 | this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int pass) {
        return this.color;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderUsingForgeFluidTexture(int x, int y, int width, int height) {
        this.applyColorForInventory();
        IIcon icon = this.getInventoryIcon();
        if (icon != null) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)x, (double)(y + height), 0.0, (double)icon.func_94209_e(), (double)icon.func_94210_h());
            tessellator.func_78374_a((double)(x + width), (double)(y + height), 0.0, (double)icon.func_94212_f(), (double)icon.func_94210_h());
            tessellator.func_78374_a((double)(x + width), (double)y, 0.0, (double)icon.func_94212_f(), (double)icon.func_94206_g());
            tessellator.func_78374_a((double)x, (double)y, 0.0, (double)icon.func_94209_e(), (double)icon.func_94206_g());
            tessellator.func_78381_a();
        } else {
            IIcon stillIcon = this.getStillIcon();
            if (stillIcon != null) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                Tessellator tessellator = Tessellator.field_78398_a;
                tessellator.func_78382_b();
                tessellator.func_78374_a((double)x, (double)(y + height), 0.0, (double)stillIcon.func_94209_e(), (double)stillIcon.func_94210_h());
                tessellator.func_78374_a((double)(x + width), (double)(y + height), 0.0, (double)stillIcon.func_94212_f(), (double)stillIcon.func_94210_h());
                tessellator.func_78374_a((double)(x + width), (double)y, 0.0, (double)stillIcon.func_94212_f(), (double)stillIcon.func_94206_g());
                tessellator.func_78374_a((double)x, (double)y, 0.0, (double)stillIcon.func_94209_e(), (double)stillIcon.func_94206_g());
                tessellator.func_78381_a();
            } else {
                Tessellator tessellator = Tessellator.field_78398_a;
                tessellator.func_78382_b();
                tessellator.func_78377_a((double)x, (double)(y + height), 0.0);
                tessellator.func_78377_a((double)(x + width), (double)(y + height), 0.0);
                tessellator.func_78377_a((double)(x + width), (double)y, 0.0);
                tessellator.func_78377_a((double)x, (double)y, 0.0);
                tessellator.func_78381_a();
            }
        }
        ColoredForgeFluid.resetColor();
    }
}

