/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.fluid.render;

import api.ntm1of90.compat.fluid.registry.FluidMappingRegistry;
import api.ntm1of90.compat.fluid.render.ColoredForgeFluid;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class NTMFluidCompatRenderer {
    public static void initialize() {
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            MinecraftForge.EVENT_BUS.register((Object)new NTMFluidCompatRenderer());
            System.out.println("[NTM] Fluid compat renderer registered for client-side events");
        }
        System.out.println("[NTM] Fluid compat renderer initialized");
    }

    public static void renderFluid(Fluid fluid, int x, int y, int width, int height) {
        if (fluid == null) {
            return;
        }
        IIcon icon = NTMFluidCompatRenderer.getFluidIcon(fluid);
        int color = NTMFluidCompatRenderer.getFluidColor(fluid);
        NTMFluidCompatRenderer.renderFluidWithIconAndColor(icon, color, x, y, width, height);
    }

    public static void renderFluidStack(FluidStack fluidStack, int x, int y, int width, int height) {
        if (fluidStack == null || fluidStack.getFluid() == null) {
            return;
        }
        NTMFluidCompatRenderer.renderFluid(fluidStack.getFluid(), x, y, width, height);
    }

    public static IIcon getFluidIcon(Fluid fluid) {
        IIcon icon;
        if (fluid == null) {
            return null;
        }
        if (fluid instanceof ColoredForgeFluid && (icon = ((ColoredForgeFluid)fluid).getInventoryIcon()) != null) {
            return icon;
        }
        IIcon stillIcon = fluid.getStillIcon();
        if (stillIcon != null) {
            return stillIcon;
        }
        return fluid.getFlowingIcon();
    }

    public static int getFluidColor(Fluid fluid) {
        if (fluid == null) {
            return 0xFFFFFF;
        }
        if (fluid instanceof ColoredForgeFluid) {
            return ((ColoredForgeFluid)fluid).getColor();
        }
        FluidStack fluidStack = new FluidStack(fluid, 1000);
        return fluid.getColor(fluidStack);
    }

    public static void renderFluidWithIconAndColor(IIcon icon, int color, int x, int y, int width, int height) {
        if (icon == null) {
            return;
        }
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + height), 0.0, (double)icon.func_94209_e(), (double)icon.func_94210_h());
        tessellator.func_78374_a((double)(x + width), (double)(y + height), 0.0, (double)icon.func_94212_f(), (double)icon.func_94210_h());
        tessellator.func_78374_a((double)(x + width), (double)y, 0.0, (double)icon.func_94212_f(), (double)icon.func_94206_g());
        tessellator.func_78374_a((double)x, (double)y, 0.0, (double)icon.func_94209_e(), (double)icon.func_94206_g());
        tessellator.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static FluidType getNTMFluidType(Fluid fluid) {
        FluidType ntmFluid;
        if (fluid == null) {
            return Fluids.NONE;
        }
        if (fluid instanceof ColoredForgeFluid && (ntmFluid = ((ColoredForgeFluid)fluid).getHbmFluidType()) != null) {
            return ntmFluid;
        }
        return FluidMappingRegistry.getHbmFluidType(fluid);
    }

    public static ResourceLocation getFluidTexture(Fluid fluid) {
        if (fluid == null) {
            return null;
        }
        FluidType ntmFluid = NTMFluidCompatRenderer.getNTMFluidType(fluid);
        if (ntmFluid != null && ntmFluid != Fluids.NONE) {
            return ntmFluid.getTexture();
        }
        return new ResourceLocation("hbm", "textures/gui/forgefluids/water.png");
    }
}

