/*
 * Decompiled with CFR 0.152.
 */
package api.ntm1of90.compat.fluid.util;

import api.ntm1of90.compat.fluid.registry.FluidMappingRegistry;
import api.ntm1of90.compat.fluid.render.ColoredForgeFluid;
import com.hbm.inventory.fluid.FluidType;
import com.hbm.inventory.fluid.Fluids;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class NTMFluidLocalization {
    private static Map<String, String> fluidNameCache = new HashMap<String, String>();

    public static void initialize() {
        System.out.println("[NTM] Initializing fluid localization...");
        NTMFluidLocalization.initializeWithNames(false);
    }

    private static void loadFluidNamesFromLang() {
        String displayName;
        fluidNameCache.clear();
        int count = 0;
        for (FluidType ntmFluid : Fluids.getAll()) {
            String displayName2;
            if (ntmFluid == Fluids.NONE) continue;
            String ntmName = ntmFluid.getName().toLowerCase(Locale.US);
            String langKey = "hbmfluid." + ntmName;
            if (!StatCollector.func_94522_b((String)langKey) || (displayName2 = StatCollector.func_74838_a((String)langKey)).equals(langKey)) continue;
            fluidNameCache.put(ntmName, displayName2);
            System.out.println("[NTM] Loaded NTM fluid name from lang: " + ntmName + " -> " + displayName2);
            ++count;
        }
        for (String fluidName : FluidRegistry.getRegisteredFluids().keySet()) {
            String langKey = "fluid." + fluidName;
            if (!StatCollector.func_94522_b((String)langKey) || (displayName = StatCollector.func_74838_a((String)langKey)).equals(langKey)) continue;
            fluidNameCache.put(fluidName, displayName);
            System.out.println("[NTM] Loaded Forge fluid name from lang: " + fluidName + " -> " + displayName);
            ++count;
        }
        for (String fluidName : FluidRegistry.getRegisteredFluids().keySet()) {
            String langKey;
            if (fluidNameCache.containsKey(fluidName) || !StatCollector.func_94522_b((String)(langKey = "hbmfluid." + fluidName)) || (displayName = StatCollector.func_74838_a((String)langKey)).equals(langKey)) continue;
            fluidNameCache.put(fluidName, displayName);
            System.out.println("[NTM] Loaded Forge fluid name from NTM lang: " + fluidName + " -> " + displayName);
            ++count;
        }
        System.out.println("[NTM] Loaded " + count + " fluid names from language files");
    }

    private static void registerFluidNames() {
        int count = 0;
        for (FluidType ntmFluid : Fluids.getAll()) {
            Fluid forgeFluid;
            if (ntmFluid == Fluids.NONE || (forgeFluid = FluidMappingRegistry.getForgeFluid(ntmFluid)) == null) continue;
            String displayName = NTMFluidLocalization.getDisplayName(ntmFluid);
            String unlocalizedName = "fluid." + forgeFluid.getName();
            LanguageRegistry.instance().addStringLocalization(unlocalizedName, displayName);
            String bucketName = "item.bucket." + forgeFluid.getName();
            String bucketDisplayName = displayName + " Bucket";
            LanguageRegistry.instance().addStringLocalization(bucketName, bucketDisplayName);
            if (FluidRegistry.isFluidRegistered((Fluid)forgeFluid)) {
                NTMFluidLocalization.registerBucketForFluid(forgeFluid);
            }
            System.out.println("[NTM] Registered localized name for fluid: " + forgeFluid.getName() + " -> " + displayName);
            ++count;
        }
        for (Fluid forgeFluid : FluidRegistry.getRegisteredFluids().values()) {
            if (FluidMappingRegistry.getHbmFluidType(forgeFluid) != Fluids.NONE) continue;
            String displayName = NTMFluidLocalization.getForgeFluidDisplayName(forgeFluid);
            String unlocalizedName = "fluid." + forgeFluid.getName();
            LanguageRegistry.instance().addStringLocalization(unlocalizedName, displayName);
            String bucketName = "item.bucket." + forgeFluid.getName();
            String bucketDisplayName = displayName + " Bucket";
            LanguageRegistry.instance().addStringLocalization(bucketName, bucketDisplayName);
            System.out.println("[NTM] Registered localized name for non-NTM fluid: " + forgeFluid.getName() + " -> " + displayName);
            ++count;
        }
        System.out.println("[NTM] Registered localized names for " + count + " fluids");
    }

    private static String getDisplayName(FluidType fluid) {
        String[] parts;
        String displayName;
        String name = fluid.getName();
        String lowercaseName = name.toLowerCase(Locale.US);
        if (fluidNameCache.containsKey(lowercaseName)) {
            return fluidNameCache.get(lowercaseName);
        }
        String langKey = "hbmfluid." + lowercaseName;
        if (StatCollector.func_94522_b((String)langKey) && !(displayName = StatCollector.func_74838_a((String)langKey)).equals(langKey)) {
            fluidNameCache.put(lowercaseName, displayName);
            return displayName;
        }
        StringBuilder result = new StringBuilder();
        for (String part : parts = name.split("_")) {
            if (part.length() <= 0) continue;
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(Character.toUpperCase(part.charAt(0)));
            if (part.length() <= 1) continue;
            result.append(part.substring(1).toLowerCase(Locale.US));
        }
        return result.toString();
    }

    private static void registerBucketForFluid(Fluid fluid) {
        System.out.println("[NTM] Skipping bucket registration for fluid: " + fluid.getName() + " (handled by Forge)");
    }

    public static String getForgeFluidDisplayName(Fluid fluid) {
        String displayName;
        String displayName2;
        ColoredForgeFluid coloredFluid;
        FluidType ntmFluid;
        if (fluid == null) {
            return "Unknown Fluid";
        }
        String fluidName = fluid.getName().toLowerCase(Locale.US);
        if (fluidNameCache.containsKey(fluidName)) {
            return fluidNameCache.get(fluidName);
        }
        if (fluid instanceof ColoredForgeFluid && (ntmFluid = (coloredFluid = (ColoredForgeFluid)fluid).getHbmFluidType()) != null) {
            return NTMFluidLocalization.getDisplayName(ntmFluid);
        }
        String unlocalizedName = "fluid." + fluidName;
        if (StatCollector.func_94522_b((String)unlocalizedName) && !(displayName2 = StatCollector.func_74838_a((String)unlocalizedName)).equals(unlocalizedName)) {
            fluidNameCache.put(fluidName, displayName2);
            return displayName2;
        }
        String ntmLangKey = "hbmfluid." + fluidName;
        if (StatCollector.func_94522_b((String)ntmLangKey) && !(displayName = StatCollector.func_74838_a((String)ntmLangKey)).equals(ntmLangKey)) {
            fluidNameCache.put(fluidName, displayName);
            return displayName;
        }
        return NTMFluidLocalization.formatFluidName(fluidName);
    }

    private static String formatFluidName(String name) {
        String[] parts;
        StringBuilder result = new StringBuilder();
        for (String part : parts = name.split("_")) {
            if (part.length() <= 0) continue;
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(Character.toUpperCase(part.charAt(0)));
            if (part.length() <= 1) continue;
            result.append(part.substring(1).toLowerCase(Locale.US));
        }
        return result.toString();
    }

    private static void reloadFluidNames() {
        System.out.println("[NTM] Reloading fluid localization...");
        fluidNameCache.clear();
        NTMFluidLocalization.loadFluidNamesFromLang();
        NTMFluidLocalization.registerFluidNames();
        System.out.println("[NTM] Fluid localization reloaded");
    }

    public static void initializeWithNames(boolean forceReload) {
        if (forceReload || fluidNameCache.isEmpty()) {
            System.out.println("[NTM] Initializing fluid localization with names from language files...");
            NTMFluidLocalization.loadFluidNamesFromLang();
            NTMFluidLocalization.registerFluidNames();
        }
    }
}

