/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.bomb;

import com.hbm.blocks.IBlockMulti;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.blocks.ModBlocks;
import com.hbm.entity.projectile.EntityShrapnel;
import com.hbm.explosion.ExplosionNT;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockVolcano
extends BlockContainer
implements ITooltipProvider,
IBlockMulti {
    public static final int META_STATIC_ACTIVE = 0;
    public static final int META_STATIC_EXTINGUISHING = 1;
    public static final int META_GROWING_ACTIVE = 2;
    public static final int META_GROWING_EXTINGUISHING = 3;
    public static final int META_SMOLDERING = 4;

    public BlockVolcano() {
        super(Material.field_151573_f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityVolcanoCore();
    }

    @Override
    public int getSubCount() {
        return 5;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 5; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        int meta = stack.func_77960_j();
        if (meta == 4) {
            list.add(EnumChatFormatting.GOLD + "SHIELD VOLCANO");
            return;
        }
        list.add(BlockVolcano.isGrowing(meta) ? EnumChatFormatting.RED + "DOES GROW" : EnumChatFormatting.DARK_GRAY + "DOES NOT GROW");
        list.add(BlockVolcano.isExtinguishing(meta) ? EnumChatFormatting.RED + "DOES EXTINGUISH" : EnumChatFormatting.DARK_GRAY + "DOES NOT EXTINGUISH");
    }

    public static boolean isGrowing(int meta) {
        return meta == 2 || meta == 3;
    }

    public static boolean isExtinguishing(int meta) {
        return meta == 1 || meta == 3;
    }

    public static class TileEntityVolcanoCore
    extends TileEntity {
        private static List<ExplosionNT.ExAttrib> volcanoExplosion = Arrays.asList(ExplosionNT.ExAttrib.NODROP, ExplosionNT.ExAttrib.LAVA_V, ExplosionNT.ExAttrib.NOSOUND, ExplosionNT.ExAttrib.ALLMOD, ExplosionNT.ExAttrib.NOHURT);
        private static List<ExplosionNT.ExAttrib> volcanoRadExplosion = Arrays.asList(ExplosionNT.ExAttrib.NODROP, ExplosionNT.ExAttrib.LAVA_R, ExplosionNT.ExAttrib.NOSOUND, ExplosionNT.ExAttrib.ALLMOD, ExplosionNT.ExAttrib.NOHURT);
        public int volcanoTimer;

        public void func_145845_h() {
            if (!this.field_145850_b.field_72995_K) {
                ++this.volcanoTimer;
                if (this.volcanoTimer % 10 == 0) {
                    Object[] melting;
                    double magmaChamber;
                    if (this.hasVerticalChannel()) {
                        this.blastMagmaChannel();
                        this.raiseMagma();
                    }
                    if ((magmaChamber = this.magmaChamberSize()) > 0.0) {
                        this.blastMagmaChamber(magmaChamber);
                    }
                    if ((melting = this.surfaceMeltingParams()) != null) {
                        this.meltSurface((Integer)melting[0], (Double)melting[1], (Double)melting[2]);
                    }
                    if (this.isSpewing()) {
                        this.spawnBlobs();
                    }
                    if (this.isSmoking()) {
                        this.spawnSmoke();
                    }
                    this.surroundLava();
                }
                if (this.volcanoTimer >= this.getUpdateRate()) {
                    this.volcanoTimer = 0;
                    if (this.shouldGrow()) {
                        this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, this.func_145838_q(), this.func_145832_p(), 3);
                        this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getLava());
                        return;
                    }
                    if (this.isExtinguishing()) {
                        this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getLava());
                        return;
                    }
                }
            }
        }

        public boolean isRadioacitve() {
            return this.func_145838_q() == ModBlocks.volcano_rad_core;
        }

        protected Block getLava() {
            if (this.isRadioacitve()) {
                return ModBlocks.rad_lava_block;
            }
            return ModBlocks.volcanic_lava_block;
        }

        protected List<ExplosionNT.ExAttrib> getExpAttrb() {
            return this.isRadioacitve() ? volcanoRadExplosion : volcanoExplosion;
        }

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.volcanoTimer = nbt.func_74762_e("timer");
        }

        public void func_145841_b(NBTTagCompound nbt) {
            super.func_145841_b(nbt);
            nbt.func_74768_a("tier", this.volcanoTimer);
        }

        private boolean shouldGrow() {
            return this.isGrowing() && this.field_145848_d < 200;
        }

        private boolean isGrowing() {
            int meta = this.func_145832_p();
            return meta == 2 || meta == 3;
        }

        private boolean isExtinguishing() {
            int meta = this.func_145832_p();
            return meta == 1 || meta == 3;
        }

        private boolean isSmoking() {
            return this.func_145832_p() != 4;
        }

        private boolean isSpewing() {
            return this.func_145832_p() != 4;
        }

        private boolean hasVerticalChannel() {
            return this.func_145832_p() != 4;
        }

        private double magmaChamberSize() {
            return this.func_145832_p() == 4 ? 15.0 : 0.0;
        }

        private Object[] surfaceMeltingParams() {
            Object[] objectArray;
            if (this.func_145832_p() == 4) {
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = 50;
                objectArray2[1] = 50.0;
                objectArray = objectArray2;
                objectArray2[2] = 10.0;
            } else {
                objectArray = null;
            }
            return objectArray;
        }

        private int getUpdateRate() {
            switch (this.func_145832_p()) {
                case 1: {
                    return 72000;
                }
                case 2: 
                case 3: {
                    return 288;
                }
            }
            return 10;
        }

        private void blastMagmaChannel() {
            ExplosionNT explosion = new ExplosionNT(this.field_145850_b, null, (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + this.field_145850_b.field_73012_v.nextInt(15)) + 1.5, (double)this.field_145849_e + 0.5, 7.0f);
            explosion.addAllAttrib(this.getExpAttrb()).explode();
            ExplosionNT explosion2 = new ExplosionNT(this.field_145850_b, null, (double)this.field_145851_c + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * 3.0, this.field_145850_b.field_73012_v.nextInt(this.field_145848_d + 1), (double)this.field_145849_e + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * 3.0, 10.0f);
            explosion2.addAllAttrib(this.getExpAttrb()).explode();
        }

        private void blastMagmaChamber(double size) {
            for (int i = 0; i < 2; ++i) {
                double dist = size / (double)(i + 1);
                ExplosionNT explosion = new ExplosionNT(this.field_145850_b, null, (double)this.field_145851_c + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * dist, (double)this.field_145848_d + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * dist, (double)this.field_145849_e + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * dist, 7.0f);
                explosion.addAllAttrib(this.getExpAttrb()).explode();
            }
        }

        private void meltSurface(int count, double radius, double depth) {
            for (int i = 0; i < count; ++i) {
                int z;
                int y;
                int x = (int)Math.floor((double)this.field_145851_c + this.field_145850_b.field_73012_v.nextGaussian() * radius);
                Block b = this.field_145850_b.func_147439_a(x, y = this.field_145850_b.func_72976_f(x, z = (int)Math.floor((double)this.field_145849_e + this.field_145850_b.field_73012_v.nextGaussian() * radius)) + 1 - (int)Math.floor(Math.abs(this.field_145850_b.field_73012_v.nextGaussian() * depth)), z);
                if (b.isAir((IBlockAccess)this.field_145850_b, x, y, z) || !(b.func_149638_a(null) < Blocks.field_150343_Z.func_149638_a(null))) continue;
                this.field_145850_b.func_147449_b(x, y, z, b.func_149721_r() ? this.getLava() : Blocks.field_150350_a);
            }
        }

        private void raiseMagma() {
            int rZ;
            int rY;
            int rX = this.field_145851_c - 10 + this.field_145850_b.field_73012_v.nextInt(21);
            if (this.field_145850_b.func_147439_a(rX, rY = this.field_145848_d + this.field_145850_b.field_73012_v.nextInt(11), rZ = this.field_145849_e - 10 + this.field_145850_b.field_73012_v.nextInt(21)) == Blocks.field_150350_a && this.field_145850_b.func_147439_a(rX, rY - 1, rZ) == this.getLava()) {
                this.field_145850_b.func_147449_b(rX, rY, rZ, this.getLava());
            }
        }

        private void surroundLava() {
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        if (i == 0 && j == 0 && k == 0) continue;
                        this.field_145850_b.func_147449_b(this.field_145851_c + i, this.field_145848_d + j, this.field_145849_e + k, this.getLava());
                    }
                }
            }
        }

        private void spawnBlobs() {
            for (int i = 0; i < 3; ++i) {
                EntityShrapnel frag = new EntityShrapnel(this.field_145850_b);
                frag.func_70012_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, 0.0f, 0.0f);
                frag.field_70181_x = 1.0 + this.field_145850_b.field_73012_v.nextDouble();
                frag.field_70159_w = this.field_145850_b.field_73012_v.nextGaussian() * 0.2;
                frag.field_70179_y = this.field_145850_b.field_73012_v.nextGaussian() * 0.2;
                if (this.isRadioacitve()) {
                    frag.setRadVolcano(true);
                } else {
                    frag.setVolcano(true);
                }
                this.field_145850_b.func_72838_d((Entity)frag);
            }
        }

        private void spawnSmoke() {
            NBTTagCompound dPart = new NBTTagCompound();
            dPart.func_74778_a("type", "vanillaExt");
            dPart.func_74778_a("mode", "volcano");
            PacketThreading.createAllAroundThreadedPacket(new AuxParticlePacketNT(dPart, (double)this.field_145851_c + 0.5, this.field_145848_d + 10, (double)this.field_145849_e + 0.5), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c + 0.5, (double)(this.field_145848_d + 10), (double)this.field_145849_e + 0.5, 250.0));
        }
    }
}

