/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.fluid;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.fluid.GenericFiniteFluid;
import com.hbm.lib.ModDamageSource;
import com.hbm.util.ContaminationUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class CoriumFinite
extends GenericFiniteFluid {
    public CoriumFinite(Fluid fluid, Material material) {
        super(fluid, material, "corium_still", "corium_flowing");
        this.setQuantaPerBlock(5);
        this.tickRate = 30;
    }

    public boolean canDisplace(IBlockAccess world, int x, int y, int z) {
        Block b = world.func_147439_a(x, y, z);
        float res = (float)(Math.sqrt(b.func_149638_a(null)) * 3.0);
        if (res < 1.0f) {
            return true;
        }
        Random rand = new Random();
        return b.func_149688_o().func_76224_d() || rand.nextInt((int)res) == 0;
    }

    public boolean displaceIfPossible(World world, int x, int y, int z) {
        if (world.func_147439_a(x, y, z).func_149688_o().func_76224_d()) {
            return false;
        }
        return this.canDisplace((IBlockAccess)world, x, y, z);
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        entity.func_70110_aj();
        entity.func_70015_d(3);
        entity.func_70097_a(ModDamageSource.radiation, 2.0f);
        if (entity instanceof EntityLivingBase) {
            ContaminationUtil.contaminate((EntityLivingBase)entity, ContaminationUtil.HazardType.RADIATION, ContaminationUtil.ContaminationType.CREATIVE, 1.0f);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        super.func_149674_a(world, x, y, z, rand);
        if (!world.field_72995_K && rand.nextInt(10) == 0 && world.func_147439_a(x, y - 1, z) != this) {
            if (rand.nextInt(3) == 0) {
                world.func_147449_b(x, y, z, ModBlocks.block_corium);
            } else {
                world.func_147449_b(x, y, z, ModBlocks.block_corium_cobble);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return 0;
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        return false;
    }
}

