/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.generic;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.generic.BlockSkeletonHolder;
import com.hbm.entity.mob.EntityUndeadSoldier;
import com.hbm.items.ItemEnums;
import com.hbm.items.ModItems;
import com.hbm.util.EnumUtil;
import com.hbm.util.Vec3NT;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class DungeonSpawner
extends BlockContainer {
    public static Function<TileEntityDungeonSpawner, Boolean> CON_TEST = tile -> {
        World world = tile.func_145831_w();
        int x = tile.field_145851_c;
        int y = tile.field_145848_d;
        int z = tile.field_145849_e;
        if (tile.phase == 0 && world.func_82737_E() % 20L != 0L) {
            return false;
        }
        if (tile.phase < 3 && (world.func_82737_E() % 20L != 0L || tile.timer < 60)) {
            return false;
        }
        return false;
    };
    public static Consumer<TileEntityDungeonSpawner> PHASE_TEST = tile -> {
        World world = tile.func_145831_w();
        int x = tile.field_145851_c;
        int y = tile.field_145848_d;
        int z = tile.field_145849_e;
        if ((tile.phase == 1 || tile.phase == 2) && tile.timer == 0) {
            Vec3NT vec = new Vec3NT(10.0, 0.0, 0.0);
            for (int i = 0; i < 10; ++i) {
                EntityUndeadSoldier mob = new EntityUndeadSoldier(world);
                mob.func_70080_a((double)x + 0.5 + vec.field_72450_a, y, (double)z + 0.5 + vec.field_72449_c, (float)i * 36.0f, 0.0f);
                vec.rotateAroundYDeg(36.0);
                mob.func_110161_a(null);
                world.func_72838_d((Entity)mob);
            }
        }
        if (tile.phase > 2) {
            world.func_147465_d(x, y + 1, z, ModBlocks.skeleton_holder, 2 + world.field_73012_v.nextInt(4), 3);
            TileEntity te = world.func_147438_o(x, y + 1, z);
            if (te instanceof BlockSkeletonHolder.TileEntitySkeletonHolder) {
                BlockSkeletonHolder.TileEntitySkeletonHolder skeleton = (BlockSkeletonHolder.TileEntitySkeletonHolder)te;
                skeleton.item = new ItemStack(ModItems.item_secret, 1, ItemEnums.EnumSecretType.ABERRATOR.ordinal());
                skeleton.func_70296_d();
                world.func_147471_g(x, y, z);
            }
            world.func_147449_b(x, y, z, Blocks.field_150343_Z);
        }
    };

    public DungeonSpawner() {
        super(Material.field_151576_e);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityDungeonSpawner();
    }

    public static enum EnumSpawnerType {
        NONE(CON_TEST, PHASE_TEST);

        public Function<TileEntityDungeonSpawner, Boolean> phaseCondition;
        public Consumer<TileEntityDungeonSpawner> phase;

        private EnumSpawnerType(Function<TileEntityDungeonSpawner, Boolean> con, Consumer<TileEntityDungeonSpawner> ph) {
            this.phaseCondition = con;
            this.phase = ph;
        }
    }

    public static class TileEntityDungeonSpawner
    extends TileEntity {
        public int phase = 0;
        public int timer = 0;
        public EnumSpawnerType type = EnumSpawnerType.NONE;

        public void func_145845_h() {
            if (!this.field_145850_b.field_72995_K) {
                this.type.phase.accept(this);
                if (this.type.phaseCondition.apply(this).booleanValue()) {
                    ++this.phase;
                    this.timer = 0;
                } else {
                    ++this.timer;
                }
            }
        }

        public void func_145841_b(NBTTagCompound nbt) {
            super.func_145841_b(nbt);
            nbt.func_74768_a("phase", this.phase);
            nbt.func_74774_a("type", (byte)this.type.ordinal());
        }

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.phase = nbt.func_74762_e("phase");
            this.type = (EnumSpawnerType)((Object)EnumUtil.grabEnumSafely(EnumSpawnerType.class, nbt.func_74771_c("type")));
        }
    }
}

