/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import api.hbm.block.IToolable;
import api.hbm.energymk2.IEnergyReceiverMK2;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.FloodlightBeam;
import com.hbm.util.Compat;
import com.hbm.util.fauxpointtwelve.BlockPos;
import com.hbm.world.gen.INBTTransformable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class Floodlight
extends BlockContainer
implements IToolable,
INBTTransformable {
    public Floodlight(Material mat) {
        super(mat);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityFloodlight();
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float fX, float fY, float fZ, int meta) {
        return side;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        this.setAngle(world, x, y, z, player, true);
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, int side, float fX, float fY, float fZ, IToolable.ToolType tool) {
        if (tool != IToolable.ToolType.SCREWDRIVER) {
            return false;
        }
        this.setAngle(world, x, y, z, (EntityLivingBase)player, false);
        return true;
    }

    public void setAngle(World world, int x, int y, int z, EntityLivingBase player, boolean updateMeta) {
        int i = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        float rotation = player.field_70125_A;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TileEntityFloodlight) {
            int meta = world.func_72805_g(x, y, z) % 6;
            TileEntityFloodlight floodlight = (TileEntityFloodlight)tile;
            if (meta == 0 || meta == 1) {
                if ((i == 0 || i == 2) && updateMeta) {
                    world.func_72921_c(x, y, z, meta + 6, 3);
                }
                if (meta == 1 && (i == 0 || i == 1)) {
                    rotation = 180.0f - rotation;
                }
                if (meta == 0 && (i == 0 || i == 3)) {
                    rotation = 180.0f - rotation;
                }
            }
            floodlight.rotation = (float)(-Math.round(rotation / 5.0f)) * 5.0f;
            if (floodlight.isOn) {
                floodlight.destroyLights();
            }
            tile.func_70296_d();
        }
    }

    @Override
    public int transformMeta(int meta, int coordBaseMode) {
        if (meta < 6) {
            switch (coordBaseMode) {
                case 1: {
                    switch (meta) {
                        case 2: {
                            return 5;
                        }
                        case 3: {
                            return 4;
                        }
                        case 4: {
                            return 2;
                        }
                        case 5: {
                            return 3;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (meta) {
                        case 2: {
                            return 3;
                        }
                        case 3: {
                            return 2;
                        }
                        case 4: {
                            return 5;
                        }
                        case 5: {
                            return 4;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (meta) {
                        case 2: {
                            return 4;
                        }
                        case 3: {
                            return 5;
                        }
                        case 4: {
                            return 3;
                        }
                        case 5: {
                            return 2;
                        }
                    }
                }
            }
        }
        if (meta >= 6) {
            return this.transformMeta(meta - 6, coordBaseMode) + 6;
        }
        return meta;
    }

    @Override
    public Block transformBlock(Block block) {
        return block;
    }

    public static class TileEntityFloodlight
    extends TileEntity
    implements IEnergyReceiverMK2 {
        public float rotation;
        protected BlockPos[] lightPos = new BlockPos[15];
        public static final long maxPower = 5000L;
        public long power;
        public int delay;
        public boolean isOn;
        private boolean isLoaded = true;
        AxisAlignedBB bb = null;

        public void func_145845_h() {
            if (!this.field_145850_b.field_72995_K) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() % 6)).getOpposite();
                this.trySubscribe(this.field_145850_b, this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ, dir);
                if (this.delay > 0) {
                    --this.delay;
                    return;
                }
                if (this.power >= 100L) {
                    this.power -= 100L;
                    if (!this.isOn) {
                        this.isOn = true;
                        this.castLights();
                        this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
                        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                    } else {
                        long timer = this.field_145850_b.func_82737_E();
                        if (timer % 5L == 0L) {
                            this.castLight((int)Math.abs((timer /= 5L) % (long)this.lightPos.length));
                        }
                    }
                } else if (this.isOn) {
                    this.isOn = false;
                    this.delay = 60;
                    this.destroyLights();
                    this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
                    this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
        }

        private void castLight(int index) {
            TileEntity tile;
            BlockPos newPos = this.getRayEndpoint(index);
            BlockPos oldPos = this.lightPos[index];
            this.lightPos[index] = null;
            if ((newPos == null || !newPos.equals(oldPos)) && oldPos != null && (tile = Compat.getTileStandard(this.field_145850_b, oldPos.getX(), oldPos.getY(), oldPos.getZ())) instanceof FloodlightBeam.TileEntityFloodlightBeam) {
                FloodlightBeam.TileEntityFloodlightBeam beam = (FloodlightBeam.TileEntityFloodlightBeam)tile;
                if (beam.cache == this) {
                    this.field_145850_b.func_147465_d(oldPos.getX(), oldPos.getY(), oldPos.getZ(), Blocks.field_150350_a, 0, 2);
                }
            }
            if (newPos == null) {
                return;
            }
            if (this.field_145850_b.func_147439_a(newPos.getX(), newPos.getY(), newPos.getZ()) == Blocks.field_150350_a) {
                this.field_145850_b.func_147465_d(newPos.getX(), newPos.getY(), newPos.getZ(), ModBlocks.floodlight_beam, 0, 2);
                tile = Compat.getTileStandard(this.field_145850_b, newPos.getX(), newPos.getY(), newPos.getZ());
                if (tile instanceof FloodlightBeam.TileEntityFloodlightBeam) {
                    ((FloodlightBeam.TileEntityFloodlightBeam)tile).setSource(this, newPos.getX(), newPos.getY(), newPos.getZ(), index);
                }
                this.lightPos[index] = newPos;
            }
            if (this.field_145850_b.func_147439_a(newPos.getX(), newPos.getY(), newPos.getZ()) == ModBlocks.floodlight_beam) {
                this.lightPos[index] = newPos;
            }
        }

        public BlockPos getRayEndpoint(int index) {
            if (index < 0 || index >= this.lightPos.length) {
                return null;
            }
            int meta = this.func_145832_p();
            Vec3 dir = Vec3.func_72443_a((double)1.0, (double)0.0, (double)0.0);
            float[] angles = this.getVariation(index);
            float rotation = this.rotation;
            if (meta == 1 || meta == 7) {
                rotation = 180.0f - rotation;
            }
            if (meta == 6) {
                rotation = 180.0f - rotation;
            }
            dir.func_72446_c((float)((double)rotation / 180.0 * Math.PI) + angles[0]);
            if (meta == 6) {
                dir.func_72442_b(1.5707964f);
            }
            if (meta == 7) {
                dir.func_72442_b(1.5707964f);
            }
            if (meta == 2) {
                dir.func_72442_b(1.5707964f);
            }
            if (meta == 3) {
                dir.func_72442_b(-1.5707964f);
            }
            if (meta == 4) {
                dir.func_72442_b((float)Math.PI);
            }
            dir.func_72442_b(angles[1]);
            for (int i = 1; i < 64; ++i) {
                Block block;
                int iX = (int)Math.floor((double)this.field_145851_c + 0.5 + dir.field_72450_a * (double)i);
                int iY = (int)Math.floor((double)this.field_145848_d + 0.5 + dir.field_72448_b * (double)i);
                int iZ = (int)Math.floor((double)this.field_145849_e + 0.5 + dir.field_72449_c * (double)i);
                if (iX == this.field_145851_c && iY == this.field_145848_d && iZ == this.field_145849_e || (block = this.field_145850_b.func_147439_a(iX, iY, iZ)).getLightOpacity((IBlockAccess)this.field_145850_b, iX, iY, iZ) < 127) continue;
                int fX = (int)Math.floor((double)this.field_145851_c + 0.5 + dir.field_72450_a * (double)(i - 1));
                int fY = (int)Math.floor((double)this.field_145848_d + 0.5 + dir.field_72448_b * (double)(i - 1));
                int fZ = (int)Math.floor((double)this.field_145849_e + 0.5 + dir.field_72449_c * (double)(i - 1));
                if (i <= 1) continue;
                return new BlockPos(fX, fY, fZ);
            }
            return null;
        }

        private void castLights() {
            for (int i = 0; i < this.lightPos.length; ++i) {
                this.castLight(i);
            }
        }

        private void destroyLight(int index) {
            BlockPos pos = this.lightPos[index];
            if (pos != null && pos != null && this.field_145850_b.func_147439_a(pos.getX(), pos.getY(), pos.getZ()) == ModBlocks.floodlight_beam) {
                this.field_145850_b.func_147465_d(pos.getX(), pos.getY(), pos.getZ(), Blocks.field_150350_a, 0, 2);
            }
        }

        private void destroyLights() {
            for (int i = 0; i < this.lightPos.length; ++i) {
                this.destroyLight(i);
            }
        }

        private float[] getVariation(int index) {
            return new float[]{(float)(index / 3 - 2) * 7.5f / 180.0f * (float)Math.PI, (float)(index % 3 - 1) * 15.0f / 180.0f * (float)Math.PI};
        }

        public Packet func_145844_m() {
            NBTTagCompound nbt = new NBTTagCompound();
            this.func_145841_b(nbt);
            return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
        }

        public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
            this.func_145839_a(pkt.func_148857_g());
        }

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.rotation = nbt.func_74760_g("rotation");
            this.power = nbt.func_74763_f("power");
            this.isOn = nbt.func_74767_n("isOn");
        }

        public void func_145841_b(NBTTagCompound nbt) {
            super.func_145841_b(nbt);
            nbt.func_74776_a("rotation", this.rotation);
            nbt.func_74772_a("power", this.power);
            nbt.func_74757_a("isOn", this.isOn);
        }

        @Override
        public long getPower() {
            return this.power;
        }

        @Override
        public void setPower(long power) {
            this.power = power;
        }

        @Override
        public long getMaxPower() {
            return 5000L;
        }

        @Override
        public boolean isLoaded() {
            return this.isLoaded;
        }

        public void onChunkUnload() {
            this.isLoaded = false;
        }

        public AxisAlignedBB getRenderBoundingBox() {
            if (this.bb == null) {
                this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)(this.field_145848_d - 1), (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 2));
            }
            return this.bb;
        }

        @SideOnly(value=Side.CLIENT)
        public double func_145833_n() {
            return 65536.0;
        }
    }
}

