/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.IPersistentInfoProvider;
import com.hbm.blocks.ModBlocks;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.IPersistentNBT;
import com.hbm.tileentity.machine.storage.TileEntityMachineBattery;
import com.hbm.util.BobMathUtil;
import com.hbm.util.I18nUtil;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class MachineBattery
extends BlockContainer
implements ILookOverlay,
IPersistentInfoProvider {
    private final Random field_149933_a = new Random();
    private static boolean keepInventory;
    public long maxPower;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFront;

    public MachineBattery(Material p_i45386_1_, long maxPower) {
        super(p_i45386_1_);
        this.maxPower = maxPower;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        if (this == ModBlocks.machine_battery) {
            this.iconFront = iconRegister.func_94245_a("hbm:battery_front_alt");
            this.iconTop = iconRegister.func_94245_a("hbm:battery_top");
            this.field_149761_L = iconRegister.func_94245_a("hbm:battery_side_alt");
        }
        if (this == ModBlocks.machine_battery_potato) {
            this.iconFront = iconRegister.func_94245_a("hbm:battery_potato_front");
            this.iconTop = iconRegister.func_94245_a("hbm:battery_potato_top");
            this.field_149761_L = iconRegister.func_94245_a("hbm:battery_potato_side");
        }
        if (this == ModBlocks.machine_lithium_battery) {
            this.iconFront = iconRegister.func_94245_a("hbm:battery_lithium_front");
            this.iconTop = iconRegister.func_94245_a("hbm:battery_lithium_top");
            this.field_149761_L = iconRegister.func_94245_a("hbm:battery_lithium_side");
        }
        if (this == ModBlocks.machine_schrabidium_battery) {
            this.iconFront = iconRegister.func_94245_a("hbm:battery_schrabidium_front");
            this.iconTop = iconRegister.func_94245_a("hbm:battery_schrabidium_top");
            this.field_149761_L = iconRegister.func_94245_a("hbm:battery_schrabidium_side");
        }
        if (this == ModBlocks.machine_dineutronium_battery) {
            this.iconFront = iconRegister.func_94245_a("hbm:battery_dineutronium_front");
            this.iconTop = iconRegister.func_94245_a("hbm:battery_dineutronium_top");
            this.field_149761_L = iconRegister.func_94245_a("hbm:battery_dineutronium_side");
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        if (side == 0 || side == 1) {
            return this.iconTop;
        }
        return metadata == 0 && side == 3 ? this.iconFront : (side == metadata ? this.iconFront : this.field_149761_L);
    }

    public Item func_149650_a(int p_149650_1_, Random p_149650_2_, int p_149650_3_) {
        return Item.func_150898_a((Block)this);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        super.func_149726_b(world, x, y, z);
        this.setDefaultDirection(world, x, y, z);
    }

    private void setDefaultDirection(World world, int x, int y, int z) {
        if (!world.field_72995_K) {
            Block block1 = world.func_147439_a(x, y, z - 1);
            Block block2 = world.func_147439_a(x, y, z + 1);
            Block block3 = world.func_147439_a(x - 1, y, z);
            Block block4 = world.func_147439_a(x + 1, y, z);
            int b0 = 3;
            if (block1.func_149730_j() && !block2.func_149730_j()) {
                b0 = 3;
            }
            if (block2.func_149730_j() && !block1.func_149730_j()) {
                b0 = 2;
            }
            if (block3.func_149730_j() && !block4.func_149730_j()) {
                b0 = 5;
            }
            if (block4.func_149730_j() && !block3.func_149730_j()) {
                b0 = 4;
            }
            world.func_72921_c(x, y, z, b0, 2);
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        int i = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (i == 0) {
            world.func_72921_c(x, y, z, 2, 2);
        }
        if (i == 1) {
            world.func_72921_c(x, y, z, 5, 2);
        }
        if (i == 2) {
            world.func_72921_c(x, y, z, 3, 2);
        }
        if (i == 3) {
            world.func_72921_c(x, y, z, 4, 2);
        }
        if (itemStack.func_82837_s()) {
            ((TileEntityMachineBattery)world.func_147438_o(x, y, z)).setCustomName(itemStack.func_82833_r());
        }
        IPersistentNBT.restoreData(world, x, y, z, itemStack);
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityMachineBattery();
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            TileEntityMachineBattery entity = (TileEntityMachineBattery)world.func_147438_o(x, y, z);
            if (entity != null) {
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MainRegistry.instance, (int)0, (World)world, (int)x, (int)y, (int)z);
            }
            return true;
        }
        return false;
    }

    public void func_149749_a(World p_149749_1_, int p_149749_2_, int p_149749_3_, int p_149749_4_, Block p_149749_5_, int p_149749_6_) {
        TileEntity tile;
        if (!keepInventory && (tile = p_149749_1_.func_147438_o(p_149749_2_, p_149749_3_, p_149749_4_)) instanceof TileEntityMachineBattery) {
            TileEntityMachineBattery battery = (TileEntityMachineBattery)tile;
            for (int i1 = 0; i1 < battery.func_70302_i_(); ++i1) {
                ItemStack itemstack = battery.func_70301_a(i1);
                if (itemstack == null) continue;
                float f = this.field_149933_a.nextFloat() * 0.8f + 0.1f;
                float f1 = this.field_149933_a.nextFloat() * 0.8f + 0.1f;
                float f2 = this.field_149933_a.nextFloat() * 0.8f + 0.1f;
                while (itemstack.field_77994_a > 0) {
                    int j1 = this.field_149933_a.nextInt(21) + 10;
                    if (j1 > itemstack.field_77994_a) {
                        j1 = itemstack.field_77994_a;
                    }
                    itemstack.field_77994_a -= j1;
                    EntityItem entityitem = new EntityItem(p_149749_1_, (double)((float)p_149749_2_ + f), (double)((float)p_149749_3_ + f1), (double)((float)p_149749_4_ + f2), new ItemStack(itemstack.func_77973_b(), j1, itemstack.func_77960_j()));
                    if (itemstack.func_77942_o()) {
                        entityitem.func_92059_d().func_77982_d((NBTTagCompound)itemstack.func_77978_p().func_74737_b());
                    }
                    float f3 = 0.05f;
                    entityitem.field_70159_w = (float)this.field_149933_a.nextGaussian() * f3;
                    entityitem.field_70181_x = (float)this.field_149933_a.nextGaussian() * f3 + 0.2f;
                    entityitem.field_70179_y = (float)this.field_149933_a.nextGaussian() * f3;
                    p_149749_1_.func_72838_d((Entity)entityitem);
                }
            }
            p_149749_1_.func_147453_f(p_149749_2_, p_149749_3_, p_149749_4_, p_149749_5_);
        }
        super.func_149749_a(p_149749_1_, p_149749_2_, p_149749_3_, p_149749_4_, p_149749_5_, p_149749_6_);
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityMachineBattery)) {
            return;
        }
        TileEntityMachineBattery battery = (TileEntityMachineBattery)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add(BobMathUtil.getShortNumber(battery.getPower()) + " / " + BobMathUtil.getShortNumber(battery.getMaxPower()) + "HE");
        double percent = (double)battery.getPower() / (double)battery.getMaxPower();
        int charge = (int)Math.floor(percent * 10000.0);
        int color = (int)(255.0 - 255.0 * percent) << 16 | (int)(255.0 * percent) << 8;
        text.add("&[" + color + "&]" + (double)charge / 100.0 + "%");
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityMachineBattery)) {
            return 0;
        }
        TileEntityMachineBattery battery = (TileEntityMachineBattery)te;
        return battery.getComparatorPower();
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        return IPersistentNBT.getDrops(world, x, y, z, (Block)this);
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.harvesters.set(player);
            this.func_149697_b(world, x, y, z, meta, 0);
            this.harvesters.set(null);
        }
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        player.func_71064_a(StatList.field_75934_C[MachineBattery.func_149682_b((Block)this)], 1);
        player.func_71020_j(0.025f);
    }

    @Override
    public void addInformation(ItemStack stack, NBTTagCompound persistentTag, EntityPlayer player, List list, boolean ext) {
        list.add(EnumChatFormatting.GOLD + "Stores up to " + BobMathUtil.getShortNumber(this.maxPower) + "HE");
        list.add(EnumChatFormatting.GOLD + "Charge speed: " + BobMathUtil.getShortNumber(this.maxPower / 200L) + "HE");
        list.add(EnumChatFormatting.GOLD + "Discharge speed: " + BobMathUtil.getShortNumber(this.maxPower / 600L) + "HE");
        list.add(EnumChatFormatting.YELLOW + "" + BobMathUtil.getShortNumber(persistentTag.func_74763_f("power")) + "/" + BobMathUtil.getShortNumber(this.maxPower) + "HE");
    }
}

