/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.IPersistentInfoProvider;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.machine.storage.TileEntityMachineBattery;
import com.hbm.tileentity.machine.storage.TileEntityMachineFENSU;
import com.hbm.util.BobMathUtil;
import com.hbm.util.I18nUtil;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class MachineFENSU
extends BlockDummyable
implements ILookOverlay,
IPersistentInfoProvider {
    public MachineFENSU(Material mat) {
        super(mat);
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta >= 12) {
            return new TileEntityMachineFENSU();
        }
        return null;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{4, 0, 1, 1, 2, 2};
    }

    @Override
    public int getOffset() {
        return 1;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            int[] pos = this.findCore(world, x, y, z);
            if (pos == null) {
                return false;
            }
            TileEntityMachineFENSU entity = (TileEntityMachineFENSU)world.func_147438_o(pos[0], pos[1], pos[2]);
            if (entity != null) {
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MainRegistry.instance, (int)0, (World)world, (int)pos[0], (int)pos[1], (int)pos[2]);
            }
            return true;
        }
        return false;
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityMachineBattery)) {
            return;
        }
        TileEntityMachineBattery battery = (TileEntityMachineBattery)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add(BobMathUtil.getShortNumber(battery.getPower()) + " / " + BobMathUtil.getShortNumber(battery.getMaxPower()) + "HE");
        double percent = (double)battery.getPower() / (double)battery.getMaxPower();
        int charge = (int)Math.floor(percent * 10000.0);
        int color = (int)(255.0 - 255.0 * percent) << 16 | (int)(255.0 * percent) << 8;
        text.add("&[" + color + "&]" + (double)charge / 100.0 + "%");
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    @Override
    public void addInformation(ItemStack stack, NBTTagCompound persistentTag, EntityPlayer player, List list, boolean ext) {
        list.add(EnumChatFormatting.YELLOW + "" + BobMathUtil.getShortNumber(persistentTag.func_74763_f("power")) + "/" + BobMathUtil.getShortNumber(Long.MAX_VALUE) + "HE");
    }
}

