/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.BlockICF;
import com.hbm.blocks.machine.BlockICFLaserComponent;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.tileentity.machine.TileEntityICFController;
import com.hbm.util.BobMathUtil;
import com.hbm.util.I18nUtil;
import com.hbm.util.fauxpointtwelve.BlockPos;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineICFController
extends BlockContainer
implements ILookOverlay {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFront;
    private static HashMap<BlockPos, Integer> assembly = new HashMap();
    private static HashSet<BlockPos> casings = new HashSet();
    private static HashSet<BlockPos> ports = new HashSet();
    private static HashSet<BlockPos> cells = new HashSet();
    private static HashSet<BlockPos> emitters = new HashSet();
    private static HashSet<BlockPos> capacitors = new HashSet();
    private static HashSet<BlockPos> turbochargers = new HashSet();
    private static boolean errored;
    private static final int maxSize = 1024;

    public MachineICFController() {
        super(Material.field_151573_f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityICFController();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.iconFront = iconRegister.func_94245_a("hbm:icf_controller");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return metadata == 0 && side == 3 ? this.iconFront : (side == metadata ? this.iconFront : this.field_149761_L);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        int i = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (i == 0) {
            world.func_72921_c(x, y, z, 2, 2);
        }
        if (i == 1) {
            world.func_72921_c(x, y, z, 5, 2);
        }
        if (i == 2) {
            world.func_72921_c(x, y, z, 3, 2);
        }
        if (i == 3) {
            world.func_72921_c(x, y, z, 4, 2);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            TileEntityICFController controller = (TileEntityICFController)world.func_147438_o(x, y, z);
            if (!controller.assembled) {
                this.assemble(world, x, y, z, player);
            }
            return true;
        }
        return false;
    }

    public void assemble(World world, int x, int y, int z, EntityPlayer player) {
        assembly.clear();
        casings.clear();
        ports.clear();
        cells.clear();
        emitters.clear();
        capacitors.clear();
        turbochargers.clear();
        assembly.put(new BlockPos(x, y, z), 0);
        ForgeDirection dir = ForgeDirection.getOrientation((int)world.func_72805_g(x, y, z)).getOpposite();
        errored = false;
        this.floodFill(world, x + dir.offsetX, y, z + dir.offsetZ, player);
        assembly.remove(new BlockPos(x, y, z));
        TileEntityICFController controller = (TileEntityICFController)world.func_147438_o(x, y, z);
        if (!errored) {
            for (Map.Entry<BlockPos, Integer> entry : assembly.entrySet()) {
                BlockPos pos = entry.getKey();
                if (ports.contains(pos)) {
                    world.func_147465_d(pos.getX(), pos.getY(), pos.getZ(), ModBlocks.icf_block, 1, 3);
                } else {
                    world.func_147465_d(pos.getX(), pos.getY(), pos.getZ(), ModBlocks.icf_block, 0, 3);
                }
                BlockICF.TileEntityBlockICF icf = (BlockICF.TileEntityBlockICF)world.func_147438_o(pos.getX(), pos.getY(), pos.getZ());
                icf.block = ModBlocks.icf_laser_component;
                icf.meta = entry.getValue();
                icf.coreX = x;
                icf.coreY = y;
                icf.coreZ = z;
                icf.func_70296_d();
            }
            controller.setup(ports, cells, emitters, capacitors, turbochargers);
            controller.func_70296_d();
        }
        controller.assembled = !errored;
        assembly.clear();
        casings.clear();
        ports.clear();
        cells.clear();
        emitters.clear();
        capacitors.clear();
        turbochargers.clear();
    }

    private void floodFill(World world, int x, int y, int z, EntityPlayer player) {
        BlockPos pos = new BlockPos(x, y, z);
        if (assembly.containsKey(pos)) {
            return;
        }
        if (assembly.size() >= 1024) {
            errored = true;
            this.sendError(world, x, y, z, "Max size exceeded", player);
            return;
        }
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        boolean validCasing = false;
        boolean validCore = false;
        if (block == ModBlocks.icf_laser_component) {
            if (meta == BlockICFLaserComponent.EnumICFPart.CASING.ordinal()) {
                casings.add(pos);
                validCasing = true;
            }
            if (meta == BlockICFLaserComponent.EnumICFPart.PORT.ordinal()) {
                ports.add(pos);
                validCasing = true;
            }
            if (meta == BlockICFLaserComponent.EnumICFPart.CELL.ordinal()) {
                cells.add(pos);
                validCore = true;
            }
            if (meta == BlockICFLaserComponent.EnumICFPart.EMITTER.ordinal()) {
                emitters.add(pos);
                validCore = true;
            }
            if (meta == BlockICFLaserComponent.EnumICFPart.CAPACITOR.ordinal()) {
                capacitors.add(pos);
                validCore = true;
            }
            if (meta == BlockICFLaserComponent.EnumICFPart.TURBO.ordinal()) {
                turbochargers.add(pos);
                validCore = true;
            }
        }
        if (validCasing) {
            assembly.put(pos, meta);
            return;
        }
        if (validCore) {
            assembly.put(pos, meta);
            this.floodFill(world, x + 1, y, z, player);
            this.floodFill(world, x - 1, y, z, player);
            this.floodFill(world, x, y + 1, z, player);
            this.floodFill(world, x, y - 1, z, player);
            this.floodFill(world, x, y, z + 1, player);
            this.floodFill(world, x, y, z - 1, player);
            return;
        }
        this.sendError(world, x, y, z, "Non-laser block", player);
        errored = true;
    }

    private void sendError(World world, int x, int y, int z, String message, EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "marker");
            data.func_74768_a("color", 0xFF0000);
            data.func_74768_a("expires", 5000);
            data.func_74780_a("dist", 128.0);
            if (message != null) {
                data.func_74778_a("label", message);
            }
            PacketThreading.createSendToThreadedPacket(new AuxParticlePacketNT(data, x, y, z), (EntityPlayerMP)player);
        }
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileEntityICFController)) {
            return;
        }
        TileEntityICFController icf = (TileEntityICFController)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add(BobMathUtil.getShortNumber(icf.getPower()) + "/" + BobMathUtil.getShortNumber(icf.getMaxPower()) + "HE");
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }
}

