/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.ITooltipProvider;
import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.BlockPWR;
import com.hbm.handler.threading.PacketThreading;
import com.hbm.main.MainRegistry;
import com.hbm.packet.toclient.AuxParticlePacketNT;
import com.hbm.tileentity.machine.TileEntityPWRController;
import com.hbm.util.fauxpointtwelve.BlockPos;
import cpw.mods.fml.common.network.internal.FMLNetworkHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MachinePWRController
extends BlockContainer
implements ITooltipProvider {
    @SideOnly(value=Side.CLIENT)
    private IIcon iconFront;
    private static HashMap<BlockPos, Block> assembly = new HashMap();
    private static HashMap<BlockPos, Block> fuelRods = new HashMap();
    private static HashMap<BlockPos, Block> sources = new HashMap();
    private static boolean errored;
    private static final int maxSize = 4096;

    public MachinePWRController(Material mat) {
        super(mat);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityPWRController();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        super.func_149651_a(iconRegister);
        this.iconFront = iconRegister.func_94245_a("hbm:pwr_controller");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int metadata) {
        return metadata == 0 && side == 3 ? this.iconFront : (side == metadata ? this.iconFront : this.field_149761_L);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        int i = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (i == 0) {
            world.func_72921_c(x, y, z, 2, 2);
        }
        if (i == 1) {
            world.func_72921_c(x, y, z, 5, 2);
        }
        if (i == 2) {
            world.func_72921_c(x, y, z, 3, 2);
        }
        if (i == 3) {
            world.func_72921_c(x, y, z, 4, 2);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            TileEntityPWRController controller = (TileEntityPWRController)world.func_147438_o(x, y, z);
            if (!controller.assembled) {
                this.assemble(world, x, y, z, player);
            } else {
                FMLNetworkHandler.openGui((EntityPlayer)player, (Object)MainRegistry.instance, (int)0, (World)world, (int)x, (int)y, (int)z);
            }
            return true;
        }
        return false;
    }

    public void assemble(World world, int x, int y, int z, EntityPlayer player) {
        assembly.clear();
        fuelRods.clear();
        sources.clear();
        assembly.put(new BlockPos(x, y, z), (Block)this);
        ForgeDirection dir = ForgeDirection.getOrientation((int)world.func_72805_g(x, y, z)).getOpposite();
        errored = false;
        this.floodFill(world, x + dir.offsetX, y, z + dir.offsetZ, player);
        if (fuelRods.size() == 0) {
            this.sendError(world, x, y, z, "Fuel rods required", player);
            errored = true;
        }
        if (sources.size() == 0) {
            this.sendError(world, x, y, z, "Neutron sources required", player);
            errored = true;
        }
        TileEntityPWRController controller = (TileEntityPWRController)world.func_147438_o(x, y, z);
        if (!errored) {
            for (Map.Entry<BlockPos, Block> entry : assembly.entrySet()) {
                BlockPos pos = entry.getKey();
                Block block = entry.getValue();
                if (block == ModBlocks.pwr_controller) continue;
                if (block == ModBlocks.pwr_port) {
                    world.func_147465_d(pos.getX(), pos.getY(), pos.getZ(), ModBlocks.pwr_block, 1, 3);
                } else {
                    world.func_147465_d(pos.getX(), pos.getY(), pos.getZ(), ModBlocks.pwr_block, 0, 3);
                }
                BlockPWR.TileEntityBlockPWR pwr = (BlockPWR.TileEntityBlockPWR)world.func_147438_o(pos.getX(), pos.getY(), pos.getZ());
                pwr.block = block;
                pwr.coreX = x;
                pwr.coreY = y;
                pwr.coreZ = z;
                pwr.func_70296_d();
            }
            controller.setup(assembly, fuelRods);
        }
        controller.assembled = !errored;
        assembly.clear();
        fuelRods.clear();
        sources.clear();
    }

    private void floodFill(World world, int x, int y, int z, EntityPlayer player) {
        BlockPos pos = new BlockPos(x, y, z);
        if (assembly.containsKey(pos)) {
            return;
        }
        if (assembly.size() >= 4096) {
            errored = true;
            this.sendError(world, x, y, z, "Max size exceeded", player);
            return;
        }
        Block block = world.func_147439_a(x, y, z);
        if (this.isValidCasing(block)) {
            assembly.put(pos, block);
            return;
        }
        if (this.isValidCore(block)) {
            assembly.put(pos, block);
            if (block == ModBlocks.pwr_fuel) {
                fuelRods.put(pos, block);
            }
            if (block == ModBlocks.pwr_neutron_source) {
                sources.put(pos, block);
            }
            this.floodFill(world, x + 1, y, z, player);
            this.floodFill(world, x - 1, y, z, player);
            this.floodFill(world, x, y + 1, z, player);
            this.floodFill(world, x, y - 1, z, player);
            this.floodFill(world, x, y, z + 1, player);
            this.floodFill(world, x, y, z - 1, player);
            return;
        }
        this.sendError(world, x, y, z, "Non-reactor block", player);
        errored = true;
    }

    private void sendError(World world, int x, int y, int z, String message, EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("type", "marker");
            data.func_74768_a("color", 0xFF0000);
            data.func_74768_a("expires", 5000);
            data.func_74780_a("dist", 128.0);
            if (message != null) {
                data.func_74778_a("label", message);
            }
            PacketThreading.createSendToThreadedPacket(new AuxParticlePacketNT(data, x, y, z), (EntityPlayerMP)player);
        }
    }

    private boolean isValidCore(Block block) {
        return block == ModBlocks.pwr_fuel || block == ModBlocks.pwr_control || block == ModBlocks.pwr_channel || block == ModBlocks.pwr_heatex || block == ModBlocks.pwr_heatsink || block == ModBlocks.pwr_neutron_source;
    }

    private boolean isValidCasing(Block block) {
        return block == ModBlocks.pwr_casing || block == ModBlocks.pwr_reflector || block == ModBlocks.pwr_port;
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        this.addStandardInfo(stack, player, list, ext);
    }
}

