/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.IBlockMulti;
import com.hbm.blocks.ILookOverlay;
import com.hbm.blocks.ITooltipProvider;
import com.hbm.blocks.ModBlocks;
import com.hbm.items.ModItems;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.machine.TileEntityStirling;
import com.hbm.util.BobMathUtil;
import com.hbm.util.I18nUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineStirling
extends BlockDummyable
implements ILookOverlay,
ITooltipProvider,
IBlockMulti {
    public MachineStirling() {
        super(Material.field_151573_f);
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta >= 12) {
            return new TileEntityStirling();
        }
        if (meta >= 6) {
            return new TileEntityProxyCombo().power();
        }
        return null;
    }

    @Override
    public int[] getDimensions() {
        return new int[]{1, 0, 1, 1, 1, 1};
    }

    @Override
    public int getOffset() {
        return 1;
    }

    @Override
    public void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        super.fillSpace(world, x, y, z, dir, o);
        this.makeExtra(world, (x += dir.offsetX * o) + 1, y, z += dir.offsetZ * o);
        this.makeExtra(world, x - 1, y, z);
        this.makeExtra(world, x, y, z + 1);
        this.makeExtra(world, x, y, z - 1);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_70093_af()) {
            int[] pos = this.findCore(world, x, y, z);
            if (pos == null) {
                return false;
            }
            TileEntityStirling stirling = (TileEntityStirling)world.func_147438_o(pos[0], pos[1], pos[2]);
            int meta = stirling.getGeatMeta();
            if (!stirling.hasCog && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ModItems.gear_large && player.func_70694_bm().func_77960_j() == meta) {
                --player.func_70694_bm().field_77994_a;
                stirling.hasCog = true;
                stirling.func_70296_d();
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "hbm:item.upgradePlug", 1.5f, 0.75f);
                return true;
            }
        }
        return false;
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack itemStack) {
        super.func_149689_a(world, x, y, z, player, itemStack);
        if (itemStack.func_77960_j() == 1) {
            int i = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            int o = -this.getOffset();
            ForgeDirection dir = ForgeDirection.NORTH;
            if (i == 0) {
                dir = ForgeDirection.getOrientation((int)2);
            }
            if (i == 1) {
                dir = ForgeDirection.getOrientation((int)5);
            }
            if (i == 2) {
                dir = ForgeDirection.getOrientation((int)3);
            }
            if (i == 3) {
                dir = ForgeDirection.getOrientation((int)4);
            }
            dir = this.getDirModified(dir);
            TileEntity te = world.func_147438_o(x + dir.offsetX * o, y + dir.offsetY * o, z + dir.offsetZ * o);
            if (te instanceof TileEntityStirling) {
                ((TileEntityStirling)te).hasCog = false;
            }
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        int dmg = 0;
        int[] pos = this.findCore(world, x, y, z);
        if (pos != null) {
            TileEntityStirling stirling = (TileEntityStirling)world.func_147438_o(pos[0], pos[1], pos[2]);
            if (!stirling.hasCog) {
                dmg = 1;
            }
        }
        for (int i = 0; i < count; ++i) {
            Item item = this.func_149650_a(metadata, world.field_73012_v, fortune);
            if (item == null) continue;
            ret.add(new ItemStack(item, 1, dmg));
        }
        return ret;
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return;
        }
        TileEntity te = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(te instanceof TileEntityStirling)) {
            return;
        }
        TileEntityStirling stirling = (TileEntityStirling)te;
        ArrayList<String> text = new ArrayList<String>();
        text.add(stirling.heat + "TU/t");
        text.add((stirling.hasCog ? stirling.powerBuffer : 0L) + "HE/t");
        if (this != ModBlocks.machine_stirling_creative) {
            int maxHeat = stirling.maxHeat();
            double percent = (double)stirling.heat / (double)maxHeat;
            int color = (int)(255.0 - 255.0 * percent) << 16 | (int)(255.0 * percent) << 8;
            if (percent > 1.0) {
                color = 0xFF0000;
            }
            text.add("&[" + color + "&]" + (double)(stirling.heat * 1000 / maxHeat) / 10.0 + "%");
            if (stirling.heat > maxHeat) {
                text.add("&[" + (BobMathUtil.getBlink() ? 0xFF0000 : 0xFFFF00) + "&]! ! ! OVERSPEED ! ! !");
            }
            if (!stirling.hasCog) {
                text.add("&[16711680&]Gear missing!");
            }
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFFFF00, 0x404000, text);
    }

    @Override
    public void addInformation(ItemStack stack, EntityPlayer player, List list, boolean ext) {
        this.addStandardInfo(stack, player, list, ext);
    }

    @Override
    public int getSubCount() {
        return 0;
    }
}

