/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.blocks.machine;

import api.hbm.block.ICrucibleAcceptor;
import api.hbm.block.IToolable;
import com.hbm.blocks.BlockDummyable;
import com.hbm.blocks.ILookOverlay;
import com.hbm.handler.MultiblockHandlerXR;
import com.hbm.inventory.material.Mats;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemScraps;
import com.hbm.tileentity.TileEntityProxyCombo;
import com.hbm.tileentity.machine.TileEntityMachineStrandCaster;
import com.hbm.util.I18nUtil;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;

public class MachineStrandCaster
extends BlockDummyable
implements ICrucibleAcceptor,
ILookOverlay,
IToolable {
    public MachineStrandCaster() {
        super(Material.field_151573_f);
    }

    @Override
    public int[] getDimensions() {
        return new int[]{0, 0, 6, 0, 1, 0};
    }

    @Override
    public int getOffset() {
        return 0;
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (meta >= 12) {
            return new TileEntityMachineStrandCaster();
        }
        if (meta >= 6) {
            return new TileEntityProxyCombo(true, false, true).moltenMetal();
        }
        return null;
    }

    @Override
    public void fillSpace(World world, int x, int y, int z, ForgeDirection dir, int o) {
        super.fillSpace(world, x, y, z, dir, o);
        ForgeDirection rot = dir.getRotation(ForgeDirection.UP);
        MultiblockHandlerXR.fillSpace(world, x += dir.offsetX * o, y, z += dir.offsetZ * o, new int[]{2, 0, 1, 0, 1, 0}, (Block)this, dir);
        this.makeExtra(world, x + rot.offsetX - dir.offsetX, y, z + rot.offsetZ - dir.offsetZ);
        this.makeExtra(world, x - dir.offsetX, y, z - dir.offsetZ);
        this.makeExtra(world, x - dir.offsetX * 5, y, z - dir.offsetZ * 5);
        this.makeExtra(world, x + rot.offsetX - dir.offsetX * 5, y, z + rot.offsetZ - dir.offsetZ * 5);
        this.makeExtra(world, x + rot.offsetX - dir.offsetX, y + 2, z + rot.offsetZ - dir.offsetZ);
        this.makeExtra(world, x - dir.offsetX, y + 2, z - dir.offsetZ);
        this.makeExtra(world, x + rot.offsetX, y + 2, z + rot.offsetZ);
        this.makeExtra(world, x, y + 2, z);
    }

    @Override
    public boolean canAcceptPartialPour(World world, int x, int y, int z, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        TileEntity poured = world.func_147438_o(x, y, z);
        if (!(poured instanceof TileEntityProxyCombo) || !((TileEntityProxyCombo)poured).moltenMetal) {
            return false;
        }
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return false;
        }
        TileEntity tile = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(tile instanceof TileEntityMachineStrandCaster)) {
            return false;
        }
        TileEntityMachineStrandCaster caster = (TileEntityMachineStrandCaster)tile;
        return caster.canAcceptPartialPour(world, x, y, z, dX, dY, dZ, side, stack);
    }

    @Override
    public Mats.MaterialStack pour(World world, int x, int y, int z, double dX, double dY, double dZ, ForgeDirection side, Mats.MaterialStack stack) {
        TileEntity poured = world.func_147438_o(x, y, z);
        if (!(poured instanceof TileEntityProxyCombo) || !((TileEntityProxyCombo)poured).moltenMetal) {
            return stack;
        }
        int[] pos = this.findCore(world, x, y, z);
        if (pos == null) {
            return stack;
        }
        TileEntity tile = world.func_147438_o(pos[0], pos[1], pos[2]);
        if (!(tile instanceof TileEntityMachineStrandCaster)) {
            return stack;
        }
        TileEntityMachineStrandCaster caster = (TileEntityMachineStrandCaster)tile;
        return caster.pour(world, x, y, z, dX, dY, dZ, side, stack);
    }

    @Override
    public boolean canAcceptPartialFlow(World world, int x, int y, int z, ForgeDirection side, Mats.MaterialStack stack) {
        return false;
    }

    @Override
    public Mats.MaterialStack flow(World world, int x, int y, int z, ForgeDirection side, Mats.MaterialStack stack) {
        return null;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        int[] coords = this.findCore(world, x, y, z);
        TileEntityMachineStrandCaster cast = (TileEntityMachineStrandCaster)world.func_147438_o(coords[0], coords[1], coords[2]);
        if (cast != null) {
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ModItems.mold && cast.slots[0] == null) {
                cast.slots[0] = player.func_70694_bm().func_77946_l();
                cast.slots[0].field_77994_a = 1;
                --player.func_70694_bm().field_77994_a;
                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "hbm:item.upgradePlug", 1.0f, 1.0f);
                cast.func_70296_d();
                return true;
            }
            if (player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() instanceof ItemTool && player.func_70694_bm().func_77973_b().getToolClasses(player.func_70694_bm()).contains("shovel")) {
                if (cast.amount > 0) {
                    ItemStack scrap = ItemScraps.create(new Mats.MaterialStack(cast.type, cast.amount));
                    if (!player.field_71071_by.func_70441_a(scrap)) {
                        EntityItem item = new EntityItem(world, (double)x + 0.5, (double)y + this.field_149756_F, (double)z + 0.5, scrap);
                        world.func_72838_d((Entity)item);
                    } else {
                        player.field_71069_bz.func_75142_b();
                    }
                    cast.amount = 0;
                    cast.type = null;
                    cast.func_70296_d();
                }
                return true;
            }
        }
        return this.standardOpenBehavior(world, x, y, z, player, 0);
    }

    @Override
    public void func_149749_a(World world, int x, int y, int z, Block b, int i) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityMachineStrandCaster) {
            TileEntityMachineStrandCaster cast = (TileEntityMachineStrandCaster)te;
            if (cast.amount > 0) {
                ItemStack scrap = ItemScraps.create(new Mats.MaterialStack(cast.type, cast.amount));
                EntityItem item = new EntityItem(world, (double)x + 0.5, (double)y + this.field_149756_F, (double)z + 0.5, scrap);
                world.func_72838_d((Entity)item);
                cast.amount = 0;
            }
        }
        super.func_149749_a(world, x, y, z, b, i);
    }

    @Override
    public void printHook(RenderGameOverlayEvent.Pre event, World world, int x, int y, int z) {
        int[] coords = this.findCore(world, x, y, z);
        if (coords == null) {
            return;
        }
        TileEntityMachineStrandCaster cast = (TileEntityMachineStrandCaster)world.func_147438_o(coords[0], coords[1], coords[2]);
        ArrayList<String> text = new ArrayList<String>();
        if (cast != null) {
            if (cast.slots[0] == null) {
                text.add(EnumChatFormatting.RED + I18nUtil.resolveKey("foundry.noCast", new Object[0]));
            } else if (cast.slots[0].func_77973_b() == ModItems.mold) {
                text.add(EnumChatFormatting.BLUE + cast.getInstalledMold().getTitle());
            }
        }
        ILookOverlay.printGeneric(event, I18nUtil.resolveKey(this.func_149739_a() + ".name", new Object[0]), 0xFF4000, 0x401000, text);
    }

    @Override
    protected boolean checkRequirement(World world, int x, int y, int z, ForgeDirection dir, int o) {
        if (!MultiblockHandlerXR.checkSpace(world, x += dir.offsetX * o, y, z += dir.offsetZ * o, this.getDimensions(), x, y, z, dir)) {
            return false;
        }
        return MultiblockHandlerXR.checkSpace(world, x, y, z, new int[]{2, 0, 1, 0, 1, 0}, x, y, z, dir);
    }

    @Override
    public boolean onScrew(World world, EntityPlayer player, int x, int y, int z, int side, float fX, float fY, float fZ, IToolable.ToolType tool) {
        if (tool != IToolable.ToolType.SCREWDRIVER) {
            return false;
        }
        int[] coords = this.findCore(world, x, y, z);
        TileEntityMachineStrandCaster cast = (TileEntityMachineStrandCaster)world.func_147438_o(coords[0], coords[1], coords[2]);
        if (cast.slots[0] == null) {
            return false;
        }
        if (!player.field_71071_by.func_70441_a(cast.slots[0].func_77946_l())) {
            EntityItem item = new EntityItem(world, (double)x + 0.5, (double)y + this.field_149756_F, (double)z + 0.5, cast.slots[0].func_77946_l());
            world.func_72838_d((Entity)item);
        } else {
            player.field_71069_bz.func_75142_b();
        }
        cast.slots[0] = null;
        cast.func_70296_d();
        return true;
    }
}

